/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.ImmutableLongSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractLongSet;

public abstract class AbstractImmutableLongSet
extends AbstractLongSet
implements ImmutableLongSet {
    public ImmutableLongSet newWith(long element) {
        return LongHashSet.newSet(this).with(element).toImmutable();
    }

    public ImmutableLongSet newWithout(long element) {
        return LongHashSet.newSet(this).without(element).toImmutable();
    }

    public ImmutableLongSet newWithAll(LongIterable elements) {
        return LongHashSet.newSet(this).withAll(elements).toImmutable();
    }

    public ImmutableLongSet newWithoutAll(LongIterable elements) {
        return LongHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    public LongSet freeze() {
        return this;
    }

    public ImmutableLongSet toImmutable() {
        return this;
    }

    public RichIterable<LongIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)this);
            } else {
                LongIterator iterator = this.longIterator();
                while (iterator.hasNext()) {
                    MutableLongSet batch = LongSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

