/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.dataset;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryWrapper;
import org.eclipse.rdf4j.repository.dataset.DatasetRepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;

public class DatasetRepository
extends RepositoryWrapper {
    private final Map<URL, Long> lastModified = new ConcurrentHashMap<URL, Long>();

    public DatasetRepository() {
    }

    public DatasetRepository(SailRepository delegate) {
        super(delegate);
    }

    @Override
    public void setDelegate(Repository delegate) {
        if (!(delegate instanceof SailRepository)) {
            throw new IllegalArgumentException("delegate must be a SailRepository, is: " + String.valueOf(delegate.getClass()));
        }
        super.setDelegate(delegate);
    }

    @Override
    public SailRepository getDelegate() {
        return (SailRepository)super.getDelegate();
    }

    @Override
    public RepositoryConnection getConnection() throws RepositoryException {
        return new DatasetRepositoryConnection(this, this.getDelegate().getConnection());
    }

    public void loadDataset(URL url, IRI context, ParserConfig config) throws RepositoryException {
        try {
            Long since = this.lastModified.get(url);
            URLConnection urlCon = url.openConnection();
            if (since != null) {
                urlCon.setIfModifiedSince(since);
            }
            if (since == null || since < urlCon.getLastModified()) {
                this.load(url, urlCon, context, config);
            }
        }
        catch (IOException | RDFParseException e) {
            throw new RepositoryException(e);
        }
    }

    private synchronized void load(URL url, URLConnection urlCon, IRI context, ParserConfig config) throws RepositoryException, RDFParseException, IOException {
        long modified = urlCon.getLastModified();
        if (this.lastModified.containsKey(url) && this.lastModified.get(url) >= modified) {
            return;
        }
        String mimeType = urlCon.getContentType();
        int semiColonIdx = mimeType.indexOf(59);
        if (semiColonIdx >= 0) {
            mimeType = mimeType.substring(0, semiColonIdx);
        }
        RDFFormat format = Rio.getParserFormatForMIMEType(mimeType).orElse(Rio.getParserFormatForFileName(url.getPath()).orElseThrow(Rio.unsupportedFormat(mimeType)));
        try (InputStream stream = urlCon.getInputStream();
             RepositoryConnection repCon = super.getConnection();){
            repCon.setParserConfig(config);
            repCon.begin();
            repCon.clear(context);
            repCon.add(stream, url.toExternalForm(), format, context);
            repCon.commit();
            this.lastModified.put(url, modified);
        }
    }
}

