/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.structures;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.Dataset;

public class FedXDataset
implements Dataset {
    protected final Dataset delegate;
    protected Set<String> endpoints = new HashSet<String>();

    public FedXDataset(Dataset delegate) {
        this.delegate = delegate;
    }

    public void addEndpoint(String endpointId) {
        this.endpoints.add(endpointId);
    }

    public void addEndpoints(Collection<String> endpointIDs) {
        this.endpoints.addAll(endpointIDs);
    }

    public Set<String> getEndpoints() {
        return Collections.unmodifiableSet(this.endpoints);
    }

    @Override
    public Set<IRI> getDefaultGraphs() {
        if (this.delegate == null) {
            return Collections.emptySet();
        }
        return this.delegate.getDefaultGraphs();
    }

    @Override
    public IRI getDefaultInsertGraph() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getDefaultInsertGraph();
    }

    @Override
    public Set<IRI> getDefaultRemoveGraphs() {
        if (this.delegate == null) {
            return Collections.emptySet();
        }
        return this.delegate.getDefaultRemoveGraphs();
    }

    @Override
    public Set<IRI> getNamedGraphs() {
        if (this.delegate == null) {
            return Collections.emptySet();
        }
        return this.delegate.getNamedGraphs();
    }
}

