/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.optimizer;

import org.eclipse.rdf4j.federated.algebra.FedXStatementPattern;
import org.eclipse.rdf4j.federated.exception.OptimizationException;
import org.eclipse.rdf4j.federated.optimizer.FedXOptimizer;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractSimpleQueryModelVisitor;

public class LimitOptimizer
extends AbstractSimpleQueryModelVisitor<OptimizationException>
implements FedXOptimizer {
    private long applicableLimitInScope = -1L;

    public LimitOptimizer() {
        super(true);
    }

    @Override
    public void optimize(TupleExpr tupleExpr) {
        try {
            tupleExpr.visit(this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void meetOther(QueryModelNode node) throws OptimizationException {
        super.meetOther(node);
    }

    @Override
    public void meet(Slice node) throws OptimizationException {
        if (!node.hasOffset()) {
            this.applicableLimitInScope = node.getLimit();
        }
        super.meet(node);
        TupleExpr expr = node.getArg();
        if (expr instanceof FedXStatementPattern && this.applicableLimitInScope > 0L) {
            this.pushLimit((FedXStatementPattern)expr, this.applicableLimitInScope);
        }
        this.applicableLimitInScope = -1L;
    }

    @Override
    public void meet(Projection proj) throws OptimizationException {
        TupleExpr expr = proj.getArg();
        if (expr instanceof FedXStatementPattern && this.applicableLimitInScope > 0L) {
            this.pushLimit((FedXStatementPattern)expr, this.applicableLimitInScope);
        }
    }

    protected void pushLimit(FedXStatementPattern stmt, long upperLimit) {
        stmt.setUpperLimit(upperLimit);
    }
}

