/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointManager {
    protected static final Logger log = LoggerFactory.getLogger(EndpointManager.class);
    protected HashMap<String, Endpoint> endpoints = new HashMap();
    protected boolean inRepair = false;
    protected Long lastRepaired = -1L;

    public static synchronized EndpointManager initialize(List<Endpoint> endpoints) {
        return new EndpointManager(endpoints);
    }

    private EndpointManager() {
        this(null);
    }

    private EndpointManager(List<Endpoint> endpoints) {
        this.init(endpoints);
    }

    private void init(List<Endpoint> _endpoints) {
        if (_endpoints != null) {
            for (Endpoint e : _endpoints) {
                this.addEndpoint(e);
            }
        }
    }

    public void addEndpoint(Endpoint e) {
        this.endpoints.put(e.getId(), e);
    }

    protected void removeEndpoint(Endpoint e) throws NoSuchElementException {
        if (!this.endpoints.containsKey(e.getId())) {
            throw new NoSuchElementException("No endpoint avalaible for id " + e.getId());
        }
        this.endpoints.remove(e.getId());
    }

    public Collection<Endpoint> getAvailableEndpoints() {
        return this.endpoints.values();
    }

    public Endpoint getEndpoint(String endpointID) {
        return this.endpoints.get(endpointID);
    }

    public Endpoint getEndpointByUrl(String endpointUrl) {
        for (Endpoint e : this.endpoints.values()) {
            if (!e.getEndpoint().equals(endpointUrl)) continue;
            return e;
        }
        return null;
    }

    public Endpoint getEndpointByName(String endpointName) {
        for (Endpoint e : this.endpoints.values()) {
            if (!e.getName().equals(endpointName)) continue;
            return e;
        }
        return null;
    }

    public List<Endpoint> getEndpoints(Set<String> endpointIDs) throws NoSuchElementException {
        ArrayList<Endpoint> res = new ArrayList<Endpoint>();
        for (String endpointID : endpointIDs) {
            Endpoint e = this.endpoints.get(endpointID);
            if (e == null) {
                throw new NoSuchElementException("No endpoint found for " + endpointID + ".");
            }
            res.add(e);
        }
        return res;
    }
}

