/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.json;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.lang.Utils;
import no.hasmac.rdf.io.nquad.NQuadsWriter;

public final class JsonCanonicalizer {
    private static final DecimalFormat eFormatBigDecimal = new DecimalFormat("0E00", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final DecimalFormat eFormat = new DecimalFormat("0.#######", new DecimalFormatSymbols(Locale.ENGLISH));

    private JsonCanonicalizer() {
    }

    public static String canonicalize(JsonValue value) {
        StringWriter writer = new StringWriter();
        try {
            JsonCanonicalizer.canonicalize(value, writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static void canonicalize(JsonValue value, Writer writer) throws IOException {
        if (JsonUtils.isNull(value)) {
            writer.write("null");
        } else if (JsonUtils.isScalar(value)) {
            if (JsonUtils.isNumber(value)) {
                JsonCanonicalizer.canonicalizeNumber((JsonNumber)value, writer);
            } else {
                writer.write(value.toString());
            }
        } else if (JsonUtils.isArray(value)) {
            JsonCanonicalizer.canonicalizeArray(value.asJsonArray(), writer);
        } else if (JsonUtils.isObject(value)) {
            JsonCanonicalizer.canonicalizeObject(value.asJsonObject(), writer);
        }
    }

    private static void canonicalizeNumber(JsonNumber number, Writer writer) throws IOException {
        String numberString = number.bigDecimalValue().compareTo(BigDecimal.ZERO) == 0 ? "0" : (number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointRight(21)) >= 0 ? eFormatBigDecimal.format(number.bigDecimalValue()).replace("E", "e+") : (number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointLeft(21)) <= 0 ? eFormatBigDecimal.format(number.bigDecimalValue()).toLowerCase() : eFormat.format(number.bigDecimalValue())));
        writer.write(numberString);
    }

    private static void canonicalizeArray(JsonArray value, Writer writer) throws IOException {
        boolean next = false;
        writer.write("[");
        for (JsonValue item : value.asJsonArray()) {
            if (next) {
                writer.write(",");
            }
            JsonCanonicalizer.canonicalize(item, writer);
            next = true;
        }
        writer.write("]");
    }

    private static void canonicalizeObject(JsonObject value, Writer writer) throws IOException {
        boolean next = false;
        writer.write("{");
        for (String propertyName : Utils.index(value.keySet(), true)) {
            if (next) {
                writer.write(",");
            }
            writer.write("\"");
            writer.write(NQuadsWriter.escape(propertyName));
            writer.write("\":");
            JsonValue propertyValue = (JsonValue)value.get((Object)propertyName);
            JsonCanonicalizer.canonicalize(propertyValue, writer);
            next = true;
        }
        writer.write("}");
    }
}

