/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.rdf.impl;

import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import no.hasmac.jsonld.StringUtils;
import no.hasmac.jsonld.http.media.MediaType;
import no.hasmac.rdf.RdfDataset;
import no.hasmac.rdf.RdfGraph;
import no.hasmac.rdf.RdfLiteral;
import no.hasmac.rdf.RdfNQuad;
import no.hasmac.rdf.RdfResource;
import no.hasmac.rdf.RdfTriple;
import no.hasmac.rdf.RdfValue;
import no.hasmac.rdf.impl.RdfDatasetImpl;
import no.hasmac.rdf.impl.RdfGraphImpl;
import no.hasmac.rdf.impl.RdfLiteralImpl;
import no.hasmac.rdf.impl.RdfNQuadImpl;
import no.hasmac.rdf.impl.RdfResourceImpl;
import no.hasmac.rdf.impl.RdfTripleImpl;
import no.hasmac.rdf.io.RdfReader;
import no.hasmac.rdf.io.RdfWriter;
import no.hasmac.rdf.io.error.UnsupportedContentException;
import no.hasmac.rdf.io.nquad.NQuadsReader;
import no.hasmac.rdf.io.nquad.NQuadsWriter;
import no.hasmac.rdf.spi.RdfProvider;

public final class DefaultRdfProvider
extends RdfProvider {
    public static final RdfProvider INSTANCE = new DefaultRdfProvider();
    private static final Collection<MediaType> CAN_READWRITE = Arrays.asList(MediaType.N_QUADS);

    @Override
    public RdfDataset createDataset() {
        return new RdfDatasetImpl();
    }

    @Override
    public RdfReader createReader(MediaType contentType, Reader reader) throws UnsupportedContentException {
        if (reader == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        if (MediaType.N_QUADS.match(contentType)) {
            return new NQuadsReader(reader);
        }
        throw new UnsupportedContentException(contentType.toString());
    }

    @Override
    public RdfWriter createWriter(MediaType contentType, Writer writer) throws UnsupportedContentException {
        if (writer == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        if (MediaType.N_QUADS.match(contentType)) {
            return new NQuadsWriter(writer);
        }
        throw new UnsupportedContentException(contentType.toString());
    }

    @Override
    public RdfGraph createGraph() {
        return new RdfGraphImpl();
    }

    @Override
    public RdfTriple createTriple(RdfResource subject, RdfResource predicate, RdfValue object) {
        if (subject == null || predicate == null || object == null) {
            throw new IllegalArgumentException();
        }
        return new RdfTripleImpl(subject, predicate, object);
    }

    @Override
    public RdfNQuad createQuad(RdfResource subject, RdfResource predicate, RdfValue object, RdfResource graphName) {
        if (subject == null || predicate == null || object == null) {
            throw new IllegalArgumentException();
        }
        return new RdfNQuadImpl(subject, predicate, object, graphName);
    }

    @Override
    public RdfNQuad createQuad(RdfTriple rdfTriple, RdfResource graphName) {
        return this.createQuad(rdfTriple.getSubject(), rdfTriple.getPredicate(), rdfTriple.getObject(), graphName);
    }

    @Override
    public RdfResource createBlankNode(String value) {
        if (value == null || DefaultRdfProvider.isBlank(value)) {
            throw new IllegalArgumentException();
        }
        if (!value.startsWith("_:")) {
            return new RdfResourceImpl("_:" + value, true);
        }
        return new RdfResourceImpl(value, true);
    }

    @Override
    public RdfResource createIRI(String value) {
        if (value == null || DefaultRdfProvider.isBlank(value)) {
            throw new IllegalArgumentException();
        }
        return new RdfResourceImpl(value, false);
    }

    @Override
    public RdfLiteral createLangString(String lexicalForm, String langTag) {
        if (lexicalForm == null) {
            throw new IllegalArgumentException();
        }
        return new RdfLiteralImpl(lexicalForm, langTag, null);
    }

    @Override
    public RdfLiteral createTypedLiteral(String lexicalForm, String datatype) {
        if (lexicalForm == null) {
            throw new IllegalArgumentException();
        }
        return new RdfLiteralImpl(lexicalForm, null, datatype);
    }

    @Override
    public RdfLiteral createString(String lexicalForm) {
        return new RdfLiteralImpl(lexicalForm, null, "http://www.w3.org/2001/XMLSchema#string");
    }

    @Override
    public Collection<MediaType> canRead() {
        return CAN_READWRITE;
    }

    @Override
    public Collection<MediaType> canWrite() {
        return CAN_READWRITE;
    }

    private static boolean isBlank(String value) {
        return value.isEmpty() || StringUtils.isBlank(value) && value.chars().noneMatch(ch -> ch == 10 || ch == 13 || ch == 9 || ch == 12);
    }
}

