/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.endpoint.provider;

import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.EndpointClassification;
import org.eclipse.rdf4j.federated.endpoint.ManagedRepositoryEndpoint;
import org.eclipse.rdf4j.federated.endpoint.RepositoryEndpoint;
import org.eclipse.rdf4j.federated.endpoint.provider.EndpointProvider;
import org.eclipse.rdf4j.federated.endpoint.provider.RepositoryInformation;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;

public class RepositoryEndpointProvider
implements EndpointProvider<RepositoryInformation> {
    protected final Repository repository;

    public RepositoryEndpointProvider(Repository repository) {
        this.repository = repository;
    }

    @Override
    public Endpoint loadEndpoint(RepositoryInformation repoInfo) throws FedXException {
        try {
            boolean didInitialize = false;
            try {
                if (!this.repository.isInitialized()) {
                    this.repository.init();
                    didInitialize = true;
                }
            }
            finally {
                if (didInitialize) {
                    this.repository.shutDown();
                }
            }
            RepositoryEndpoint res = this.repository.isInitialized() ? new RepositoryEndpoint(repoInfo, repoInfo.getLocation(), EndpointClassification.Remote, this.repository) : new ManagedRepositoryEndpoint(repoInfo, repoInfo.getLocation(), EndpointClassification.Remote, this.repository);
            res.setEndpointConfiguration(repoInfo.getEndpointConfiguration());
            return res;
        }
        catch (RepositoryException e) {
            throw new FedXException("Repository " + repoInfo.getId() + " could not be initialized: " + e.getMessage(), e);
        }
    }
}

