/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core.query;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.sparqlbuilder.core.Base;
import org.eclipse.rdf4j.sparqlbuilder.core.Prefix;
import org.eclipse.rdf4j.sparqlbuilder.core.PrefixDeclarations;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElement;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.TriplesTemplate;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphName;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.util.SparqlBuilderUtils;

abstract class UpdateQuery<T extends UpdateQuery<T>>
implements QueryElement {
    private Optional<Base> base = Optional.empty();
    private Optional<PrefixDeclarations> prefixes = Optional.empty();

    UpdateQuery() {
    }

    public T base(Iri iri) {
        this.base = Optional.of(SparqlBuilder.base(iri));
        return (T)this;
    }

    public T base(IRI iri) {
        return this.base(Rdf.iri(iri));
    }

    public T base(Base base) {
        this.base = Optional.of(base);
        return (T)this;
    }

    public T prefix(Prefix ... prefixes) {
        this.prefixes = SparqlBuilderUtils.getOrCreateAndModifyOptional(this.prefixes, () -> SparqlBuilder.prefixes(new Prefix[0]), p -> p.addPrefix(prefixes));
        return (T)this;
    }

    public T prefix(Namespace ... namespaces) {
        return this.prefix(Arrays.stream(namespaces).map(n -> SparqlBuilder.prefix(n)).collect(Collectors.toList()).toArray(new Prefix[namespaces.length]));
    }

    public T prefix(PrefixDeclarations prefixes) {
        this.prefixes = Optional.of(prefixes);
        return (T)this;
    }

    protected abstract String getQueryActionString();

    @Override
    public String getQueryString() {
        StringBuilder query = new StringBuilder();
        SparqlBuilderUtils.appendAndNewlineIfPresent(this.base, query);
        SparqlBuilderUtils.appendAndNewlineIfPresent(this.prefixes, query);
        String queryString = this.getQueryActionString();
        if (this.prefixes.isPresent()) {
            queryString = this.prefixes.get().replacePrefixesInQuery(queryString);
        }
        query.append(queryString);
        return query.toString();
    }

    protected void appendNamedTriplesTemplates(StringBuilder queryString, Optional<GraphName> graphName, TriplesTemplate triples) {
        queryString.append(graphName.map(graph -> SparqlBuilderUtils.getBracedString("GRAPH " + graph.getQueryString() + " " + triples.getQueryString())).orElseGet(triples::getQueryString));
    }
}

