/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.repository.base.AbstractRepository;
import org.eclipse.rdf4j.repository.base.AbstractRepositoryConnection;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;

public class RepositoryConfigRepository
extends AbstractRepository {
    public static final String ID = "SYSTEM";
    private final RepositoryManager manager;

    public RepositoryConfigRepository(RepositoryManager manager) {
        this.manager = manager;
    }

    @Override
    public void setDataDir(File dataDir) {
    }

    @Override
    public File getDataDir() {
        return null;
    }

    @Override
    public boolean isWritable() throws RepositoryException {
        return true;
    }

    @Override
    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    @Override
    protected void initializeInternal() throws RepositoryException {
    }

    @Override
    protected void shutDownInternal() throws RepositoryException {
    }

    @Override
    public RepositoryConnection getConnection() throws RepositoryException {
        return new AbstractRepositoryConnection(this){
            private boolean active;
            private Model committed;
            private Model added;
            private Model removed;
            {
                this.active = false;
                this.committed = this.loadModel();
                this.added = new TreeModel();
                this.removed = new TreeModel();
            }

            @Override
            public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
                LinkedHashSet contextIDs = new LinkedHashSet();
                RepositoryConfigRepository.this.manager.getRepositoryIDs().forEach(id -> contextIDs.add(this.getContext((String)id)));
                CloseableIteratorIteration iter = new CloseableIteratorIteration(contextIDs.iterator());
                return new RepositoryResult<Resource>(iter);
            }

            @Override
            public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
                CloseableIteratorIteration iter = new CloseableIteratorIteration(this.committed.getStatements(subj, pred, obj, contexts).iterator());
                return new RepositoryResult<Statement>(iter);
            }

            @Override
            public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
                Model model = this.committed.filter(subj, pred, obj, contexts);
                handler.startRDF();
                model.getNamespaces().forEach(ns -> handler.handleNamespace(ns.getPrefix(), ns.getName()));
                model.forEach(st -> handler.handleStatement((Statement)st));
                handler.endRDF();
            }

            @Override
            public long size(Resource ... contexts) throws RepositoryException {
                return this.committed.filter(null, null, null, contexts).size();
            }

            @Override
            public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
                return this.active;
            }

            @Override
            public void begin() throws RepositoryException {
                this.active = true;
            }

            @Override
            public void prepare() throws RepositoryException {
            }

            @Override
            public void commit() throws RepositoryException {
                LinkedHashSet<String> ids = new LinkedHashSet<String>();
                ids.addAll(RepositoryConfigRepository.this.manager.getRepositoryIDs());
                ids.addAll(RepositoryConfigUtil.getRepositoryIDs(this.added));
                ids.forEach(id -> {
                    Resource ctx = this.getContext((String)id);
                    Model less = this.removed.filter(null, null, null, ctx);
                    Model more = this.added.filter(null, null, null, ctx);
                    Model alt = RepositoryConfigUtil.getRepositoryConfigModel(this.added, id);
                    if (!less.isEmpty() || !more.isEmpty() || alt != null) {
                        TreeModel model = new TreeModel(this.committed.filter(null, null, null, this.getContext((String)id)));
                        model.removeAll(less);
                        this.removed.getNamespaces().forEach(ns -> model.removeNamespace(ns.getPrefix()));
                        this.added.getNamespaces().forEach(ns -> model.setNamespace((Namespace)ns));
                        model.addAll(more);
                        if (alt != null) {
                            model.addAll(alt);
                        }
                        if (model.isEmpty()) {
                            RepositoryConfigRepository.this.manager.removeRepository((String)id);
                        } else {
                            RepositoryConfigRepository.this.manager.addRepositoryConfig(RepositoryConfigUtil.getRepositoryConfig(model, id));
                        }
                    }
                });
                this.committed = this.loadModel();
                this.rollback();
            }

            @Override
            public void rollback() throws RepositoryException {
                this.added.clear();
                this.added.getNamespaces().clear();
                this.removed.clear();
                this.removed.getNamespaces().clear();
                this.active = false;
            }

            @Override
            public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
                CloseableIteratorIteration iter = new CloseableIteratorIteration(this.committed.getNamespaces().iterator());
                return new RepositoryResult<Namespace>(iter);
            }

            @Override
            public String getNamespace(String prefix) throws RepositoryException {
                Optional<Namespace> ns = this.committed.getNamespace(prefix);
                if (ns.isPresent()) {
                    return ns.get().getName();
                }
                return null;
            }

            @Override
            public void setNamespace(String prefix, String name) throws RepositoryException {
                this.removed.removeNamespace(prefix);
                this.added.setNamespace(prefix, name);
            }

            @Override
            public void removeNamespace(String prefix) throws RepositoryException {
                this.added.removeNamespace(prefix);
                Optional<Namespace> ns = this.committed.getNamespace(prefix);
                if (ns.isPresent()) {
                    this.removed.setNamespace(ns.get());
                }
            }

            @Override
            public void clearNamespaces() throws RepositoryException {
                this.added.getNamespaces().clear();
                this.committed.getNamespaces().forEach(ns -> this.removed.setNamespace((Namespace)ns));
            }

            @Override
            public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
                throw this.unsupported();
            }

            @Override
            public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
                throw this.unsupported();
            }

            @Override
            public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
                throw this.unsupported();
            }

            @Override
            public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
                throw this.unsupported();
            }

            @Override
            public Update prepareUpdate(QueryLanguage ql, String update, String baseURI) throws RepositoryException, MalformedQueryException {
                throw this.unsupported();
            }

            @Override
            protected void addWithoutCommit(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
                this.added.add(subj, pred, obj, contexts);
            }

            @Override
            protected void removeWithoutCommit(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
                Model model = this.committed.filter(subj, pred, obj, contexts);
                this.removed.addAll(model);
            }

            private Model loadModel() {
                TreeModel model = new TreeModel();
                RepositoryConfigRepository.this.manager.getRepositoryIDs().forEach(id -> {
                    Resource ctx = this.getContext((String)id);
                    RepositoryConfig config = RepositoryConfigRepository.this.manager.getRepositoryConfig((String)id);
                    TreeModel cfg = new TreeModel();
                    config.export(cfg, ctx);
                    cfg.getNamespaces().forEach(ns -> model.setNamespace((Namespace)ns));
                    cfg.forEach(st -> model.add(st.getSubject(), st.getPredicate(), st.getObject(), ctx));
                });
                return model;
            }

            private Resource getContext(String repositoryID) {
                String location;
                try {
                    location = RepositoryConfigRepository.this.manager.getLocation().toURI().toString();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    assert (false);
                    location = "urn:" + repositoryID;
                }
                String url = Protocol.getRepositoryLocation(location, repositoryID);
                return this.getValueFactory().createIRI(url + "#" + repositoryID);
            }

            private UnsupportedOperationException unsupported() {
                return new UnsupportedOperationException("Query operations are not supported on the SYSTEM repository");
            }
        };
    }
}

