/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IIdentifiable;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IVersionable;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.RequirementHelper;
import org.osgi.framework.Version;

public class BundleLauncherHelper {
    public static final char VERSION_SEPARATOR = '*';
    private static final char START_LEVEL_SEPARATOR = '@';
    private static final String AUTO_START_SEPARATOR = ":";
    private static final String DEFAULT = "default";
    private static final String DEFAULT_START_LEVELS = "default:default";
    private static final String FEATURE_PLUGIN_RESOLUTION_SEPARATOR = ":";
    private static final String FEATURES_ADDITIONAL_PLUGINS_DATA_SEPARATOR = ":";
    public static final String DEFAULT_UPDATE_CONFIGURATOR_START_LEVEL_TEXT = "3";
    public static final String DEFAULT_UPDATE_CONFIGURATOR_AUTO_START_TEXT = "true";
    public static final String DEFAULT_UPDATE_CONFIGURATOR_START_LEVEL = "3:true";
    private static final Comparator<IFeature> NEUTRAL_COMPARATOR = Comparator.comparing(f -> 0);
    private static final Predicate<IPluginModelBase> ENABLED_VALID_PLUGIN_FILTER = p -> p.getBundleDescription() != null && p.isEnabled();
    private static final Function<IPluginModelBase, String> GET_PLUGIN_VERSION = m -> m.getPluginBase().getVersion();
    private static final Comparator<IPluginModelBase> COMPARE_PLUGIN_RESOLVED = Comparator.comparing(p -> p.getBundleDescription().isResolved());
    private static final BiPredicate<List<Version>, Version> CONTAINS_SAME_VERSION = List::contains;
    private static final BiPredicate<List<Version>, Version> CONTAINS_SAME_MMM_VERSION = (versions, toAdd) -> versions.stream().anyMatch(v -> VersionUtil.compareMacroMinorMicro((Version)toAdd, (Version)v) == 0);
    static final Comparator<IPluginModelBase> VERSION = Comparator.comparing(BundleLauncherHelper::getVersion);
    private static final Map<String, String> AUTO_STARTED_BUNDLE_LEVELS = Map.ofEntries(Map.entry("org.eclipse.equinox.ds", "1"), Map.entry("org.eclipse.equinox.simpleconfigurator", "1"), Map.entry("org.eclipse.equinox.common", "2"), Map.entry("org.eclipse.osgi", "1"), Map.entry("org.eclipse.core.runtime", "default"), Map.entry("org.apache.felix.scr", "1"));

    private BundleLauncherHelper() {
    }

    public static Map<IPluginModelBase, String> getWorkspaceBundleMap(ILaunchConfiguration configuration) throws CoreException {
        return BundleLauncherHelper.getWorkspaceBundleMap(configuration, new HashMap<String, List<Version>>());
    }

    public static Map<IPluginModelBase, String> getMergedBundleMap(ILaunchConfiguration configuration, boolean osgi) throws CoreException {
        return BundleLauncherHelper.getMergedBundleMap(configuration, osgi, null);
    }

    public static Map<IPluginModelBase, String> getMergedBundleMap(ILaunchConfiguration configuration, boolean osgi, Map<IFeature, Boolean> features) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = BundleLauncherHelper.getWorkingCopy(configuration);
        if (!osgi) {
            BundleLauncherHelper.migrateLaunchConfiguration(wc);
            if (wc.getAttribute(DEFAULT, true)) {
                LinkedHashMap<IPluginModelBase, String> map = new LinkedHashMap<IPluginModelBase, String>();
                IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getActiveModels();
                int n = iPluginModelBaseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginModelBase model = iPluginModelBaseArray[n2];
                    if (!BundleLauncherHelper.isFragmentForOtherPlatform(model)) {
                        BundleLauncherHelper.addBundleToMap(map, model, DEFAULT_START_LEVELS);
                    }
                    ++n2;
                }
                if (features != null) {
                    ITargetDefinition target = ((ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class)).getWorkspaceTargetDefinition();
                    FeatureModelManager fmm = PDECore.getDefault().getFeatureModelManager();
                    Stream.concat(Arrays.stream(fmm.getWorkspaceModels()), Arrays.stream(fmm.getExternalModels())).map(m -> m.getFeature()).filter(f -> f.matchesEnvironment(target)).forEach(f -> {
                        Boolean bl = features.put((IFeature)f, Boolean.FALSE);
                    });
                }
                return map;
            }
        } else {
            BundleLauncherHelper.migrateOsgiLaunchConfiguration(wc);
        }
        if (wc.getAttribute("useCustomFeatures", false)) {
            return BundleLauncherHelper.getMergedBundleMapFeatureBased((ILaunchConfiguration)wc, features);
        }
        Map<IPluginModelBase, String> selectedBundles = BundleLauncherHelper.getAllSelectedPluginBundles((ILaunchConfiguration)wc);
        boolean autoAddRequirements = configuration.getAttribute("automaticIncludeRequirements", false);
        if (autoAddRequirements) {
            BundleLauncherHelper.addRequiredBundles(selectedBundles, configuration);
        }
        return selectedBundles;
    }

    private static boolean isFragmentForOtherPlatform(IPluginModelBase model) {
        return model.isFragmentModel() && !model.getBundleDescription().isResolved() && !TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model);
    }

    public static Map<IPluginModelBase, String> getAllSelectedPluginBundles(ILaunchConfiguration config) throws CoreException {
        HashMap<String, List<Version>> idVersions = new HashMap<String, List<Version>>();
        Map<IPluginModelBase, String> map = BundleLauncherHelper.getWorkspaceBundleMap(config, idVersions);
        map.putAll(BundleLauncherHelper.getTargetBundleMap(config, idVersions));
        return map;
    }

    private static void addRequiredBundles(Map<IPluginModelBase, String> bundle2startLevel, ILaunchConfiguration configuration) throws CoreException {
        List<String> appRequirements = RequirementHelper.getApplicationLaunchRequirements(configuration);
        RequirementHelper.addApplicationLaunchRequirements(appRequirements, configuration, bundle2startLevel);
        boolean includeOptional = configuration.getAttribute("includeOptional", true);
        BundleLauncherHelper.computeDependencies(bundle2startLevel.keySet(), includeOptional, true).forEach(p -> BundleLauncherHelper.addDefaultStartingBundle(bundle2startLevel, p));
    }

    private static Map<IPluginModelBase, String> getMergedBundleMapFeatureBased(ILaunchConfiguration configuration, Map<IFeature, Boolean> features) throws CoreException {
        String defaultPluginResolution = configuration.getAttribute("featurePluginResolution", "workspace");
        ITargetDefinition target = ((ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class)).getWorkspaceTargetDefinition();
        boolean addRequirements = configuration.getAttribute("automaticIncludeRequirements", true);
        Map<IFeature, String> feature2resolution = BundleLauncherHelper.getSelectedFeatures(configuration, target, addRequirements);
        if (features != null) {
            Set rootFeatures = configuration.getAttribute("root_features", Collections.emptySet());
            for (IFeature feature2 : feature2resolution.keySet()) {
                features.put(feature2, rootFeatures.contains(feature2.getId()));
            }
        }
        HashSet<IPluginModelBase> launchPlugins = new HashSet<IPluginModelBase>();
        feature2resolution.forEach((feature, pluginResolution) -> {
            IFeaturePlugin[] featurePlugins;
            if (DEFAULT.equalsIgnoreCase((String)pluginResolution)) {
                pluginResolution = defaultPluginResolution;
            }
            IFeaturePlugin[] iFeaturePluginArray = featurePlugins = feature.getPlugins();
            int n = featurePlugins.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase plugin;
                IFeaturePlugin featurePlugin = iFeaturePluginArray[n2];
                if (featurePlugin.matchesEnvironment(target) && (plugin = BundleLauncherHelper.getIncludedPlugin(featurePlugin.getId(), featurePlugin.getVersion(), pluginResolution)) != null) {
                    launchPlugins.add(plugin);
                }
                ++n2;
            }
            if (addRequirements) {
                IFeatureImport[] featureImports;
                IFeatureImport[] iFeatureImportArray = featureImports = feature.getImports();
                int n3 = featureImports.length;
                n = 0;
                while (n < n3) {
                    IPluginModelBase plugin;
                    IFeatureImport featureImport = iFeatureImportArray[n];
                    if (featureImport.getType() == 0 && featureImport.matchesEnvironment(target) && (plugin = BundleLauncherHelper.getRequiredPlugin(featureImport.getId(), featureImport.getVersion(), featureImport.getMatch(), pluginResolution)) != null) {
                        launchPlugins.add(plugin);
                    }
                    ++n;
                }
            }
        });
        Map<IPluginModelBase, AdditionalPluginData> additionalPlugins = BundleLauncherHelper.getAdditionalPlugins(configuration, true);
        launchPlugins.addAll(additionalPlugins.keySet());
        if (addRequirements) {
            List<String> appRequirements = RequirementHelper.getApplicationLaunchRequirements(configuration);
            RequirementHelper.addApplicationLaunchRequirements(appRequirements, configuration, launchPlugins, launchPlugins::add);
            BundleLauncherHelper.computeDependencies(launchPlugins, false, BundleLauncherHelper.isWorkspace(defaultPluginResolution)).forEach(launchPlugins::add);
        }
        LinkedHashMap<IPluginModelBase, String> map = new LinkedHashMap<IPluginModelBase, String>();
        for (IPluginModelBase model : launchPlugins) {
            AdditionalPluginData additionalPluginData = additionalPlugins.get(model);
            String startLevels = additionalPluginData != null ? additionalPluginData.startLevels() : DEFAULT_START_LEVELS;
            BundleLauncherHelper.addBundleToMap(map, model, startLevels);
        }
        return map;
    }

    private static Map<IFeature, String> getSelectedFeatures(ILaunchConfiguration configuration, ITargetDefinition target, boolean addRequirements) throws CoreException {
        String featureLocation = configuration.getAttribute("featureDefaultLocation", "workspace");
        Predicate<IFeature> targetEnvironmentFilter = f -> f.matchesEnvironment(target);
        Map<String, List<List<IFeature>>> featureMaps = BundleLauncherHelper.getPrioritizedAvailableFeatures(featureLocation);
        Set selectedFeatures = configuration.getAttribute("selected_features", Collections.emptySet());
        HashMap<IFeature, String> feature2pluginResolution = new HashMap<IFeature, String>();
        ArrayDeque<IFeature> pendingFeatures = new ArrayDeque<IFeature>();
        for (String currentSelected : selectedFeatures) {
            String[] attributes = currentSelected.split(":");
            if (attributes.length <= 1) continue;
            String id = attributes[0];
            String pluginResolution2 = attributes[1];
            IFeature feature = BundleLauncherHelper.getRequiredFeature(id, null, 4, targetEnvironmentFilter, featureMaps);
            BundleLauncherHelper.addFeatureIfAbsent(feature, pluginResolution2, feature2pluginResolution, pendingFeatures);
        }
        while (!pendingFeatures.isEmpty()) {
            IFeatureImport[] featureImports;
            IFeatureChild[] includedFeatures;
            IFeature feature = (IFeature)pendingFeatures.remove();
            String pluginResolution = (String)feature2pluginResolution.get(feature);
            IFeatureChild[] iFeatureChildArray = includedFeatures = feature.getIncludedFeatures();
            int n = includedFeatures.length;
            int pluginResolution2 = 0;
            while (pluginResolution2 < n) {
                IFeatureChild featureChild = iFeatureChildArray[pluginResolution2];
                if (featureChild.matchesEnvironment(target)) {
                    IFeature child = BundleLauncherHelper.getIncludedFeature(featureChild.getId(), featureChild.getVersion(), targetEnvironmentFilter, featureMaps);
                    BundleLauncherHelper.addFeatureIfAbsent(child, pluginResolution, feature2pluginResolution, pendingFeatures);
                }
                ++pluginResolution2;
            }
            if (!addRequirements) continue;
            IFeatureImport[] iFeatureImportArray = featureImports = feature.getImports();
            int n2 = featureImports.length;
            n = 0;
            while (n < n2) {
                IFeatureImport featureImport = iFeatureImportArray[n];
                if (featureImport.getType() == 1) {
                    IFeature dependency = BundleLauncherHelper.getRequiredFeature(featureImport.getId(), featureImport.getVersion(), featureImport.getMatch(), targetEnvironmentFilter, featureMaps);
                    BundleLauncherHelper.addFeatureIfAbsent(dependency, pluginResolution, feature2pluginResolution, pendingFeatures);
                }
                ++n;
            }
        }
        return feature2pluginResolution;
    }

    private static Map<String, List<List<IFeature>>> getPrioritizedAvailableFeatures(String featureLocation) {
        FeatureModelManager fmm = PDECore.getDefault().getFeatureModelManager();
        List<IFeatureModel[]> featureModelsPerLocation = BundleLauncherHelper.isWorkspace(featureLocation) ? List.of(fmm.getWorkspaceModels(), fmm.getExternalModels()) : Collections.singletonList(fmm.getExternalModels());
        HashMap<String, List<List<IFeature>>> featureMaps = new HashMap<String, List<List<IFeature>>>();
        for (IFeatureModel[] featureModels : featureModelsPerLocation) {
            Map<String, List<IFeature>> id2feature = Arrays.stream(featureModels).map(IFeatureModel::getFeature).filter(f -> {
                if (f.getId() == null) {
                    IResource resource = f.getModel().getUnderlyingResource();
                    PDELaunchingPlugin.log(Status.warning((String)(resource != null ? NLS.bind((String)PDEMessages.BundleLauncherHelper_workspaceFeatureWithIdNull, (Object)resource.getProject().getName(), (Object)resource.getProjectRelativePath()) : NLS.bind((String)PDEMessages.BundleLauncherHelper_targetFeatureWithIdNull, (Object)f.getModel().getInstallLocation()))));
                    return false;
                }
                return true;
            }).collect(Collectors.groupingBy(IIdentifiable::getId));
            id2feature.forEach((id, features) -> {
                boolean bl = featureMaps.computeIfAbsent((String)id, i -> new ArrayList()).add(features);
            });
        }
        return featureMaps;
    }

    private static void addFeatureIfAbsent(IFeature feature, String resolution, Map<IFeature, String> featurePluginResolution, Queue<IFeature> pendingFeatures) {
        if (feature != null && featurePluginResolution.putIfAbsent(feature, resolution) == null) {
            pendingFeatures.add(feature);
        }
    }

    private static boolean isWorkspace(String location) {
        if ("workspace".equalsIgnoreCase(location)) {
            return true;
        }
        if ("external".equalsIgnoreCase(location)) {
            return false;
        }
        throw new IllegalArgumentException("Unsupported location: " + location);
    }

    private static IFeature getIncludedFeature(String id, String version, Predicate<IFeature> environmentFilter, Map<String, List<List<IFeature>>> prioritizedFeatures) {
        List features = prioritizedFeatures.get(id);
        return BundleLauncherHelper.getIncluded(features, environmentFilter, IVersionable::getVersion, NEUTRAL_COMPARATOR, version);
    }

    private static IFeature getRequiredFeature(String id, String version, int versionMatchRule, Predicate<IFeature> environmentFilter, Map<String, List<List<IFeature>>> prioritizedFeatures) {
        List features = prioritizedFeatures.get(id);
        return BundleLauncherHelper.getRequired(features, environmentFilter, IVersionable::getVersion, NEUTRAL_COMPARATOR, version, versionMatchRule);
    }

    private static IPluginModelBase getIncludedPlugin(String id, String version, String pluginLocation) {
        List plugins = BundleLauncherHelper.getPlugins(id, pluginLocation);
        return BundleLauncherHelper.getIncluded(plugins, ENABLED_VALID_PLUGIN_FILTER, GET_PLUGIN_VERSION, COMPARE_PLUGIN_RESOLVED, version);
    }

    private static IPluginModelBase getRequiredPlugin(String id, String version, int versionMatchRule, String pluginLocation) {
        List plugins = BundleLauncherHelper.getPlugins(id, pluginLocation);
        return BundleLauncherHelper.getRequired(plugins, ENABLED_VALID_PLUGIN_FILTER, GET_PLUGIN_VERSION, COMPARE_PLUGIN_RESOLVED, version, versionMatchRule);
    }

    static IPluginModelBase getLatestPlugin(String id, String pluginLocation) {
        return BundleLauncherHelper.getRequiredPlugin(id, null, 0, pluginLocation);
    }

    private static List<List<IPluginModelBase>> getPlugins(String id, String pluginLocation) {
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry == null) {
            return Collections.emptyList();
        }
        List<IPluginModelBase> wsPlugins = List.of(entry.getWorkspaceModels());
        List<IPluginModelBase> tpPlugins = List.of(entry.getExternalModels());
        return BundleLauncherHelper.isWorkspace(pluginLocation) ? List.of(wsPlugins, tpPlugins) : List.of(tpPlugins, wsPlugins);
    }

    private static <E> E getIncluded(List<List<E>> containers, Predicate<E> filter, Function<E, String> getVersion, Comparator<E> primaryComparator, String version) {
        if (containers == null || containers.isEmpty()) {
            return null;
        }
        Version includedVersion = Version.parseVersion((String)version);
        Comparator<Object> compareVersion = primaryComparator.thenComparing(e -> Version.parseVersion((String)((String)getVersion.apply(e))), Comparator.comparing(arg_0 -> ((Version)includedVersion).equals(arg_0)).thenComparing(v -> VersionUtil.compareMacroMinorMicro((Version)v, (Version)includedVersion) == 0).thenComparing(Comparator.naturalOrder()));
        return (E)BundleLauncherHelper.getMaxElement(containers, filter, compareVersion);
    }

    private static <E> E getRequired(List<List<E>> containers, Predicate<E> filter, Function<E, String> getVersion, Comparator<E> primaryComparator, String version, int versionMatchRule) {
        if (containers == null || containers.isEmpty()) {
            return null;
        }
        if (version != null && !version.equals(Version.emptyVersion.toString())) {
            Predicate<Object> matchingVersion = e -> VersionUtil.compare((String)((String)getVersion.apply(e)), (String)version, (int)versionMatchRule);
            filter = filter.and(matchingVersion);
        }
        Comparator<Object> compareVersion = primaryComparator.thenComparing(e -> Version.parseVersion((String)((String)getVersion.apply(e))));
        return (E)BundleLauncherHelper.getMaxElement(containers, filter, compareVersion);
    }

    private static <E> E getMaxElement(List<List<E>> containers, Predicate<E> filter, Comparator<E> comparator) {
        for (List<E> container : containers) {
            Optional selection = container.stream().filter(filter).max(comparator);
            if (!selection.isPresent()) continue;
            return selection.get();
        }
        return null;
    }

    private static Map<IPluginModelBase, String> getWorkspaceBundleMap(ILaunchConfiguration configuration, Map<String, List<Version>> idVersions) throws CoreException {
        Set workspaceBundles = configuration.getAttribute("selected_workspace_bundles", Collections.emptySet());
        Map<IPluginModelBase, String> map = BundleLauncherHelper.getBundleMap(workspaceBundles, ModelEntry::getWorkspaceModels, CONTAINS_SAME_VERSION, idVersions);
        if (configuration.getAttribute("automaticAdd", true)) {
            IPluginModelBase[] models;
            Set deselectedWorkspaceBundles = configuration.getAttribute("deselected_workspace_bundles", Collections.emptySet());
            Set<IPluginModelBase> deselectedPlugins = BundleLauncherHelper.getBundleMap(deselectedWorkspaceBundles, ModelEntry::getWorkspaceModels, null, null).keySet();
            IPluginModelBase[] iPluginModelBaseArray = models = PluginRegistry.getWorkspaceModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                if (model.getPluginBase().getId() != null && !deselectedPlugins.contains(model) && !map.containsKey(model)) {
                    BundleLauncherHelper.addPlugin(map, model, DEFAULT_START_LEVELS, idVersions, CONTAINS_SAME_VERSION);
                }
                ++n2;
            }
        }
        return map;
    }

    private static Map<IPluginModelBase, String> getTargetBundleMap(ILaunchConfiguration configuration, Map<String, List<Version>> idVersions) throws CoreException {
        Set targetBundles = configuration.getAttribute("selected_target_bundles", Collections.emptySet());
        return BundleLauncherHelper.getBundleMap(targetBundles, ModelEntry::getExternalModels, CONTAINS_SAME_MMM_VERSION, idVersions);
    }

    /*
     * WARNING - void declaration
     */
    private static Map<IPluginModelBase, String> getBundleMap(Set<String> entries, Function<ModelEntry, IPluginModelBase[]> getModels, BiPredicate<List<Version>, Version> versionFilter, Map<String, List<Version>> idVersions) {
        LinkedHashMap<IPluginModelBase, String> map = new LinkedHashMap<IPluginModelBase, String>();
        for (String string : entries) {
            void var5_6;
            String idVersion;
            int versionIndex;
            int index = string.indexOf(64);
            if (index < 0) {
                index = string.length();
                String string2 = string + "@default:default";
            }
            String id = (versionIndex = (idVersion = var5_6.substring(0, index)).indexOf(42)) > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            String version = versionIndex > 0 ? idVersion.substring(versionIndex + 1) : null;
            ModelEntry entry = PluginRegistry.findEntry((String)id);
            if (entry == null) continue;
            IPluginModelBase[] models = getModels.apply(entry);
            String startData = var5_6.substring(index + 1);
            for (IPluginModelBase model : BundleLauncherHelper.getSelectedModels(models, version, versionFilter == null)) {
                BundleLauncherHelper.addPlugin(map, model, startData, idVersions, versionFilter);
            }
        }
        return map;
    }

    private static Iterable<IPluginModelBase> getSelectedModels(IPluginModelBase[] models, String version, boolean greedy) {
        Stream<IPluginModelBase> selectedModels = Arrays.stream(models).filter(IPluginModelBase::isEnabled);
        if (version == null) {
            if (!greedy) {
                selectedModels = selectedModels.max(VERSION).stream();
            }
        } else {
            selectedModels = selectedModels.filter(m -> m.getPluginBase().getVersion().equals(version) || models.length == 1);
        }
        return selectedModels::iterator;
    }

    private static void addPlugin(Map<IPluginModelBase, String> map, IPluginModelBase model, String startData, Map<String, List<Version>> idVersions, BiPredicate<List<Version>, Version> containsVersion) {
        if (containsVersion == null) {
            BundleLauncherHelper.addBundleToMap(map, model, startData);
        } else {
            Version version;
            List pluginVersions = idVersions.computeIfAbsent(model.getPluginBase().getId(), n -> new ArrayList());
            if (!containsVersion.test(pluginVersions, version = BundleLauncherHelper.getVersion(model))) {
                pluginVersions.add(version);
                BundleLauncherHelper.addBundleToMap(map, model, startData);
            }
        }
    }

    private static Version getVersion(IPluginModelBase model) {
        BundleDescription bundleDescription = model.getBundleDescription();
        if (bundleDescription == null) {
            try {
                return Version.parseVersion((String)model.getPluginBase().getVersion());
            }
            catch (IllegalArgumentException e) {
                return Version.emptyVersion;
            }
        }
        return bundleDescription.getVersion();
    }

    private static void addBundleToMap(Map<IPluginModelBase, String> map, IPluginModelBase bundle, String startData) {
        boolean defaultsl;
        BundleDescription desc = bundle.getBundleDescription();
        boolean bl = defaultsl = startData == null || startData.equals(DEFAULT_START_LEVELS);
        if (desc != null && defaultsl) {
            startData = BundleLauncherHelper.getStartData(desc, startData);
        }
        map.put(bundle, startData);
    }

    private static Stream<IPluginModelBase> computeDependencies(Set<IPluginModelBase> includedPlugins, boolean includeOptional, boolean preferWorkspaceBundles) {
        DependencyManager.Options[] optionsArray;
        if (includedPlugins.isEmpty()) {
            return Stream.empty();
        }
        HashMap<BundleDescription, IPluginModelBase> launchBundlePlugins = new HashMap<BundleDescription, IPluginModelBase>(includedPlugins.size() * 4 / 3 + 1);
        Set<BundleDescription> launchBundles = BundleLauncherHelper.reresolveBundlesPreferringIncludedBundles(includedPlugins, launchBundlePlugins, preferWorkspaceBundles);
        State launchState = launchBundles.iterator().next().getContainingState();
        DependencyManager.getImplicitDependencies().stream().map(descriptor -> {
            String versionStr = descriptor.getVersion();
            Version version = versionStr != null ? Version.parseVersion((String)versionStr) : null;
            return launchState.getBundle(descriptor.getId(), version);
        }).forEach(launchBundles::add);
        if (includeOptional) {
            DependencyManager.Options[] optionsArray2 = new DependencyManager.Options[1];
            optionsArray = optionsArray2;
            optionsArray2[0] = DependencyManager.Options.INCLUDE_OPTIONAL_DEPENDENCIES;
        } else {
            optionsArray = new DependencyManager.Options[]{};
        }
        DependencyManager.Options[] options = optionsArray;
        Set closure = DependencyManager.findRequirementsClosure(launchBundles, (DependencyManager.Options[])options);
        return closure.stream().map(launchBundlePlugins::get).map(Objects::requireNonNull).filter(p -> !includedPlugins.contains(p));
    }

    private static Set<BundleDescription> reresolveBundlesPreferringIncludedBundles(Set<IPluginModelBase> includedPlugins, Map<BundleDescription, IPluginModelBase> launchBundlePlugins, boolean preferWorkspaceBundles) {
        PluginModelManager modelManager = PDECore.getDefault().getModelManager();
        State tpState = modelManager.getState().getState();
        State launchState = BundleHelper.getPlatformAdmin().getFactory().createState(true);
        launchState.setPlatformProperties(tpState.getPlatformProperties());
        for (IPluginModelBase plugin2 : includedPlugins) {
            BundleLauncherHelper.addPluginBundle(plugin2, launchState, launchBundlePlugins, tpState);
        }
        HashSet<BundleDescription> launchBundles = new HashSet<BundleDescription>(launchBundlePlugins.keySet());
        Stream.of(modelManager.getWorkspaceModels(), modelManager.getExternalModels()).flatMap(Arrays::stream).filter(IPluginModelBase::isEnabled).filter(p -> !includedPlugins.contains(p)).forEach(plugin -> BundleLauncherHelper.addPluginBundle(plugin, launchState, launchBundlePlugins, tpState));
        launchState.getResolver().setSelectionPolicy(Comparator.comparing(d -> !launchBundles.contains(d.getSupplier())).thenComparing(d -> {
            boolean isWorkspaceBundle = ((IPluginModelBase)launchBundlePlugins.get(d.getSupplier())).getUnderlyingResource() != null;
            return isWorkspaceBundle ^ preferWorkspaceBundles;
        }).thenComparing(tpState.getResolver().getSelectionPolicy()));
        launchState.resolve(false);
        return launchBundles;
    }

    private static void addPluginBundle(IPluginModelBase plugin, State launchState, Map<BundleDescription, IPluginModelBase> launchBundlePlugin, State tpState) {
        BundleDescription bundle = plugin.getBundleDescription();
        if (bundle != null) {
            if (bundle.getContainingState() != tpState) {
                throw new IllegalStateException("Plugins have different TP state");
            }
            BundleDescription launchBundle = launchState.getFactory().createBundleDescription(bundle);
            launchBundle.setUserObject((Object)plugin);
            if (!launchState.addBundle(launchBundle)) {
                throw new IllegalStateException("Failed to add bundle to launch state: " + String.valueOf(launchBundle));
            }
            if (launchBundlePlugin.put(launchBundle, plugin) != null) {
                throw new IllegalStateException("Duplicated launch bundle for plugin: " + String.valueOf(plugin));
            }
        }
    }

    public static String getStartData(BundleDescription desc, String defaultStartData) {
        String runLevel = BundleLauncherHelper.resolveSystemRunLevelText(desc);
        String auto = BundleLauncherHelper.resolveSystemAutoText(desc);
        return runLevel != null && auto != null ? runLevel + ":" + auto : defaultStartData;
    }

    public static void addDefaultStartingBundle(Map<IPluginModelBase, String> map, IPluginModelBase bundle) {
        BundleLauncherHelper.addBundleToMap(map, bundle, DEFAULT_START_LEVELS);
    }

    public static String resolveSystemRunLevelText(BundleDescription description) {
        return AUTO_STARTED_BUNDLE_LEVELS.get(description.getSymbolicName());
    }

    public static String resolveSystemAutoText(BundleDescription description) {
        return AUTO_STARTED_BUNDLE_LEVELS.containsKey(description.getSymbolicName()) ? DEFAULT_UPDATE_CONFIGURATOR_AUTO_START_TEXT : null;
    }

    public static String formatBundleEntry(IPluginModelBase model, String startLevel, String autoStart) {
        boolean hasAutoStart;
        IPluginBase base = model.getPluginBase();
        String id = base.getId();
        StringBuilder buffer = new StringBuilder(id);
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        if (entry != null) {
            IPluginModelBase[] entryModels;
            boolean isWorkspacePlugin = model.getUnderlyingResource() != null;
            IPluginModelBase[] iPluginModelBaseArray = entryModels = isWorkspacePlugin ? entry.getWorkspaceModels() : entry.getExternalModels();
            if (entryModels.length > 1) {
                buffer.append('*');
                buffer.append(model.getPluginBase().getVersion());
            }
        }
        boolean hasStartLevel = startLevel != null && !startLevel.isEmpty();
        boolean bl = hasAutoStart = autoStart != null && !autoStart.isEmpty();
        if (hasStartLevel || hasAutoStart) {
            buffer.append('@');
            if (hasStartLevel) {
                buffer.append(startLevel);
            }
            buffer.append(":");
            if (hasAutoStart) {
                buffer.append(autoStart);
            }
        }
        return buffer.toString();
    }

    public static String formatFeatureEntry(String featureId, String pluginResolution) {
        return featureId + ":" + pluginResolution;
    }

    public static void migrateLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration) throws CoreException {
        boolean upgrade;
        String value2;
        String value = configuration.getAttribute("wsproject", null);
        if (value != null) {
            configuration.setAttribute("wsproject", null);
            if (value.indexOf(59) != -1) {
                value = value.replace(';', ',');
            } else if (value.indexOf(58) != -1) {
                value = value.replace(':', ',');
            }
            value = value.length() == 0 || value.equals(",") ? null : value.substring(0, value.length() - 1);
            boolean automatic = configuration.getAttribute("automaticAdd", true);
            String attr = automatic ? "deselected_workspace_plugins" : "selected_workspace_plugins";
            configuration.setAttribute(attr, value);
        }
        if ((value2 = configuration.getAttribute("extplugins", null)) != null) {
            configuration.setAttribute("extplugins", null);
            if (value2.indexOf(59) != -1) {
                value2 = value2.replace(';', ',');
            } else if (value2.indexOf(58) != -1) {
                value2 = value2.replace(':', ',');
            }
            value2 = value2.length() == 0 || value2.equals(",") ? null : value2.substring(0, value2.length() - 1);
            configuration.setAttribute("selected_target_plugins", value2);
        }
        BundleLauncherHelper.convertToSet(configuration, "selected_target_plugins", "selected_target_bundles");
        BundleLauncherHelper.convertToSet(configuration, "selected_workspace_plugins", "selected_workspace_bundles");
        BundleLauncherHelper.convertToSet(configuration, "deselected_workspace_plugins", "deselected_workspace_bundles");
        String version = configuration.getAttribute("pde.version", null);
        boolean newApp = TargetPlatformHelper.usesNewApplicationModel();
        boolean bl = upgrade = !"3.3".equals(version) && newApp;
        if (!upgrade) {
            boolean bl2 = upgrade = TargetPlatformHelper.getTargetVersion() >= 3.2 && version == null;
        }
        if (upgrade) {
            configuration.setAttribute("pde.version", newApp ? "3.3" : "3.2a");
            boolean usedefault = configuration.getAttribute(DEFAULT, true);
            boolean automaticAdd = configuration.getAttribute("automaticAdd", true);
            if (!usedefault) {
                ArrayList<String> list = new ArrayList<String>();
                if (version == null) {
                    list.add("org.eclipse.core.contenttype");
                    list.add("org.eclipse.core.jobs");
                    list.add("org.eclipse.equinox.common");
                    list.add("org.eclipse.equinox.preferences");
                    list.add("org.eclipse.equinox.registry");
                }
                if (!"3.3".equals(version) && newApp) {
                    list.add("org.eclipse.equinox.app");
                }
                LinkedHashSet<String> extensions = new LinkedHashSet<String>(configuration.getAttribute("selected_workspace_bundles", Collections.emptySet()));
                LinkedHashSet<String> target = new LinkedHashSet<String>(configuration.getAttribute("selected_target_bundles", Collections.emptySet()));
                for (String plugin : list) {
                    IPluginModelBase model = PluginRegistry.findModel((String)plugin);
                    if (model == null) continue;
                    if (model.getUnderlyingResource() != null) {
                        if (automaticAdd) continue;
                        extensions.add(plugin);
                        continue;
                    }
                    target.add(plugin);
                }
                if (!extensions.isEmpty()) {
                    configuration.setAttribute("selected_workspace_bundles", extensions);
                }
                if (!target.isEmpty()) {
                    configuration.setAttribute("selected_target_bundles", target);
                }
            }
        }
    }

    private static ILaunchConfigurationWorkingCopy getWorkingCopy(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.isWorkingCopy()) {
            return (ILaunchConfigurationWorkingCopy)configuration;
        }
        return configuration.getWorkingCopy();
    }

    public static void migrateOsgiLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration) throws CoreException {
        BundleLauncherHelper.convertToSet(configuration, "workspace_bundles", "selected_workspace_bundles");
        BundleLauncherHelper.convertToSet(configuration, "target_bundles", "selected_target_bundles");
        BundleLauncherHelper.convertToSet(configuration, "deselected_workspace_plugins", "deselected_workspace_bundles");
    }

    private static void convertToSet(ILaunchConfigurationWorkingCopy wc, String stringAttribute, String listAttribute) throws CoreException {
        String value = wc.getAttribute(stringAttribute, null);
        if (value != null) {
            wc.removeAttribute(stringAttribute);
            String[] itemArray = value.split(",");
            HashSet<String> itemSet = new HashSet<String>(Arrays.asList(itemArray));
            wc.setAttribute(listAttribute, itemSet);
        }
    }

    public static Map<IPluginModelBase, AdditionalPluginData> getAdditionalPlugins(ILaunchConfiguration config, boolean onlyEnabled) throws CoreException {
        HashMap<IPluginModelBase, AdditionalPluginData> resolvedAdditionalPlugins = new HashMap<IPluginModelBase, AdditionalPluginData>();
        Set userAddedPlugins = config.getAttribute("additional_plugins", Collections.emptySet());
        String defaultPluginResolution = config.getAttribute("featurePluginResolution", "workspace");
        for (String addedPlugin : userAddedPlugins) {
            IPluginModelBase model;
            String[] pluginData = addedPlugin.split(":");
            boolean checked = Boolean.parseBoolean(pluginData[3]);
            if (onlyEnabled && !checked) continue;
            String id = pluginData[0];
            String version = pluginData[1];
            String pluginResolution = pluginData[2];
            if (DEFAULT.equalsIgnoreCase(pluginResolution)) {
                pluginResolution = defaultPluginResolution;
            }
            if ((model = BundleLauncherHelper.getIncludedPlugin(id, version, pluginResolution)) == null) continue;
            String startLevel = pluginData.length >= 6 ? pluginData[4] : null;
            String autoStart = pluginData.length >= 6 ? pluginData[5] : null;
            AdditionalPluginData additionalPluginData = new AdditionalPluginData(pluginData[2], checked, startLevel, autoStart);
            resolvedAdditionalPlugins.put(model, additionalPluginData);
        }
        return resolvedAdditionalPlugins;
    }

    public static String formatAdditionalPluginEntry(IPluginModelBase pluginModel, String pluginResolution, boolean isChecked, String fStartLevel, String fAutoStart) {
        IPluginBase plugin = pluginModel.getPluginBase();
        return String.join((CharSequence)":", plugin.getId(), plugin.getVersion(), pluginResolution, String.valueOf(isChecked), fStartLevel, fAutoStart);
    }

    public static class AdditionalPluginData {
        public final String fResolution;
        public final boolean fEnabled;
        public final String fStartLevel;
        public final String fAutoStart;

        public AdditionalPluginData(String resolution, boolean enabled, String startLevel, String autoStart) {
            this.fResolution = resolution;
            this.fEnabled = enabled;
            this.fStartLevel = startLevel == null || startLevel.isEmpty() ? BundleLauncherHelper.DEFAULT : startLevel;
            this.fAutoStart = autoStart == null || autoStart.isEmpty() ? BundleLauncherHelper.DEFAULT : autoStart;
        }

        String startLevels() {
            return this.fStartLevel + ":" + this.fAutoStart;
        }
    }
}

