/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ActivationEventType implements Enumerator
{
    PROGRAMMATIC(4, "Programmatic", "Programmatic"),
    KEY_PRESSED(1, "KeyPressed", "KeyPressed"),
    MOUSE_CLICK_SELECTION(2, "MouseClickSelection", "MouseClickSelection"),
    MOUSE_DOUBLE_CLICK_SELECTION(3, "MouseDoubleClickSelection", "MouseDoubleClickSelection"),
    TRAVERSAL(5, "Traversal", "Traversal");

    public static final int PROGRAMMATIC_VALUE = 4;
    public static final int KEY_PRESSED_VALUE = 1;
    public static final int MOUSE_CLICK_SELECTION_VALUE = 2;
    public static final int MOUSE_DOUBLE_CLICK_SELECTION_VALUE = 3;
    public static final int TRAVERSAL_VALUE = 5;
    private static final ActivationEventType[] VALUES_ARRAY;
    public static final List<ActivationEventType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ActivationEventType[]{PROGRAMMATIC, KEY_PRESSED, MOUSE_CLICK_SELECTION, MOUSE_DOUBLE_CLICK_SELECTION, TRAVERSAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ActivationEventType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivationEventType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivationEventType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActivationEventType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActivationEventType get(int value) {
        switch (value) {
            case 4: {
                return PROGRAMMATIC;
            }
            case 1: {
                return KEY_PRESSED;
            }
            case 2: {
                return MOUSE_CLICK_SELECTION;
            }
            case 3: {
                return MOUSE_DOUBLE_CLICK_SELECTION;
            }
            case 5: {
                return TRAVERSAL;
            }
        }
        return null;
    }

    private ActivationEventType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

