/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7Status;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.resources.Activator;
import org.eclipse.rcptt.resources.ImportUtils;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.util.Predicate;
import org.eclipse.rcptt.workspace.WSContainer;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFileLink;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSFolderLink;
import org.eclipse.rcptt.workspace.WSLink;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSResource;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceData;
import org.eclipse.rcptt.workspace.WorkspaceFactory;
import org.osgi.framework.Bundle;

public class WSUtils {
    public static WSProject getProject(WSRoot root, String name, boolean create) {
        WSProject project = WSUtils.getResource(root.getProjects(), name);
        if (project == null && create) {
            project = WorkspaceFactory.eINSTANCE.createWSProject();
            project.setName(name);
            root.getProjects().add((Object)project);
        }
        return project;
    }

    public static IPath getPath(WSResource resource) {
        if (resource instanceof WSRoot) {
            return Path.EMPTY;
        }
        EObject eObject = resource.eContainer();
        if (eObject instanceof WSFolder) {
            IPath parentPath = WSUtils.getPath((WSFolder)eObject);
            return parentPath.append(resource.getName());
        }
        return new Path(resource.getName());
    }

    public static WSResource getResource(WSContainer container, IPath path) {
        String[] segments = path.segments();
        if (segments.length == 0) {
            return container;
        }
        WSResource result = null;
        int index = 0;
        while (index < segments.length) {
            String name = segments[index];
            result = WSUtils.getResource(WSUtils.getContents(container), name);
            if (!(result instanceof WSFolder)) break;
            container = (WSFolder)result;
            ++index;
        }
        if (index == segments.length) {
            return result;
        }
        return null;
    }

    public static List<WSResource> getContents(WSContainer container) {
        if (container instanceof WSRoot) {
            BasicEList resources = new BasicEList();
            WSRoot root = (WSRoot)container;
            resources.addAll(root.getProjects());
            resources.addAll(root.getProjectLinks());
            return resources;
        }
        WSFolder folder = (WSFolder)container;
        BasicEList resources = new BasicEList();
        resources.addAll(folder.getFolders());
        resources.addAll(folder.getFolderLinks());
        resources.addAll(folder.getFiles());
        resources.addAll(folder.getFileLinks());
        return resources;
    }

    public static WSContainer getContainer(WSContainer container, String name, boolean create) {
        if (container instanceof WSRoot) {
            WSRoot root = (WSRoot)container;
            return WSUtils.getProject(root, name, create);
        }
        WSFolder folder = (WSFolder)container;
        return WSUtils.getFolder(folder, name, create);
    }

    public static WSFile getFile(WSFolder folder, String name, boolean create) {
        WSFile file = WSUtils.getResource(folder.getFiles(), name);
        if (file == null && create) {
            file = WorkspaceFactory.eINSTANCE.createWSFile();
            file.setName(name);
            folder.getFiles().add((Object)file);
        }
        return file;
    }

    public static WSFolder getFolder(WSFolder folder, String name, boolean create) {
        WSFolder result = WSUtils.getResource(folder.getFolders(), name);
        if (result == null && create) {
            result = WorkspaceFactory.eINSTANCE.createWSFolder();
            result.setName(name);
            folder.getFolders().add((Object)result);
        }
        return result;
    }

    public static void remove(WSResource resource) {
        EReference ref = resource.eContainmentFeature();
        List list = (List)resource.eContainer().eGet((EStructuralFeature)ref);
        list.remove(resource);
    }

    public static <T extends WSResource> T getResource(List<T> resources, String name) {
        for (WSResource resorce : resources) {
            if (!name.equals(resorce.getName())) continue;
            return (T)resorce;
        }
        return null;
    }

    public static byte[] getFileContent(String location, WSFile file) throws IOException {
        InputStream stream = WSUtils.getFileStream(location, file, null);
        return WSUtils.getStreamContent(stream);
    }

    public static byte[] getFileContent(String location, WSFile file, IPersistenceModel model) throws IOException {
        InputStream stream = WSUtils.getFileStream(location, file, model);
        return WSUtils.getStreamContent(stream);
    }

    public static byte[] getStreamContent(InputStream stream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = stream.read(buffer)) > 0) {
                output.write(buffer, 0, len);
            }
        }
        finally {
            WSUtils.safeClose(stream);
        }
        return output.toByteArray();
    }

    public static void safeClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static InputStream getFileStream(String location, WSFile file, IPersistenceModel model) throws FileNotFoundException {
        String name;
        InputStream inputStream;
        if (model != null && (inputStream = model.read(name = ImportUtils.getName(file))) != null) {
            return inputStream;
        }
        if (location == null && (location = WSUtils.getContextFile(file)) == null) {
            location = Platform.getLocation().toString();
        }
        File parentFile = new File(location);
        if (file.getContentURI() == null) {
            throw new FileNotFoundException("Q7 could not find content for file: " + file.getName() + "\nPlease recapture Workspace context.");
        }
        File childFile = new File(parentFile, file.getContentURI());
        return new BufferedInputStream(new FileInputStream(childFile));
    }

    private static String getContextFile(WSFile file) {
        Resource res = file.eResource();
        if (res != null) {
            File oFile;
            URI uri;
            block10: {
                uri = res.getURI();
                oFile = null;
                if (uri != null) break block10;
                return null;
            }
            try {
                Path path;
                if (uri.isPlatformResource()) {
                    Path path2 = new Path(uri.toPlatformString(true));
                    IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path2);
                    oFile = iFile.getLocation().toFile();
                } else if (uri.isFile() && !uri.isRelative()) {
                    oFile = new File(uri.toFileString());
                } else if (uri.isPlatformPlugin() && (path = new Path(uri.toPlatformString(true))).segmentCount() > 1) {
                    Bundle bundle = Platform.getBundle((String)path.segment(0));
                    path = path.removeFirstSegments(1);
                    URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
                    url = FileLocator.toFileURL((URL)url);
                    oFile = new File(url.getFile());
                }
                if (oFile != null) {
                    return oFile.getParentFile().getAbsolutePath();
                }
            }
            catch (Exception e) {
                RcpttPlugin.log((Throwable)e);
            }
        }
        return null;
    }

    public static IFile getLinkResource(WSLink link) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(link.getProject());
        if (project == null || !project.exists()) {
            return null;
        }
        IResource member = project.findMember(link.getPath());
        if (member == null || !member.isAccessible()) {
            return null;
        }
        if (member instanceof IFile) {
            return (IFile)member;
        }
        return null;
    }

    public static IContainer getLinkContainer(WSLink link) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(link.getProject());
        if (project == null) {
            return null;
        }
        IResource res = project.findMember(link.getPath());
        if (!(res instanceof IContainer) || !res.isAccessible()) {
            return null;
        }
        return (IContainer)res;
    }

    public static byte[] loadFileLinkContent(WSFileLink fileLink) throws IOException, ModelException {
        IFile path = WSUtils.getLinkResource(fileLink);
        if (path == null || !(path instanceof IFile)) {
            throw new ModelException(new Q7Status(4, String.format("File of link %s/%s is not found.", fileLink.getProject(), fileLink.getPath())));
        }
        try {
            return FileUtil.getStreamContent((InputStream)path.getContents());
        }
        catch (CoreException e) {
            throw new ModelException(new Q7Status(4, (Throwable)new IllegalStateException(String.format("Failed to load content of linked file %s/%s", fileLink.getProject(), fileLink.getPath()), e)));
        }
    }

    public static void loadFileLinkWithContent(WSFileLink fileLink) throws ModelException {
        try {
            byte[] content = WSUtils.loadFileLinkContent(fileLink);
            if (Q7Features.getInstance().isTrue("q7.contexts.resources.transfer.zipped")) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ZipOutputStream zout = new ZipOutputStream(bout);
                zout.setLevel(9);
                zout.setMethod(8);
                ZipEntry entry = new ZipEntry("content");
                entry.setTime(1L);
                zout.putNextEntry(entry);
                zout.write(content);
                zout.close();
                fileLink.setContent(bout.toByteArray());
            } else {
                fileLink.setContent(content);
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
    }

    public static void loadFolderLinkWithContent(WSFolderLink folderLink) throws IOException, CoreException {
        IResource[] members;
        IContainer container = WSUtils.getLinkContainer(folderLink);
        if (container == null) {
            throw new ModelException(new Q7Status(4, String.format("Can not resolve folder link %s/%s.", folderLink.getProject(), folderLink.getPath())));
        }
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (r instanceof IFolder) {
                WSFolderLink newFolderLink = WorkspaceFactory.eINSTANCE.createWSFolderLink();
                newFolderLink.setName(r.getName());
                newFolderLink.setProject(r.getProject().getName());
                newFolderLink.setPath(r.getProjectRelativePath().toPortableString());
                folderLink.getFolders().add((Object)newFolderLink);
                WSUtils.loadFolderLinkWithContent(newFolderLink);
            } else if (r instanceof IFile) {
                WSFileLink newFileLink = WorkspaceFactory.eINSTANCE.createWSFileLink();
                newFileLink.setName(r.getName());
                newFileLink.setProject(r.getProject().getName());
                newFileLink.setPath(r.getProjectRelativePath().toPortableString());
                folderLink.getFiles().add((Object)newFileLink);
                WSUtils.loadFileLinkWithContent(newFileLink);
            }
            ++n2;
        }
    }

    public static List<WSLink> listLinks(WSResource content) {
        ArrayList<WSLink> result = new ArrayList<WSLink>();
        if (content instanceof WSRoot) {
            result.addAll((Collection<WSLink>)((WSRoot)content).getProjectLinks());
            EList<WSProject> projects = ((WSRoot)content).getProjects();
            for (WSProject wsProject : projects) {
                result.addAll(WSUtils.listLinks(wsProject));
            }
        }
        if (content instanceof WSFolder) {
            result.addAll((Collection<WSLink>)((WSFolder)content).getFolderLinks());
            result.addAll((Collection<WSLink>)((WSFolder)content).getFileLinks());
            EList<WSFolder> folders = ((WSFolder)content).getFolders();
            for (WSFolder wsFolder : folders) {
                result.addAll(WSUtils.listLinks(wsFolder));
            }
        }
        return result;
    }

    public static void visitWorkspace(WorkspaceData data, SubMonitor monitor, Predicate<WSResource> visitor) {
        if (visitor.apply((Object)data.getContent())) {
            return;
        }
        WSUtils.visitRoot(data.getContent(), visitor, monitor);
    }

    private static void visitRoot(WSRoot content, Predicate<WSResource> visitor, SubMonitor monitor) {
        monitor.beginTask("Projects", content.getProjects().size());
        try {
            for (WSProject project : content.getProjects()) {
                if (visitor.apply((Object)project)) {
                } else if (!WSUtils.visitProject(project, visitor, monitor.newChild(1))) continue;
                break;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static boolean visitProject(WSProject project, Predicate<WSResource> visitor, SubMonitor monitor) {
        return WSUtils.visitFolder(project, visitor, monitor);
    }

    public static boolean visitFolder(WSFolder folder, Predicate<WSResource> visitor, SubMonitor monitor) {
        monitor.beginTask(folder.getName(), folder.getFiles().size() + folder.getFileLinks().size() + folder.getFolders().size() + folder.getFolderLinks().size());
        if (monitor.isCanceled()) {
            return true;
        }
        try {
            for (WSResource entry : folder.getFiles()) {
                if (visitor.apply((Object)entry)) {
                    return true;
                }
                monitor.worked(1);
            }
            for (WSResource entry : folder.getFolders()) {
                if (visitor.apply((Object)entry)) {
                    return true;
                }
                if (!WSUtils.visitFolder((WSFolder)entry, visitor, monitor.newChild(1))) continue;
                return true;
            }
            for (WSResource entry : folder.getFileLinks()) {
                if (visitor.apply((Object)entry)) {
                    return true;
                }
                monitor.worked(1);
            }
            for (WSResource entry : folder.getFolderLinks()) {
                if (visitor.apply((Object)entry)) {
                    return true;
                }
                monitor.worked(1);
            }
            return false;
        }
        finally {
            monitor.done();
        }
    }
}

