/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEDetailsSections;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.category.BundleDetailsSection;
import org.eclipse.pde.internal.ui.editor.category.CategoryDetailsSection;
import org.eclipse.pde.internal.ui.editor.category.CategorySection;
import org.eclipse.pde.internal.ui.editor.category.FeatureDetailsSection;
import org.eclipse.pde.internal.ui.editor.category.SiteBundleAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteCategoryDefinitionAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteFeatureAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class IUsPage
extends PDEFormPage {
    public static final String PAGE_ID = "ius";
    private CategorySection fCategorySection;
    private final SiteFeaturesBlock fBlock = new SiteFeaturesBlock();

    public IUsPage(PDEFormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.CategoryPage_header);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(PDEUIMessages.CategoryPage_header);
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_CATEGORY_OBJ));
        this.fBlock.createContent(managedForm);
        this.fCategorySection.fireSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.category_editor");
    }

    private IDetailsPage createCategoryDetails() {
        return new PDEDetailsSections(){

            @Override
            protected PDESection[] createSections(PDEFormPage page, Composite parent) {
                return new PDESection[]{new CategoryDetailsSection(this.getPage(), parent)};
            }

            @Override
            public String getContextId() {
                return "category-context";
            }
        };
    }

    private IDetailsPage createFeatureDetails() {
        return new PDEDetailsSections(){

            @Override
            protected PDESection[] createSections(PDEFormPage page, Composite parent) {
                return new PDESection[]{new FeatureDetailsSection(this.getPage(), parent)};
            }

            @Override
            public String getContextId() {
                return "category-context";
            }
        };
    }

    private IDetailsPage createBundleDetails() {
        return new PDEDetailsSections(){

            @Override
            protected PDESection[] createSections(PDEFormPage page, Composite parent) {
                return new PDESection[]{new BundleDetailsSection(this.getPage(), parent)};
            }

            @Override
            public String getContextId() {
                return "category-context";
            }
        };
    }

    @Override
    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.category_editor";
    }

    public class SiteFeaturesBlock
    extends PDEMasterDetailsBlock {
        public SiteFeaturesBlock() {
            super(IUsPage.this);
        }

        @Override
        protected PDESection createMasterSection(IManagedForm managedForm, Composite parent) {
            IUsPage.this.fCategorySection = new CategorySection(this.getPage(), parent);
            return IUsPage.this.fCategorySection;
        }

        protected void registerPages(DetailsPart detailsPart) {
            detailsPart.setPageProvider(new IDetailsPageProvider(){

                public Object getPageKey(Object object) {
                    if (object instanceof SiteFeatureAdapter) {
                        return SiteFeatureAdapter.class;
                    }
                    if (object instanceof SiteBundleAdapter) {
                        return SiteBundleAdapter.class;
                    }
                    if (object instanceof ISiteCategoryDefinition) {
                        return ISiteCategoryDefinition.class;
                    }
                    if (object instanceof SiteCategoryDefinitionAdapter) {
                        return SiteCategoryDefinitionAdapter.class;
                    }
                    return object.getClass();
                }

                public IDetailsPage getPage(Object key) {
                    if (key.equals(ISiteCategoryDefinition.class) || key.equals(SiteCategoryDefinitionAdapter.class)) {
                        return IUsPage.this.createCategoryDetails();
                    }
                    if (key.equals(ISiteFeature.class) || key.equals(SiteFeatureAdapter.class)) {
                        return IUsPage.this.createFeatureDetails();
                    }
                    if (key.equals(ISiteBundle.class) || key.equals(SiteBundleAdapter.class)) {
                        return IUsPage.this.createBundleDetails();
                    }
                    return null;
                }
            });
        }
    }
}

