/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ProjectMetadata;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.delete.AbstractDeleteContextReferenceChange;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteContextReferenceChange;

public class UndoDeleteContextReferenceChange
extends AbstractDeleteContextReferenceChange {
    private final int index;

    public UndoDeleteContextReferenceChange(IQ7Element element, IFile elementFile, IContext context, String contextID, int index) {
        super(element, context, contextID);
        this.index = index;
    }

    public String getName() {
        return Messages.bind((String)Messages.UndoDeleteContextReferenceChange_Name, (Object)this.getContext().getName(), (Object)this.getElement().getName());
    }

    protected final int getIndex() {
        return this.index;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.isValid()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.UndoDeleteContextReferenceChange_InvalidRefMsg);
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            DeleteContextReferenceChange deleteContextReferenceChange;
            IQ7NamedElement e = (IQ7NamedElement)this.getElement();
            IQ7NamedElement copy = e.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            try {
                List<String> references = this.getContextsReferences(copy);
                references.add(this.getIndex(), this.getContextId());
                if (copy instanceof ITestCase) {
                    ((ITestCase)copy).setContexts(references.toArray(new String[references.size()]));
                } else if (copy instanceof IQ7ProjectMetadata) {
                    NamedElement namedElement = copy.getNamedElement();
                    if (namedElement instanceof ProjectMetadata) {
                        ProjectMetadata meta = (ProjectMetadata)namedElement;
                        meta.getContexts().clear();
                        meta.getContexts().addAll(references);
                    }
                } else {
                    NamedElement namedElement = copy.getNamedElement();
                    if (namedElement instanceof GroupContext) {
                        GroupContext ctx = (GroupContext)namedElement;
                        ctx.getContextReferences().clear();
                        ctx.getContextReferences().addAll(references);
                    }
                }
                copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                deleteContextReferenceChange = new DeleteContextReferenceChange(this.getElement(), this.getContext(), this.getContextId());
            }
            catch (Throwable throwable) {
                copy.discardWorkingCopy();
                throw throwable;
            }
            copy.discardWorkingCopy();
            return deleteContextReferenceChange;
        }
        finally {
            pm.done();
        }
    }
}

