/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ResourceAction;

public class NamedElementEditorActions {
    private ResourceAction undoAction;
    private ResourceAction redoAction;
    private ResourceAction copyAction;
    private ResourceAction cutAction;
    private ResourceAction pasteAction;
    private INamedElementActions actions;
    private IActionBars actionBars;

    public NamedElementEditorActions(INamedElementActions actions, IActionBars actionBars) {
        this.actions = actions;
        this.actionBars = actionBars;
        this.createActions(actionBars);
    }

    protected void createActions(IActionBars actionBars) {
        if (this.actions != null) {
            ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.rcptt.ui.editors.ecl.EclEditorPluginResources");
            this.undoAction = new ResourceAction(bundle, "Editor.Undo."){

                public void run() {
                    NamedElementEditorActions.this.actions.undo();
                }
            };
            this.register(this.undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION, "org.eclipse.ui.edit.undo");
            this.redoAction = new ResourceAction(bundle, "Editor.Redo."){

                public void run() {
                    NamedElementEditorActions.this.actions.redo();
                }
            };
            this.register(this.redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION, "org.eclipse.ui.edit.redo");
            this.copyAction = new ResourceAction(bundle, "Editor.Copy."){

                public void run() {
                    NamedElementEditorActions.this.actions.copy();
                }
            };
            this.register(this.copyAction, IAbstractTextEditorHelpContextIds.COPY_ACTION, "org.eclipse.ui.edit.copy");
            this.cutAction = new ResourceAction(bundle, "Editor.Cut."){

                public void run() {
                    NamedElementEditorActions.this.actions.cut();
                }
            };
            this.register(this.cutAction, IAbstractTextEditorHelpContextIds.CUT_ACTION, "org.eclipse.ui.edit.cut");
            this.pasteAction = new ResourceAction(bundle, "Editor.Paste."){

                public void run() {
                    NamedElementEditorActions.this.actions.paste();
                }
            };
            this.register(this.pasteAction, IAbstractTextEditorHelpContextIds.PASTE_ACTION, "org.eclipse.ui.edit.paste");
        }
    }

    public void activate() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, (IAction)this.undoAction);
            this.actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, (IAction)this.redoAction);
            this.actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
            this.actionBars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, (IAction)this.pasteAction);
            this.actionBars.setGlobalActionHandler(ITextEditorActionConstants.CUT, (IAction)this.cutAction);
            this.actionBars.updateActionBars();
        }
    }

    public void deactivate() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, null);
            this.actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, null);
            this.actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, null);
            this.actionBars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, null);
            this.actionBars.setGlobalActionHandler(ITextEditorActionConstants.CUT, null);
            this.actionBars.updateActionBars();
        }
    }

    private void register(ResourceAction action, String helpContextId, String actionDefinitionId) {
        action.setHelpContextId(helpContextId);
        action.setActionDefinitionId(actionDefinitionId);
    }

    public void updateEnablement() {
        if (this.actions != null) {
            this.undoAction.setEnabled(this.actions.canUndo());
            this.redoAction.setEnabled(this.actions.canRedo());
            this.copyAction.setEnabled(this.actions.canCopy());
            this.pasteAction.setEnabled(this.actions.canPaste());
            this.cutAction.setEnabled(this.actions.canCut());
            this.actionBars.updateActionBars();
        }
    }

    public static interface INamedElementActions {
        public void undo();

        public void redo();

        public boolean canUndo();

        public boolean canRedo();

        public void copy();

        public void paste();

        public void cut();

        public boolean canCopy();

        public boolean canPaste();

        public boolean canCut();
    }
}

