/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.navigator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.commons.SearchControl;
import org.eclipse.rcptt.ui.navigator.Q7CommonViewer;
import org.eclipse.rcptt.ui.navigator.SearchFilter;
import org.eclipse.rcptt.ui.navigator.SearchJob;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class Q7Explorer
extends CommonNavigator {
    public static final String ID = "org.eclipse.rcptt.ui.explorer";
    private static final Set<String> TEST_CASE_EXTENSIONS = new HashSet<String>();
    private Q7CommonViewer viewer;
    private final SearchJob job = new SearchJob();
    private final UIJob refreshViewerJob = new UIJob(PlatformUI.getWorkbench().getDisplay(), Messages.Q7Explorer_RefreshJob){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (Q7Explorer.this.viewer != null) {
                Q7Explorer.this.viewer.refresh(false);
                Q7Explorer.this.viewer.expandAll();
            }
            return Status.OK_STATUS;
        }
    };

    public Q7Explorer() {
        TEST_CASE_EXTENSIONS.add("test");
        TEST_CASE_EXTENSIONS.add("scenario");
        TEST_CASE_EXTENSIONS.add("suite");
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        this.viewer = new Q7CommonViewer(this.getViewSite().getId(), aParent, 770);
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 1).applyTo(composite);
        SearchControl searchControl = new SearchControl(composite);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).indent(1, 2).applyTo((Control)searchControl);
        searchControl.getFilterControl().addFocusListener((FocusListener)new TextFocusListener(searchControl.getFilterControl()));
        Composite container = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)container);
        container.setLayout((Layout)new FillLayout());
        super.createPartControl(container);
        searchControl.setSearchResultControl(this.viewer.getControl());
        ISWTObservableValue searchObservable = WidgetProperties.text((int)24).observeDelayed(400, (Widget)searchControl.getFilterControl());
        this.job.addResultListener(new SearchJob.ResultListener(){

            @Override
            public void resultAdded(IQ7NamedElement result) {
                SearchFilter filter = Q7Explorer.this.findFilter();
                if (filter == null) {
                    return;
                }
                filter.add(result);
                Q7Explorer.this.refreshViewerJob.cancel();
                Q7Explorer.this.refreshViewerJob.schedule(400L);
            }
        });
        searchObservable.addValueChangeListener((IValueChangeListener)new IValueChangeListener<String>(){

            public void handleValueChange(ValueChangeEvent<? extends String> event) {
                SearchFilter filter = Q7Explorer.this.findFilter();
                if (filter == null) {
                    return;
                }
                Q7Explorer.this.job.cancel();
                Q7Explorer.this.refreshViewerJob.cancel();
                String newValue = (String)event.diff.getNewValue();
                if ("".equals(newValue.trim())) {
                    filter.setEnabled(false);
                    filter.clear();
                    Q7Explorer.this.viewer.refresh(false);
                } else {
                    filter.setEnabled(true);
                    filter.clear();
                    Q7Explorer.this.viewer.refresh(false);
                    Q7Explorer.this.job.setQuery(newValue);
                    Q7Explorer.this.job.setUser(false);
                    Q7Explorer.this.job.setPriority(30);
                    Q7Explorer.this.job.schedule();
                }
            }
        });
    }

    private SearchFilter findFilter() {
        ViewerFilter[] viewerFilterArray = this.viewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter instanceof SearchFilter) {
                return (SearchFilter)filter;
            }
            ++n2;
        }
        return null;
    }

    public IResource[] filterSelectedResources() {
        IStructuredSelection selection = (IStructuredSelection)this.getCommonViewer().getSelection();
        SearchFilter filter = this.findFilter();
        List<IResource> filtered = this.doFilterSelection(filter, selection.toArray());
        if (filtered.size() == 0 && selection.size() == 1 && selection.getFirstElement() instanceof IFile && "suite".equals(((IFile)selection.getFirstElement()).getFileExtension())) {
            filtered.add((IResource)((IFile)selection.getFirstElement()));
        }
        return filtered.toArray(new IResource[filtered.size()]);
    }

    private List<IResource> doFilterSelection(SearchFilter filter, Object[] objects) {
        ArrayList<IResource> list = new ArrayList<IResource>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Object o = objectArray[n2];
                if (o instanceof IContainer) {
                    IContainer c = (IContainer)o;
                    try {
                        if (!c.isAccessible()) break block7;
                        Object[] members = c.members();
                        if (filter != null) {
                            list.addAll(this.doFilterSelection(filter, filter.filter((Viewer)this.getCommonViewer(), c, members)));
                            break block7;
                        }
                        list.addAll(this.doFilterSelection(filter, members));
                    }
                    catch (CoreException e) {
                        Q7UIPlugin.log(e);
                    }
                } else if (o instanceof IFile && TEST_CASE_EXTENSIONS.contains(((IFile)o).getFileExtension())) {
                    list.add((IResource)((IFile)o));
                }
            }
            ++n2;
        }
        return list;
    }

    class TextFocusListener
    implements FocusListener {
        private final Text fText;
        private Action cutAction;
        private Action copyAction;
        private Action pasteAction;
        private Action deleteAction;
        private Action selectAllAction;

        public TextFocusListener(Text text) {
            this.fText = text;
            this.makeActions();
            final TextFocusListener focusListener = this;
            this.fText.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TextFocusListener.this.deactivateActions();
                    TextFocusListener.this.fText.removeFocusListener(focusListener);
                    TextFocusListener.this.fText.removeDisposeListener((DisposeListener)this);
                }
            });
        }

        public void focusLost(FocusEvent e) {
            this.deactivateActions();
        }

        public void focusGained(FocusEvent e) {
            this.activateAction();
        }

        private void activateAction() {
            Q7Explorer.this.getViewSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.CUT, (IAction)this.cutAction);
            Q7Explorer.this.getViewSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
            Q7Explorer.this.getViewSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.PASTE, (IAction)this.pasteAction);
            Q7Explorer.this.getViewSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.DELETE, (IAction)this.deleteAction);
            Q7Explorer.this.getViewSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.selectAllAction);
        }

        private void deactivateActions() {
            Q7Explorer.this.getViewSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.CUT, null);
            Q7Explorer.this.getViewSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.COPY, null);
            Q7Explorer.this.getViewSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.PASTE, null);
            Q7Explorer.this.getViewSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.DELETE, null);
            Q7Explorer.this.getViewSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, null);
        }

        private void makeActions() {
            this.cutAction = new Action(Messages.Q7Explorer_CutLabel){

                public void run() {
                    TextFocusListener.this.fText.cut();
                }
            };
            this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
            this.copyAction = new Action(Messages.Q7Explorer_CopyLabel){

                public void run() {
                    TextFocusListener.this.fText.copy();
                }
            };
            this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
            this.pasteAction = new Action(Messages.Q7Explorer_PasteLabel){

                public void run() {
                    TextFocusListener.this.fText.paste();
                }
            };
            this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
            this.deleteAction = new Action(Messages.Q7Explorer_DeleteLabel){

                public void run() {
                    if (TextFocusListener.this.fText.getSelectionCount() > 0) {
                        String newText = TextFocusListener.this.fText.getText().substring(0, TextFocusListener.this.fText.getSelection().x);
                        newText = String.valueOf(newText) + TextFocusListener.this.fText.getText().substring(TextFocusListener.this.fText.getSelection().y);
                        TextFocusListener.this.fText.setText(newText);
                    }
                }
            };
            this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
            this.selectAllAction = new Action(Messages.Q7Explorer_SelectAllLabel){

                public void run() {
                    TextFocusListener.this.fText.selectAll();
                }
            };
            this.selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        }
    }
}

