/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.processors.checksum;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumVerifier;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumHelper;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumProducer;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ProcessingStepDescriptor;
import org.eclipse.osgi.util.NLS;

public class ChecksumUtilities {
    private static final String ARTIFACT_CHECKSUMS_POINT = "org.eclipse.equinox.p2.artifact.repository.artifactChecksums";

    public static Collection<ProcessingStep> getChecksumVerifiers(IArtifactDescriptor descriptor, String property, Set<String> checksumsToSkip) throws IllegalArgumentException {
        ArrayList<ProcessingStep> steps = new ArrayList<ProcessingStep>();
        Map checksums = ChecksumHelper.getChecksums((IArtifactDescriptor)descriptor, (String)property);
        IConfigurationElement[] checksumVerifierConfigurations = ChecksumUtilities.getChecksumComparatorConfigurations();
        for (Map.Entry checksumEntry : checksums.entrySet()) {
            if (checksumsToSkip.contains(checksumEntry.getKey())) continue;
            IConfigurationElement[] iConfigurationElementArray = checksumVerifierConfigurations;
            int n = checksumVerifierConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement checksumVerifierConfiguration = iConfigurationElementArray[n2];
                String checksumId = checksumVerifierConfiguration.getAttribute("id");
                if (((String)checksumEntry.getKey()).equals(checksumId)) {
                    String checksumAlgorithm = checksumVerifierConfiguration.getAttribute("algorithm");
                    String providerName = checksumVerifierConfiguration.getAttribute("providerName");
                    ChecksumVerifier checksumVerifier = new ChecksumVerifier(checksumAlgorithm, providerName, checksumId);
                    checksumVerifier.initialize(null, (IProcessingStepDescriptor)new ProcessingStepDescriptor(null, (String)checksumEntry.getValue(), true), descriptor);
                    if (checksumVerifier.getStatus().isOK()) {
                        steps.add(checksumVerifier);
                    }
                }
                ++n2;
            }
        }
        return steps;
    }

    public static IConfigurationElement[] getChecksumComparatorConfigurations() {
        return RegistryFactory.getRegistry().getConfigurationElementsFor(ARTIFACT_CHECKSUMS_POINT);
    }

    public static IStatus calculateChecksums(File pathOnDisk, Map<String, String> checksums, Collection<String> checksumsToSkip) {
        MultiStatus status = new MultiStatus("org.eclipse.equinox.p2.repository", 0, NLS.bind((String)Messages.calculateChecksum_file, (Object)pathOnDisk.getAbsolutePath()), null);
        IConfigurationElement[] iConfigurationElementArray = ChecksumUtilities.getChecksumComparatorConfigurations();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement checksumVerifierConfiguration = iConfigurationElementArray[n2];
            String id = checksumVerifierConfiguration.getAttribute("id");
            if (!checksumsToSkip.contains(id)) {
                String algorithm = checksumVerifierConfiguration.getAttribute("algorithm");
                String providerName = checksumVerifierConfiguration.getAttribute("providerName");
                Optional<String> checksum = ChecksumUtilities.calculateChecksum(pathOnDisk, status, id, algorithm, providerName);
                checksum.ifPresent(c -> {
                    String string2 = checksums.put(id, (String)c);
                });
            }
            ++n2;
        }
        return status;
    }

    private static Optional<String> calculateChecksum(File pathOnDisk, MultiStatus status, String id, String algorithm, String providerName) {
        try {
            String checksum = ChecksumProducer.produce((File)pathOnDisk, (String)algorithm, (String)providerName);
            String message = NLS.bind((String)Messages.calculateChecksum_ok, (Object[])new Object[]{id, algorithm, providerName, checksum});
            status.add((IStatus)new Status(0, "org.eclipse.equinox.p2.repository", message));
            return Optional.of(checksum);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            String message = NLS.bind((String)Messages.calculateChecksum_providerError, (Object[])new Object[]{id, algorithm, providerName});
            status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", message, (Throwable)e));
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.calculateChecksum_error, (Object)id, (Object)algorithm);
            status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", message, (Throwable)e));
        }
        return Optional.empty();
    }

    public static Map<String, String> checksumsToProperties(String property, Map<String, String> checksums) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, String> checksum : checksums.entrySet()) {
            properties.put(String.join((CharSequence)".", property, checksum.getKey()), checksum.getValue());
        }
        ChecksumUtilities.putLegacyMd5Property(property, checksums, properties);
        return properties;
    }

    private static void putLegacyMd5Property(String propertyNamespace, Map<String, String> checksums, HashMap<String, String> result) {
        String md5 = checksums.get("md5");
        if (md5 != null) {
            if ("artifact.checksum".equals(propertyNamespace)) {
                result.put("artifact.md5", md5);
            }
            if ("download.checksum".equals(propertyNamespace)) {
                result.put("download.md5", md5);
            }
        }
    }
}

