/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.api;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lbc.internal.base.api.FloatingState;
import org.eclipse.passage.lbc.internal.base.api.FlsGear;
import org.eclipse.passage.lbc.internal.base.api.FlsGearAwre;
import org.eclipse.passage.lic.api.LicensingException;

public final class FloatingStateFromGear
implements Supplier<FloatingState> {
    private final Optional<Path> path;

    public FloatingStateFromGear(Path path) {
        this(Optional.of(path));
    }

    public FloatingStateFromGear(Optional<Path> path) {
        this.path = path;
    }

    @Override
    public FloatingState get() {
        Optional mayBeState;
        try {
            mayBeState = new FlsGearAwre().withGear(this::state);
        }
        catch (LicensingException e) {
            e.printStackTrace();
            mayBeState = Optional.empty();
        }
        if (!mayBeState.isPresent()) {
            throw new IllegalStateException("FLS configuration error: Floating State is not supplied");
        }
        return (FloatingState)mayBeState.get();
    }

    private Optional<FloatingState> state(FlsGear gear) {
        if (!this.path.isPresent()) {
            throw new IllegalStateException("FLS configuration error: storage path is not supplied");
        }
        return Optional.ofNullable(gear.state(this.path::get));
    }
}

