/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.licenses.model;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.passage.lic.internal.licenses.model.migration.EnsurePersonalPackProduct;
import org.eclipse.passage.lic.licenses.model.api.PersonalFeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;

public final class AssignGrantIdentifiers
implements Consumer<PersonalLicensePack> {
    private final Predicate<String> predicate = ((Predicate<String>)String::isEmpty).negate();

    @Override
    public void accept(PersonalLicensePack pack) {
        new EnsurePersonalPackProduct().apply(pack);
        String identifier = pack.getLicense().getIdentifier();
        EList<PersonalFeatureGrant> grants = pack.getGrants();
        int i = 0;
        while (i < grants.size()) {
            PersonalFeatureGrant grant = (PersonalFeatureGrant)grants.get(i);
            if (!Optional.ofNullable(grant.getIdentifier()).filter(this.predicate).isPresent()) {
                grant.setIdentifier(String.valueOf(identifier) + '#' + i);
            }
            ++i;
        }
    }
}

