/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import oshi.hardware.common.AbstractBaseboard;
import oshi.util.FileUtil;

final class LinuxBaseboard
extends AbstractBaseboard {
    private static final long serialVersionUID = 1L;
    private static final String SYSFS_SERIAL_PATH = "/sys/devices/virtual/dmi/id/";

    LinuxBaseboard() {
        this.init();
    }

    private void init() {
        String boardSerialNumber;
        String boardVersion;
        String boardName;
        String boardVendor = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_vendor");
        if (boardVendor != null && !boardVendor.trim().isEmpty()) {
            this.setManufacturer(boardVendor.trim());
        }
        if ((boardName = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_name")) != null && !boardName.trim().isEmpty()) {
            this.setModel(boardName.trim());
        }
        if ((boardVersion = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_version")) != null && !boardVersion.trim().isEmpty()) {
            this.setVersion(boardVersion.trim());
        }
        if ((boardSerialNumber = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial")) != null && !boardSerialNumber.trim().isEmpty()) {
            this.setSerialNumber(boardSerialNumber.trim());
        }
    }
}

