/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.passage.lbc.internal.api.Chore;
import org.eclipse.passage.lbc.internal.api.Chores;
import org.eclipse.passage.lbc.internal.api.FloatingResponse;
import org.eclipse.passage.lbc.internal.api.RawRequest;
import org.eclipse.passage.lbc.internal.base.Acquire;
import org.eclipse.passage.lbc.internal.base.Failure;
import org.eclipse.passage.lbc.internal.base.Mine;
import org.eclipse.passage.lbc.internal.base.Release;
import org.eclipse.passage.lic.internal.api.conditions.ConditionAction;
import org.eclipse.passage.lic.internal.net.LicensingAction;

final class FloatingCycle
implements Chores {
    private final Map<ConditionAction, Function<RawRequest, Chore>> chores = new HashMap<ConditionAction, Function<RawRequest, Chore>>();

    FloatingCycle() {
        this.chores.put((ConditionAction)new ConditionAction.Mine(), Mine::new);
        this.chores.put((ConditionAction)new ConditionAction.Acquire(), Acquire::new);
        this.chores.put((ConditionAction)new ConditionAction.Release(), Release::new);
    }

    public FloatingResponse workOut(RawRequest request) {
        LicensingAction action = this.action(request);
        return this.chores.getOrDefault(action.get().get(), unknown -> new Failing(action)).apply(request).getDone();
    }

    private LicensingAction action(RawRequest request) {
        return new LicensingAction(key -> new ConditionAction.Of(String.valueOf(request.parameter(key))));
    }

    private final class Failing
    implements Chore {
        private final LicensingAction actual;

        Failing(LicensingAction actual) {
            this.actual = actual;
        }

        public FloatingResponse getDone() {
            return new Failure.BadRequestUnknownAction(((ConditionAction)this.actual.get().get()).name());
        }
    }
}

