/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import java.io.Serializable;
import org.sat4j.core.Vec;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Learner;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.UnitPropagationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataStructureFactory
implements DataStructureFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ILits lits;
    private final IVec<Propagatable> tmp = new Vec<Propagatable>();
    protected UnitPropagationListener solver;
    protected Learner learner;

    @Override
    public void conflictDetectedInWatchesFor(int p, int i) {
        int j = i + 1;
        while (j < this.tmp.size()) {
            this.lits.watch(p, this.tmp.get(j));
            ++j;
        }
    }

    @Override
    public IVec<Propagatable> getWatchesFor(int p) {
        this.tmp.clear();
        this.lits.watches(p).moveTo(this.tmp);
        return this.tmp;
    }

    protected AbstractDataStructureFactory() {
        this.lits = this.createLits();
    }

    protected abstract ILits createLits();

    @Override
    public ILits getVocabulary() {
        return this.lits;
    }

    @Override
    public void setUnitPropagationListener(UnitPropagationListener s) {
        this.solver = s;
    }

    @Override
    public void setLearner(Learner learner) {
        this.learner = learner;
    }

    @Override
    public void reset() {
    }

    @Override
    public void learnConstraint(Constr constr) {
        this.learner.learn(constr);
    }

    @Override
    public Constr createCardinalityConstraint(IVecInt literals, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Constr createUnregisteredCardinalityConstraint(IVecInt literals, int degree) {
        throw new UnsupportedOperationException();
    }
}

