/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.passage.lic.internal.api.registry.RuntimeRegistry;
import org.eclipse.passage.lic.internal.api.registry.Service;
import org.eclipse.passage.lic.internal.api.registry.ServiceId;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;
import org.eclipse.passage.lic.internal.base.registry.BaseRegistry;

public final class BaseRuntimeRegistry<I extends ServiceId, S extends Service<I>>
extends BaseRegistry<I, S>
implements RuntimeRegistry<I, S> {
    private final Consumer<String> handler;

    public BaseRuntimeRegistry(Collection<S> services, Consumer<String> handler) {
        super(services);
        this.handler = handler;
    }

    public BaseRuntimeRegistry(Consumer<String> handler) {
        this(Collections.emptyList(), handler);
    }

    public BaseRuntimeRegistry() {
        this(System.err::println);
    }

    public void register(S service) {
        Objects.requireNonNull(service);
        this.checkOverride(service);
        this.services.put(service.id(), service);
    }

    public void unregister(S service) {
        this.checkAbsent(service);
        this.services.remove(service.id());
    }

    private void checkOverride(S service) {
        if (!this.hasService(service.id())) {
            return;
        }
        this.handler.accept(String.format(BaseMessages.getString("RuntimeRegistry.register_override"), service.id(), this.service(service.id()), service));
    }

    private void checkAbsent(S service) {
        if (this.hasService(service.id())) {
            return;
        }
        this.handler.accept(String.format(BaseMessages.getString("RuntimeRegistry.unregister_absent"), service));
    }
}

