/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import java.util.regex.Pattern;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.mac.MacBaseboard;
import oshi.hardware.platform.mac.MacFirmware;
import oshi.jna.platform.mac.IOKit;
import oshi.util.ExecutingCommand;
import oshi.util.platform.mac.IOKitUtil;

final class MacComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;
    private static final String APPLE = "Apple Inc.";

    MacComputerSystem() {
        this.init();
    }

    private void init() {
        this.setManufacturer(APPLE);
        String modelName = "";
        String modelNameMarker = "Model Name:";
        String modelIdentifier = "";
        String modelIdMarker = "Model Identifier:";
        String serialNumberSystem = "";
        String serialNumMarker = "Serial Number (system):";
        String smcVersion = "";
        String smcMarker = "SMC Version (system):";
        String bootRomVersion = "";
        String bootRomMarker = "Boot ROM Version:";
        MacFirmware firmware = new MacFirmware();
        firmware.setManufacturer(APPLE);
        firmware.setName("EFI");
        MacBaseboard baseboard = new MacBaseboard();
        baseboard.setManufacturer(APPLE);
        baseboard.setModel("SMC");
        for (String checkLine : ExecutingCommand.runNative("system_profiler SPHardwareDataType")) {
            if (checkLine.contains("Model Name:")) {
                modelName = checkLine.split("Model Name:")[1].trim();
            }
            if (checkLine.contains("Model Identifier:")) {
                modelIdentifier = checkLine.split("Model Identifier:")[1].trim();
            }
            if (checkLine.contains("Boot ROM Version:")) {
                bootRomVersion = checkLine.split("Boot ROM Version:")[1].trim();
            }
            if (checkLine.contains("SMC Version (system):")) {
                smcVersion = checkLine.split(Pattern.quote("SMC Version (system):"))[1].trim();
            }
            if (!checkLine.contains("Serial Number (system):")) continue;
            serialNumberSystem = checkLine.split(Pattern.quote("Serial Number (system):"))[1].trim();
        }
        if (!modelName.isEmpty()) {
            if (!modelIdentifier.isEmpty()) {
                this.setModel(modelName + " (" + modelIdentifier + ")");
            } else {
                this.setModel(modelName);
            }
        } else if (!modelIdentifier.isEmpty()) {
            this.setModel(modelIdentifier);
        }
        if (serialNumberSystem.isEmpty()) {
            serialNumberSystem = this.getSystemSerialNumber();
        }
        this.setSerialNumber(serialNumberSystem);
        baseboard.setSerialNumber(serialNumberSystem);
        if (!smcVersion.isEmpty()) {
            baseboard.setVersion(smcVersion);
        }
        if (bootRomVersion != null && !bootRomVersion.isEmpty()) {
            firmware.setVersion(bootRomVersion);
        }
        this.setFirmware(firmware);
        this.setBaseboard(baseboard);
    }

    private String getSystemSerialNumber() {
        String serialNumber = null;
        int service = IOKitUtil.getMatchingService("IOPlatformExpertDevice");
        if (service != 0) {
            serialNumber = IOKitUtil.getIORegistryStringProperty(service, "IOPlatformSerialNumber");
            IOKit.INSTANCE.IOObjectRelease(service);
        }
        if (serialNumber == null) {
            serialNumber = "unknown";
        }
        return serialNumber;
    }
}

