/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.internal.api.conditions.Condition;

public final class ReleaseReport
implements Supplier<Collection<ReleaseResult>> {
    private final Collection<ReleaseResult> result;

    public ReleaseReport(Collection<ReleaseResult> result) {
        Objects.requireNonNull(result, "ReleaseReport::result");
        this.result = result;
    }

    public Collection<Condition> bad() {
        return this.get().stream().filter(Predicate.not(ReleaseResult::result)).map(ReleaseResult::condition).collect(Collectors.toList());
    }

    @Override
    public Collection<ReleaseResult> get() {
        return this.result;
    }

    public static final class ReleaseResult {
        private final Condition condition;
        private final boolean result;

        public ReleaseResult(Condition condition, boolean verdict) {
            this.condition = condition;
            this.result = verdict;
        }

        public Condition condition() {
            return this.condition;
        }

        public boolean result() {
            return this.result;
        }
    }
}

