/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import org.sat4j.pb.constraints.pb.ConflictMap;
import org.sat4j.pb.constraints.pb.IPostProcess;

public class PostProcessDivideByGCD
implements IPostProcess {
    private static final PostProcessDivideByGCD INSTANCE = new PostProcessDivideByGCD();

    private PostProcessDivideByGCD() {
    }

    public static final PostProcessDivideByGCD instance() {
        return INSTANCE;
    }

    @Override
    public void postProcess(int dl, ConflictMap conflictMap) {
        int gcd = conflictMap.reduceCoeffsByGCD();
        if (gcd > 1) {
            conflictMap.stats.incNumberOfReductionsByGCD();
        }
    }

    public String toString() {
        return "Performs a post-processing after conflict analysis in order to divide by gcd over coefficients of learned constraints";
    }
}

