/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.WizardFileSystemResourceImportPage1;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class WizardArchiveFileResourceImportPage1
extends WizardFileSystemResourceImportPage1
implements Listener {
    ILeveledImportStructureProvider structureProvider;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private static final String STORE_SOURCE_NAMES_ID = "WizardZipFileResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "WizardZipFileResourceImportPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private final String[] fileImportMask;

    public WizardArchiveFileResourceImportPage1(IStructuredSelection selection) {
        this(selection, null);
    }

    public WizardArchiveFileResourceImportPage1(IStructuredSelection selection, String[] fileImportMask) {
        super("zipFileImportPage1", selection);
        this.setTitle(DataTransferMessages.ArchiveExport_exportTitle);
        this.setDescription(DataTransferMessages.ArchiveImport_description);
        this.fileImportMask = fileImportMask == null ? FILE_IMPORT_MASK : fileImportMask;
    }

    public boolean cancel() {
        this.disposeStructureProvider();
        return true;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.zip_file_import_wizard_page");
    }

    @Override
    protected void createOptionsGroup(Composite parent) {
        this.overwriteExistingResourcesCheckbox = new Button(parent, 32);
        this.overwriteExistingResourcesCheckbox.setText(DataTransferMessages.FileImport_overwriteExisting);
        this.overwriteExistingResourcesCheckbox.setFont(parent.getFont());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateSourceFile(String fileName) {
        if (ArchiveFileManipulations.isTarFile(fileName)) {
            try {
                Throwable throwable = null;
                Object var3_8 = null;
                try (TarFile tarFile = this.getSpecifiedTarSourceFile(fileName);){
                    if (tarFile == null) return false;
                    return true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        try {
            Throwable throwable = null;
            Object var3_10 = null;
            try (ZipFile zipFile = this.getSpecifiedZipSourceFile(fileName);){
                if (zipFile == null) return false;
                ArchiveFileManipulations.closeZipFile(zipFile, this.getShell());
                return true;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean ensureZipSourceIsValid() {
        ZipFile specifiedFile = this.getSpecifiedZipSourceFile();
        if (specifiedFile == null) {
            this.setErrorMessage(DataTransferMessages.ZipImport_badFormat);
            return false;
        }
        return ArchiveFileManipulations.closeZipFile(specifiedFile, this.getShell());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ensureTarSourceIsValid() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (TarFile specifiedFile = this.getSpecifiedTarSourceFile();){
                if (specifiedFile != null) return true;
                this.setErrorMessage(DataTransferMessages.TarImport_badFormat);
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected boolean ensureSourceIsValid() {
        if (ArchiveFileManipulations.isTarFile(this.sourceNameField.getText())) {
            return this.ensureTarSourceIsValid();
        }
        return this.ensureZipSourceIsValid();
    }

    @Override
    public boolean finish() {
        if (!super.finish()) {
            return false;
        }
        this.disposeStructureProvider();
        return true;
    }

    private void disposeStructureProvider() {
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
        this.structureProvider = null;
    }

    @Override
    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    AdaptableList l = element.getFiles(WizardArchiveFileResourceImportPage1.this.structureProvider);
                    return l.getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    @Override
    protected MinimizedFileSystemElement getFileSystemTree() {
        this.disposeStructureProvider();
        if (ArchiveFileManipulations.isTarFile(this.sourceNameField.getText())) {
            TarFile sourceTarFile = this.getSpecifiedTarSourceFile();
            if (sourceTarFile == null) {
                return null;
            }
            this.structureProvider = new TarLeveledStructureProvider(sourceTarFile);
            return this.selectFiles(this.structureProvider.getRoot(), this.structureProvider);
        }
        ZipFile sourceFile = this.getSpecifiedZipSourceFile();
        if (sourceFile == null) {
            return null;
        }
        this.structureProvider = new ZipLeveledStructureProvider(sourceFile);
        return this.selectFiles(this.structureProvider.getRoot(), this.structureProvider);
    }

    public void dispose() {
        super.dispose();
        if (this.structureProvider != null) {
            try {
                this.structureProvider.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    AdaptableList l = element.getFolders(WizardArchiveFileResourceImportPage1.this.structureProvider);
                    return l.getChildren((Object)element);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    if (element.isPopulated()) {
                        return this.getChildren((Object)element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    protected String getSourceLabel() {
        return DataTransferMessages.ArchiveImport_fromFile;
    }

    protected ZipFile getSpecifiedZipSourceFile() {
        return this.getSpecifiedZipSourceFile(this.sourceNameField.getText());
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.isEmpty()) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (IOException iOException) {
            this.sourceNameField.setFocus();
            return null;
        }
    }

    protected TarFile getSpecifiedTarSourceFile() {
        return this.getSpecifiedTarSourceFile(this.sourceNameField.getText());
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.isEmpty()) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (IOException | TarException exception) {
            this.sourceNameField.setFocus();
            return null;
        }
    }

    @Override
    protected void handleSourceBrowseButtonPressed() {
        String selectedFile = this.queryZipFileToImport();
        if (selectedFile != null && !selectedFile.equals(this.sourceNameField.getText()) && this.validateSourceFile(selectedFile)) {
            this.setSourceName(selectedFile);
            this.selectionGroup.setFocus();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean importResources(List fileSystemObjects) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ILeveledImportStructureProvider importStructureProvider = this.extracted();){
                if (importStructureProvider == null) {
                    return false;
                }
                ImportOperation operation = new ImportOperation(this.getContainerFullPath(), importStructureProvider.getRoot(), importStructureProvider, this, fileSystemObjects);
                operation.setContext(this.getShell());
                if (this.executeImportOperation(operation)) return true;
                return false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception closeExcption) {
            return false;
        }
    }

    private ILeveledImportStructureProvider extracted() {
        ILeveledImportStructureProvider importStructureProvider = null;
        if (ArchiveFileManipulations.isTarFile(this.sourceNameField.getText())) {
            if (this.ensureTarSourceIsValid()) {
                TarFile tarFile = this.getSpecifiedTarSourceFile();
                importStructureProvider = new TarLeveledStructureProvider(tarFile);
            }
        } else if (this.ensureZipSourceIsValid()) {
            ZipFile zipFile = this.getSpecifiedZipSourceFile();
            importStructureProvider = new ZipLeveledStructureProvider(zipFile);
        }
        return importStructureProvider;
    }

    @Override
    protected void initializeOperation(ImportOperation op) {
        op.setOverwriteResources(this.overwriteExistingResourcesCheckbox.getSelection());
    }

    protected String queryZipFileToImport() {
        FileDialog dialog = new FileDialog(this.sourceNameField.getShell(), 0x10001000);
        dialog.setFilterExtensions(this.fileImportMask);
        dialog.setText(DataTransferMessages.ArchiveImportSource_title);
        String currentSourceString = this.sourceNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    @Override
    protected void resetSelection() {
        super.resetSelection();
        this.setAllSelections(true);
    }

    @Override
    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            String[] stringArray = sourceNames;
            int n = sourceNames.length;
            int n2 = 0;
            while (n2 < n) {
                String sourceName = stringArray[n2];
                this.sourceNameField.add(sourceName);
                ++n2;
            }
            this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
        }
    }

    @Override
    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.sourceNameField.getText());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
        }
    }

    @Override
    protected boolean validateSourceGroup() {
        if (this.structureProvider == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        List<?> resourcesToExport = this.selectionGroup.getAllWhiteCheckedItems();
        if (resourcesToExport.isEmpty()) {
            this.setErrorMessage(DataTransferMessages.FileImport_noneSelected);
            return false;
        }
        this.enableButtonGroup(true);
        this.setErrorMessage(null);
        return true;
    }
}

