/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.oomph.setup.internal.installer.DesktopSupport;
import org.eclipse.oomph.setup.internal.installer.Messages;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;

public class FreeDesktopSupport
implements DesktopSupport {
    private static final String IM_MODULE_XIM = "xim";
    private static final String DESKTOP_FILE_EXTENSION = ".desktop";
    private File userDir = new File(System.getProperty("user.home"));

    public FreeDesktopSupport() {
        if (!this.userDir.isDirectory()) {
            throw new IllegalStateException(NLS.bind((String)Messages.FreeDesktopSupport_NoUserHome, (Object)this.userDir));
        }
    }

    @Override
    public void pinToTaskBar(String location, String launcherName) throws IOException {
    }

    @Override
    public boolean createShortCut(DesktopSupport.ShortcutType type, String groupName, File executable, String shortcutName, String description, String id) throws IOException {
        return DesktopSupport.super.createShortCut(type, groupName, executable, shortcutName, description, id, "Eclipse");
    }

    @Override
    public boolean createShortCut(DesktopSupport.ShortcutType type, String groupName, File executable, String shortcutName, String description, String id, String appName) throws IOException {
        StringBuilder desktopFile = new StringBuilder();
        desktopFile.append("[Desktop Entry]\n");
        desktopFile.append("Type=Application\n");
        desktopFile.append("Terminal=false\n");
        desktopFile.append("Encoding=UTF-8\n");
        desktopFile.append("Version=1.1\n");
        desktopFile.append("Name=").append(shortcutName).append("\n");
        desktopFile.append("StartupWMClass=").append(appName == null ? "Eclipse" : appName).append("\n");
        desktopFile.append("Exec=");
        String module = System.getenv("GTK_IM_MODULE");
        if (IM_MODULE_XIM.equals(module)) {
            try {
                Process process = Runtime.getRuntime().exec("im-config -l");
                String[] stringArray = IOUtil.readUTF8((InputStream)process.getInputStream()).trim().split("\\s+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (!IM_MODULE_XIM.equals(s) && !StringUtil.isEmpty((String)s.trim())) {
                        module = s;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception process) {
                // empty catch block
            }
        }
        if (module != null && !StringUtil.isEmpty((String)module.trim())) {
            desktopFile.append("env GTK_IM_MODULE=");
            desktopFile.append(module);
            desktopFile.append(' ');
        }
        desktopFile.append(executable).append("\n");
        desktopFile.append("Categories=Development;IDE;");
        if (groupName != null) {
            desktopFile.append(groupName);
        }
        desktopFile.append("\n");
        File icon = new File(executable.getParentFile(), "icon.xpm");
        if (icon.isFile()) {
            desktopFile.append("Icon=").append(icon.getAbsolutePath()).append("\n");
        }
        if (type == DesktopSupport.ShortcutType.START_MENU) {
            return this.writeStartMenuDesktopFile(id, desktopFile);
        }
        if (type == DesktopSupport.ShortcutType.DESKTOP) {
            return this.writeDesktopShortCutFile(desktopFile, shortcutName);
        }
        return false;
    }

    private boolean writeDesktopShortCutFile(StringBuilder desktopFile, String shortcutName) throws IOException {
        File userDirsFile = new File(this.userDir, ".config/user-dirs.dirs");
        List readLines = IOUtil.readLines((File)userDirsFile, (String)"UTF-8");
        for (String line : readLines) {
            if (!line.startsWith("XDG_DESKTOP_DIR=")) continue;
            String desktopPath = line.split("=", 2)[1].trim();
            if (desktopPath.startsWith("\"")) {
                desktopPath = desktopPath.substring(1);
            }
            if (desktopPath.endsWith("\"")) {
                desktopPath = desktopPath.substring(0, desktopPath.length() - 1);
            }
            File outputFile = new File(desktopPath.replace("$HOME", this.userDir.getAbsolutePath()), String.valueOf(shortcutName) + DESKTOP_FILE_EXTENSION);
            IOUtil.writeUTF8((File)outputFile, (String)("#!/usr/bin/env xdg-open\n" + desktopFile.toString()));
            Runtime.getRuntime().exec(new String[]{"chmod", "+x", outputFile.getAbsolutePath()});
            return true;
        }
        return false;
    }

    private boolean writeStartMenuDesktopFile(String id, StringBuilder desktopFile) throws IOException {
        File userApplicationsDir = new File(this.userDir, ".local/share/applications");
        if (!userApplicationsDir.mkdirs() && !userApplicationsDir.isDirectory()) {
            throw new IOException(NLS.bind((String)Messages.FreeDesktopSupport_CannotCreateDirectory, (Object)userApplicationsDir.getAbsolutePath()));
        }
        String cleanId = id.replaceAll("[^.A-Za-z0-9-_]", "_").replaceAll("\\.+", ".");
        File outputFile = new File(userApplicationsDir, String.valueOf(cleanId) + DESKTOP_FILE_EXTENSION);
        if (outputFile.exists() && !outputFile.renameTo(new File(userApplicationsDir, String.valueOf(outputFile.getName()) + "." + System.currentTimeMillis() + ".backup"))) {
            return false;
        }
        IOUtil.writeUTF8((File)outputFile, (String)desktopFile.toString());
        try {
            Runtime.getRuntime().exec(new String[]{"update-desktop-database", userApplicationsDir.getAbsolutePath()});
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

