/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.projects.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.predicates.Predicate;
import org.eclipse.oomph.predicates.PredicatesUtil;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.projects.ProjectsBuildTask;
import org.eclipse.oomph.setup.projects.ProjectsPackage;
import org.eclipse.oomph.setup.projects.impl.Messages;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;

public class ProjectsBuildTaskImpl
extends SetupTaskImpl
implements ProjectsBuildTask {
    protected EList<Predicate> predicates;
    protected static final boolean ONLY_NEW_PROJECTS_EDEFAULT = false;
    protected boolean onlyNewProjects = false;
    private static final IWorkspaceRoot ROOT = EcorePlugin.getWorkspaceRoot();
    protected static final boolean REFRESH_EDEFAULT = false;
    protected boolean refresh = false;
    protected static final boolean CLEAN_EDEFAULT = false;
    protected boolean clean = false;
    protected static final boolean BUILD_EDEFAULT = true;
    protected boolean build = true;
    private transient Set<IProject> existingProjects;

    protected ProjectsBuildTaskImpl() {
    }

    protected EClass eStaticClass() {
        return ProjectsPackage.Literals.PROJECTS_BUILD_TASK;
    }

    @Override
    public EList<Predicate> getPredicates() {
        if (this.predicates == null) {
            this.predicates = new EObjectContainmentEList(Predicate.class, (InternalEObject)this, 10);
        }
        return this.predicates;
    }

    @Override
    public boolean isOnlyNewProjects() {
        return this.onlyNewProjects;
    }

    @Override
    public void setOnlyNewProjects(boolean newOnlyNewProjects) {
        boolean oldOnlyNewProjects = this.onlyNewProjects;
        this.onlyNewProjects = newOnlyNewProjects;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldOnlyNewProjects, this.onlyNewProjects));
        }
    }

    @Override
    public boolean isRefresh() {
        return this.refresh;
    }

    @Override
    public void setRefresh(boolean newRefresh) {
        boolean oldRefresh = this.refresh;
        this.refresh = newRefresh;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldRefresh, this.refresh));
        }
    }

    @Override
    public boolean isClean() {
        return this.clean;
    }

    @Override
    public void setClean(boolean newClean) {
        boolean oldClean = this.clean;
        this.clean = newClean;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldClean, this.clean));
        }
    }

    @Override
    public boolean isBuild() {
        return this.build;
    }

    @Override
    public void setBuild(boolean newBuild) {
        boolean oldBuild = this.build;
        this.build = newBuild;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldBuild, this.build));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 10: {
                return ((InternalEList)this.getPredicates()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getPredicates();
            }
            case 11: {
                return this.isOnlyNewProjects();
            }
            case 12: {
                return this.isRefresh();
            }
            case 13: {
                return this.isClean();
            }
            case 14: {
                return this.isBuild();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.getPredicates().clear();
                this.getPredicates().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setOnlyNewProjects((Boolean)newValue);
                return;
            }
            case 12: {
                this.setRefresh((Boolean)newValue);
                return;
            }
            case 13: {
                this.setClean((Boolean)newValue);
                return;
            }
            case 14: {
                this.setBuild((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.getPredicates().clear();
                return;
            }
            case 11: {
                this.setOnlyNewProjects(false);
                return;
            }
            case 12: {
                this.setRefresh(false);
                return;
            }
            case 13: {
                this.setClean(false);
                return;
            }
            case 14: {
                this.setBuild(true);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.predicates != null && !this.predicates.isEmpty();
            }
            case 11: {
                return this.onlyNewProjects;
            }
            case 12: {
                return this.refresh;
            }
            case 13: {
                return this.clean;
            }
            case 14: {
                return !this.build;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (onlyNewProjects: ");
        result.append(this.onlyNewProjects);
        result.append(", refresh: ");
        result.append(this.refresh);
        result.append(", clean: ");
        result.append(this.clean);
        result.append(", build: ");
        result.append(this.build);
        result.append(')');
        return result.toString();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        if (!(this.isRefresh() || this.isClean() || this.isBuild())) {
            return false;
        }
        this.existingProjects = this.isOnlyNewProjects() ? this.getProjects() : null;
        return true;
    }

    public void perform(SetupTaskContext context) throws Exception {
        int size;
        EList<Predicate> predicates;
        Set<IProject> projects = this.getProjects();
        if (this.existingProjects != null) {
            projects.removeAll(this.existingProjects);
        }
        if (!(predicates = this.getPredicates()).isEmpty()) {
            Iterator<IProject> it = projects.iterator();
            while (it.hasNext()) {
                IProject project = it.next();
                if (PredicatesUtil.matchesPredicates((IResource)project, predicates)) continue;
                it.remove();
            }
        }
        if ((size = projects.size()) == 0) {
            this.logNothingToDo(context);
            return;
        }
        IProgressMonitor monitor = context.getProgressMonitor(true);
        monitor.beginTask("", (this.isRefresh() ? size : 0) + (this.isClean() ? size : 0) + (this.isBuild() ? size : 0));
        try {
            if (this.isRefresh()) {
                for (IProject project : projects) {
                    context.log(NLS.bind((String)Messages.ProjectsBuildTaskImpl_Refreshing_message, (Object)project.getName()), false);
                    project.refreshLocal(2, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                }
            }
            IBuildConfiguration[] buildsConfigs = null;
            if (this.isClean()) {
                buildsConfigs = this.getBuildConfigs(projects);
                ROOT.getWorkspace().build(buildsConfigs, 15, false, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)size));
            }
            if (this.isBuild()) {
                if (buildsConfigs == null) {
                    buildsConfigs = this.getBuildConfigs(projects);
                }
                ROOT.getWorkspace().build(buildsConfigs, 6, false, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)size));
            }
        }
        finally {
            monitor.done();
        }
    }

    private Set<IProject> getProjects() {
        return new HashSet<IProject>(Arrays.asList(ROOT.getProjects()));
    }

    private IBuildConfiguration[] getBuildConfigs(Set<IProject> projects) throws CoreException {
        ArrayList<IBuildConfiguration> buildConfigs = new ArrayList<IBuildConfiguration>();
        for (IProject project : projects) {
            if (!project.isOpen()) continue;
            buildConfigs.add(project.getBuildConfig(""));
        }
        return buildConfigs.toArray(new IBuildConfiguration[buildConfigs.size()]);
    }

    private void logNothingToDo(SetupTaskContext context) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (this.isRefresh()) {
            tokens.add(Messages.ProjectsBuildTaskImpl_Refresh_message_part);
        }
        if (this.isClean()) {
            tokens.add(Messages.ProjectsBuildTaskImpl_Clean_message_part);
        }
        if (this.isBuild()) {
            tokens.add(Messages.ProjectsBuildTaskImpl_Build_message_part);
        }
        context.log(NLS.bind((String)Messages.ProjectsBuildTaskImpl_NothingToDo_message, (Object)StringUtil.implode(tokens, (char)',')));
    }
}

