/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.quickfixes;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.ui.quickfixes.AbstractDocumentResolution;
import org.eclipse.oomph.version.ui.quickfixes.Messages;

public class ReplaceResolution
extends AbstractDocumentResolution {
    private String problemType;
    private String replacement;

    public ReplaceResolution(IMarker marker, String problemType, String replacement) {
        super(marker, ReplaceResolution.getLabel(marker, problemType, replacement), replacement == null ? "icons/correction_delete.gif" : "icons/correction_change.gif");
        this.problemType = problemType;
        this.replacement = replacement == null ? "" : replacement;
    }

    private static String getLabel(IMarker marker, String problemType, String replacement) {
        String message;
        if ("schema.builder".equals(problemType)) {
            return replacement == null ? Messages.ReplaceResolution_label_removeSchemaBuilder : Messages.ReplaceResolution_label_addSchemaBuilder;
        }
        if ("feature.nature".equals(problemType)) {
            return Messages.ReplaceResolution_label_addFeatureBuilder;
        }
        if ("feature.closure".equals(problemType)) {
            return Messages.ReplaceResolution_label_addPluginReference;
        }
        if ("debug.option".equals(problemType)) {
            return Messages.ReplaceResolution_label_changeDebugOption;
        }
        if ("automatic.module.name".equals(problemType)) {
            return Messages.ReplaceResolution_label_changeAutomaticModuleName;
        }
        if ("maven.pom".equals(problemType) && (message = Markers.getAttribute((IMarker)marker, (String)"message")) != null) {
            if (message.startsWith("Maven artifactId")) {
                return Messages.ReplaceResolution_label_changeMavenArtifactId;
            }
            if (message.startsWith("Maven version")) {
                return Messages.ReplaceResolution_label_changeMavenVersion;
            }
        }
        return replacement == null ? Messages.ReplaceResolution_label_removeReference : (Markers.getQuickFixAlternativeReplacement((IMarker)marker) == null ? Messages.ReplaceResolution_label_changeVersion : Messages.ReplaceResolution_label_changeToExactVersion);
    }

    @Override
    public String getDescription() {
        if (this.replacement.length() != 0) {
            return String.valueOf(this.getLabel()) + ' ' + Messages.ReplaceResolution_label_to + ' ' + this.replacement;
        }
        return super.getDescription();
    }

    @Override
    protected boolean isApplicable(IMarker marker) {
        boolean actualReplacement;
        if (!this.problemType.equals(Markers.getProblemType((IMarker)marker)) || Markers.getQuickFixPattern((IMarker)marker) == null) {
            return false;
        }
        boolean expectedReplacement = this.replacement.length() != 0;
        boolean bl = actualReplacement = this.getQuickFixReplacement(marker) != null;
        return actualReplacement == expectedReplacement;
    }

    protected String getQuickFixReplacement(IMarker marker) {
        return Markers.getQuickFixReplacement((IMarker)marker);
    }

    @Override
    protected boolean apply(IMarker marker, IDocument document) throws Exception {
        String content = document.get();
        String regEx = Markers.getQuickFixPattern((IMarker)marker);
        String replacement = this.getQuickFixReplacement(marker);
        Pattern pattern = Pattern.compile(regEx, 40);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int end;
            int start;
            if (replacement != null && replacement.length() != 0) {
                start = matcher.start(1);
                end = matcher.end(1);
                int i = 1;
                while (i < 9) {
                    String insertTag = "\\" + i;
                    if (replacement.contains(insertTag)) {
                        int offset = matcher.start(i);
                        int length = matcher.end(i) - offset;
                        String found = document.get(offset, length);
                        replacement = replacement.replace(insertTag, found);
                    }
                    ++i;
                }
            } else {
                start = matcher.start();
                end = matcher.end();
                replacement = "";
            }
            document.replace(start, end - start, replacement);
            return true;
        }
        return false;
    }
}

