/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpCookie;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProvider;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceSetItemProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedColorRegistry;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.provider.BaseItemProviderAdapterFactory;
import org.eclipse.oomph.base.util.BaseResourceImpl;
import org.eclipse.oomph.edit.NoChildrenDelegatingWrapperItemProvider;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.internal.ui.FindAndReplaceTarget;
import org.eclipse.oomph.internal.ui.IRevertablePart;
import org.eclipse.oomph.internal.ui.OomphEditingDomain;
import org.eclipse.oomph.internal.ui.OomphPropertySheetPage;
import org.eclipse.oomph.setup.Argument;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Configuration;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.MacroTask;
import org.eclipse.oomph.setup.Parameter;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.ResourceMirror;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.p2.util.MarketPlaceListing;
import org.eclipse.oomph.setup.presentation.Messages;
import org.eclipse.oomph.setup.presentation.SetupActionBarContributor;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.provider.PreferenceTaskItemProvider;
import org.eclipse.oomph.setup.provider.SetupItemProviderAdapterFactory;
import org.eclipse.oomph.setup.ui.SetupEditorSupport;
import org.eclipse.oomph.setup.ui.SetupLabelProvider;
import org.eclipse.oomph.setup.ui.SetupTransferSupport;
import org.eclipse.oomph.setup.ui.ToolTipLabelProvider;
import org.eclipse.oomph.setup.ui.actions.ConfigureMarketPlaceListingAction;
import org.eclipse.oomph.ui.DockableDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.workingsets.presentation.WorkingSetsActionBarContributor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class SetupEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker,
IRevertablePart,
WorkingSetsActionBarContributor.PreviewDialog.Previewable {
    private static final Object VARIABLE_GROUP_IMAGE = SetupEditorPlugin.INSTANCE.getImage("full/obj16/VariableGroup");
    private static final Pattern HEADER_PATTERN = Pattern.compile("(<h1)(>)");
    private static final Pattern IMAGE_PATTERN = Pattern.compile("(<img )(src=)");
    private static final URI COMPOSITE_OUTLINE_COLOR = URI.createURI((String)"color://rgb/138/110/85");
    private static final Object UNDECLARED_VARIABLE_GROUP_IMAGE;
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected OutlinePreviewPage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == SetupEditor.this.contentOutlinePage) {
                    SetupEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)SetupEditor.this);
                    ((EditorSite)SetupEditor.this.getEditorSite()).activateActionBars(true);
                    SetupEditor.this.setCurrentViewer((Viewer)SetupEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (SetupEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    SetupEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)SetupEditor.this);
                    ((EditorSite)SetupEditor.this.getEditorSite()).activateActionBars(true);
                    SetupEditor.this.handleActivate();
                }
            } else if (p == SetupEditor.this) {
                SetupEditor.this.handleActivate();
                SetupEditor.this.setCurrentViewer((Viewer)SetupEditor.this.selectionViewer);
            } else if (!(p instanceof SetupEditor)) {
                ((EditorSite)SetupEditor.this.getEditorSite()).deactivateActionBars(true);
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowActivated(IWorkbenchWindow window) {
            IWorkbenchPage activePage;
            if (SetupEditor.this.getSite().getWorkbenchWindow() == window && (activePage = window.getActivePage()) != null) {
                IWorkbenchPart activePart = activePage.getActivePart();
                if (activePart instanceof ContentOutline) {
                    if (((ContentOutline)activePart).getCurrentPage() == SetupEditor.this.contentOutlinePage) {
                        SetupEditor.this.handleActivate();
                    }
                } else if (activePart instanceof PropertySheet) {
                    if (SetupEditor.this.propertySheetPages.contains(((PropertySheet)activePart).getCurrentPage())) {
                        SetupEditor.this.handleActivate();
                    }
                } else if (activePart == SetupEditor.this) {
                    SetupEditor.this.handleActivate();
                }
            }
        }
    };
    protected boolean isHandlingActivate;
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){
        protected boolean dispatching;

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = SetupEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            SetupEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            SetupEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        this.dispatchUpdateProblemIndication();
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void dispatchUpdateProblemIndication() {
            if (SetupEditor.this.updateProblemIndication && !this.dispatching) {
                this.dispatching = true;
                SetupEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        dispatching = false;
                        SetupEditor.this.updateProblemIndication();
                    }
                });
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            SetupEditor.this.resourceToDiagnosticMap.remove(target);
            this.dispatchUpdateProblemIndication();
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).SetupEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            if (delta.getKind() == 2 || delta.getKind() == 4) {
                                EList resources = this.resourceSet.getResources();
                                ArrayList originalResources = new ArrayList(resources);
                                Resource resource = null;
                                try {
                                    resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false);
                                }
                                catch (RuntimeException runtimeException) {
                                    // empty catch block
                                }
                                if (resources.retainAll(originalResources) || !resources.contains(resource)) {
                                    resource = null;
                                }
                                if (resource != null) {
                                    if (delta.getKind() == 2) {
                                        this.removedResources.add(resource);
                                    } else {
                                        if ((delta.getFlags() & 0x20000) != 0) {
                                            DiagnosticDecorator.DiagnosticAdapter.update((Notifier)resource, (Diagnostic)(this).SetupEditor.this.markerHelper.getMarkerDiagnostics((Object)resource, (IFile)delta.getResource()));
                                        }
                                        if ((delta.getFlags() & 0x100) != 0 && !(this).SetupEditor.this.savedResources.remove(resource)) {
                                            this.changedResources.add(resource);
                                        }
                                    }
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    SetupEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).SetupEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!SetupEditor.this.isDirty()) {
                                SetupEditor.this.getSite().getPage().closeEditor((IEditorPart)SetupEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    SetupEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).SetupEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (SetupEditor.this.getSite().getPage().getActiveEditor() == SetupEditor.this) {
                                SetupEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                SetupEditorPlugin.INSTANCE.log(exception);
            }
        }
    };
    private AtomicReference<ResourceMirror> resourceMirror;
    private final ItemProvider loadingResourceInput = new ItemProvider(Collections.singleton(new ItemProvider(Messages.SetupEditor_loadingResourceInput_text)));
    private final ItemProvider loadingResourceSetInput = new ItemProvider(Collections.singleton(new ItemProvider(Messages.SetupEditor_loadingResourceSetInput_text)));
    private DelegatingDialogSettings dialogSettings = new DelegatingDialogSettings();
    private BaseEditUtil.IconReflectiveItemProvider reflectiveItemProvider;
    private Runnable reproxifier;
    protected SetupActionBarContributor.SetupWorkingSetsProvider workingSetsProvider = new SetupActionBarContributor.SetupWorkingSetsProvider();
    private AdapterFactoryContentProvider selectionViewerContentProvider;

    static {
        ArrayList<Object> images = new ArrayList<Object>(2);
        images.add(VARIABLE_GROUP_IMAGE);
        images.add(EMFEditUIPlugin.INSTANCE.getImage("full/ovr16/error_ovr.gif"));
        ErrorOverlayImage composedImage = new ErrorOverlayImage(images);
        UNDECLARED_VARIABLE_GROUP_IMAGE = ExtendedImageRegistry.INSTANCE.getImage((Object)composedImage);
    }

    public SetupEditor() {
        this.initializeEditingDomain();
    }

    public WorkingSetsActionBarContributor.PreviewDialog.WorkingSetsProvider getWorkingSetsProvider() {
        return this.workingSetsProvider;
    }

    protected void handleActivateGen() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleActivate() {
        if (!this.getContainer().isDisposed() && !this.isHandlingActivate && this.resourceMirror == null) {
            this.isHandlingActivate = true;
            try {
                ArrayList<Resource> changedResources;
                ArrayList<Resource> removedResources;
                ResourceSet resourceSet = this.editingDomain.getResourceSet();
                URIConverter uriConverter = resourceSet.getURIConverter();
                final LinkedHashSet<IFile> files = new LinkedHashSet<IFile>();
                for (Resource resource : resourceSet.getResources()) {
                    Map attributes;
                    Long timeStamp;
                    if (!resource.isLoaded()) continue;
                    URI uri = resource.getURI();
                    URI normalizedURI = uriConverter.normalize(uri);
                    if ((normalizedURI = SetupContext.resolve((URI)normalizedURI)).isPlatformResource()) {
                        files.add(EcorePlugin.getWorkspaceRoot().getFile((IPath)new Path(normalizedURI.toPlatformString(true))));
                        continue;
                    }
                    if (!normalizedURI.isFile() || resource.getContents().isEmpty() || (timeStamp = (Long)(attributes = uriConverter.getAttributes(normalizedURI, Collections.singletonMap("requestedAttributes", Collections.singleton("timeStamp")))).get("timeStamp")) == null || timeStamp.longValue() == resource.getTimeStamp()) continue;
                    this.changedResources.add(resource);
                }
                if (!files.isEmpty()) {
                    final AtomicBoolean needsRefresh = new AtomicBoolean();
                    IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            for (IFile file : files) {
                                if (file.isSynchronized(1)) continue;
                                needsRefresh.set(true);
                                file.refreshLocal(1, monitor);
                            }
                        }
                    };
                    try {
                        EcorePlugin.getWorkspaceRoot().getWorkspace().run(operation, null);
                    }
                    catch (OperationCanceledException uri) {
                    }
                    catch (Exception exception) {
                        SetupEditorPlugin.INSTANCE.log(exception);
                    }
                    if (needsRefresh.get()) {
                        return;
                    }
                }
                if (!this.removedResources.isEmpty() && !(removedResources = new ArrayList<Resource>(this.removedResources)).remove(resourceSet.getResources().get(0))) {
                    for (Resource resource : removedResources) {
                        this.removedResources.remove(resource);
                        resource.unload();
                    }
                }
                if (!this.changedResources.isEmpty() && !(changedResources = new ArrayList<Resource>(this.changedResources)).remove(resourceSet.getResources().get(0))) {
                    this.updateProblemIndication = false;
                    for (Resource resource : changedResources) {
                        this.changedResources.remove(resource);
                        if (!resource.isLoaded()) continue;
                        resource.unload();
                        try {
                            resource.load(Collections.EMPTY_MAP);
                        }
                        catch (IOException exception) {
                            if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                        }
                    }
                    if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                        this.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                    this.updateProblemIndication = true;
                    this.updateProblemIndication();
                    ReflectUtil.invokeMethod((String)"notifyListeners", (Object)this.editingDomain.getCommandStack());
                    this.selectionViewer.refresh();
                }
                Map resourceToReadOnlyMap = this.editingDomain.getResourceToReadOnlyMap();
                LinkedHashMap resourceToReadOnlyMapCopy = new LinkedHashMap(resourceToReadOnlyMap);
                this.handleActivateGen();
                EList resources = resourceSet.getResources();
                if (!resources.isEmpty()) {
                    resourceToReadOnlyMapCopy.remove(resources.get(0));
                }
                resourceToReadOnlyMap.putAll(resourceToReadOnlyMapCopy);
            }
            finally {
                this.isHandlingActivate = false;
            }
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)resourceSet.getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(resourceSet.getLoadOptions());
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndicationGen() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.oomph.setup.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    SetupEditorPlugin.INSTANCE.log(exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        SetupEditorPlugin.INSTANCE.log(exception);
                    }
                }
            }
        }
    }

    protected void updateProblemIndication() {
        Object input;
        if (!this.resourceToDiagnosticMap.isEmpty() && ((input = this.selectionViewer.getInput()) instanceof Resource || input == this.loadingResourceInput)) {
            SetupActionBarContributor.ToggleViewerInputAction toggleViewerInputAction = this.getActionBarContributor().getToggleViewerInputAction();
            toggleViewerInputAction.setActiveWorkbenchPart((IWorkbenchPart)this);
            toggleViewerInputAction.run();
            toggleViewerInputAction.setActiveWorkbenchPart((IWorkbenchPart)this);
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)SetupEditor.getString("_UI_FileConflict_label"), (String)SetupEditor.getString("_WARN_FileConflict"));
    }

    protected void initializeEditingDomainGen() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SetupItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new BaseItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                SetupEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SetupEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            SetupEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator<PropertySheetPage> i = (this).SetupEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = i.next();
                            if (propertySheetPage.getControl() == null || propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void initializeEditingDomain() {
        this.initializeEditingDomainGen();
        this.adapterFactory.insertAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory(){

            public Adapter createResourceAdapter() {
                final 7 resourceItemProviderAdapterFactory = this;
                return new ResourceItemProvider((AdapterFactory)resourceItemProviderAdapterFactory){
                    private List<DelegatingWrapperItemProvider> children;

                    protected boolean isWrappingNeeded(Object object) {
                        return true;
                    }

                    protected Command createCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
                        return UnexecutableCommand.INSTANCE;
                    }

                    public Collection<?> getChildren(Object object) {
                        Resource resource = (Resource)object;
                        ArrayList contents = new ArrayList(resource.getContents());
                        ResourceSet resourceSet = resource.getResourceSet();
                        if (resourceSet != null && resourceSet.getResources().get(0) != resource) {
                            if (this.children != null) {
                                for (DelegatingWrapperItemProvider child : this.children) {
                                    if (!((EObject)child.getValue()).eIsProxy()) continue;
                                    this.children = null;
                                    break;
                                }
                            }
                            if (this.children == null) {
                                this.children = new ArrayList<DelegatingWrapperItemProvider>();
                                int index = 0;
                                for (EObject child : contents) {
                                    this.children.add(new DelegatingWrapperItemProvider((Object)child, (Object)resource, null, index++, (AdapterFactory)resourceItemProviderAdapterFactory));
                                }
                            }
                            return this.children;
                        }
                        return contents;
                    }

                    public Object getImage(Object object) {
                        Resource resource = (Resource)object;
                        URI uri = resource.getURI();
                        ResourceSet resourceSet = resource.getResourceSet();
                        if (uri != null && resourceSet != null && MarketPlaceListing.getMarketPlaceListing((URI)uri, (URIConverter)resourceSet.getURIConverter()) != null) {
                            return SetupEditorPlugin.INSTANCE.getImage("marketplace16.png");
                        }
                        return super.getImage(object);
                    }

                    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
                        if (this.itemPropertyDescriptors == null) {
                            super.getPropertyDescriptors(object);
                            this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)resourceItemProviderAdapterFactory, Messages.SetupEditor_resolvedUriDescriptor_name, Messages.SetupEditor_resolvedUriDescriptor_description, null, false){

                                public Object getFeature(Object object) {
                                    return "resolvedURI";
                                }

                                public Object getPropertyValue(Object object) {
                                    Resource resource = (Resource)object;
                                    URI uri = resource.getURI();
                                    ResourceSet resourceSet = resource.getResourceSet();
                                    if (resourceSet != null) {
                                        uri = resourceSet.getURIConverter().normalize(uri);
                                    }
                                    if ((uri = SetupContext.resolve((URI)uri)).isPlatform()) {
                                        try {
                                            URL resolveURL = FileLocator.resolve((URL)new URL(uri.toString()));
                                            uri = URI.createURI((String)resolveURL.toString());
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    return uri;
                                }

                                public boolean isPropertySet(Object object) {
                                    return true;
                                }
                            });
                        }
                        return this.itemPropertyDescriptors;
                    }

                    public void dispose() {
                        super.dispose();
                        if (this.children != null) {
                            for (IDisposable iDisposable : this.children) {
                                iDisposable.dispose();
                            }
                        }
                    }
                };
            }

            public Adapter createResourceSetAdapter() {
                return new ResourceSetItemProvider((AdapterFactory)this){

                    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
                        ArrayList commandParameters = domain instanceof OomphEditingDomain ? new ArrayList(((OomphEditingDomain)domain).getCommandParameters()) : Collections.emptyList();
                        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
                        for (Object object : collection) {
                            if (object instanceof URI) {
                                URI uri = (URI)object;
                                MarketPlaceListing marketPlaceListing = MarketPlaceListing.getMarketPlaceListing((URI)uri, (URIConverter)domain.getResourceSet().getURIConverter());
                                uris.add(marketPlaceListing == null ? uri : marketPlaceListing.getListing());
                                continue;
                            }
                            return UnexecutableCommand.INSTANCE;
                        }
                        ResourceSet resourceSet = (ResourceSet)owner;
                        class LoadResourceCommand
                        extends AbstractOverrideableCommand
                        implements AbstractCommand.NonDirtying,
                        DragAndDropFeedback {
                            protected List<Resource> resources;
                            private final /* synthetic */ Set val$uris;
                            private final /* synthetic */ ResourceSet val$resourceSet;
                            private final /* synthetic */ List val$commandParameters;

                            protected LoadResourceCommand(EditingDomain domain, Set set, ResourceSet resourceSet, List list) {
                                this.val$uris = set;
                                this.val$resourceSet = resourceSet;
                                this.val$commandParameters = list;
                                super(domain);
                            }

                            protected boolean prepare() {
                                return !this.val$uris.isEmpty();
                            }

                            public void doExecute() {
                                this.resources = new ArrayList<Resource>();
                                int index = 1;
                                Macro macro = null;
                                for (URI uri : this.val$uris) {
                                    Resource resource = this.val$resourceSet.getResource(uri, false);
                                    if (resource == null) {
                                        try {
                                            resource = this.val$resourceSet.getResource(uri, true);
                                        }
                                        catch (RuntimeException exception) {
                                            resource = this.val$resourceSet.getResource(uri, false);
                                        }
                                    }
                                    if (resource == null) continue;
                                    macro = (Macro)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.MACRO);
                                    EList resourceSetResources = this.val$resourceSet.getResources();
                                    if (resourceSetResources.indexOf((Object)resource) != 0) {
                                        resourceSetResources.move(index++, (Object)resource);
                                    }
                                    this.resources.add(resource);
                                }
                                if (macro != null && !this.val$commandParameters.isEmpty()) {
                                    CommandParameter commandParameter = (CommandParameter)this.val$commandParameters.get(this.val$commandParameters.size() - 1);
                                    final Object feature = commandParameter.getFeature();
                                    final Object rootOwner = commandParameter.getOwner();
                                    final Macro finalMacro = macro;
                                    UIUtil.asyncExec((Control)SetupEditor.this.getContainer(), (Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            float location = 0.5f;
                                            int operations = 7;
                                            int operation = 4;
                                            if (feature instanceof DragAndDropCommand.Detail) {
                                                DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)feature;
                                                location = detail.location;
                                                operations = detail.operations;
                                                operation = detail.operation;
                                            }
                                            Command dragAndDropCommand = DragAndDropCommand.create((EditingDomain)domain, (Object)rootOwner, (float)location, (int)operations, (int)operation, Collections.singleton(finalMacro));
                                            domain.getCommandStack().execute(dragAndDropCommand);
                                        }
                                    });
                                }
                            }

                            public void doUndo() {
                                this.val$resourceSet.getResources().removeAll(this.resources);
                                this.resources = null;
                            }

                            public void doRedo() {
                                this.doExecute();
                            }

                            public Collection<?> doGetAffectedObjects() {
                                return this.resources == null ? Collections.singleton(this.val$resourceSet) : this.resources;
                            }

                            public String doGetDescription() {
                                return EMFEditPlugin.INSTANCE.getString("_UI_LoadResources_description");
                            }

                            public String doGetLabel() {
                                return EMFEditPlugin.INSTANCE.getString("_UI_LoadResources_label");
                            }

                            public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
                                return true;
                            }

                            public int getFeedback() {
                                return 1;
                            }

                            public int getOperation() {
                                return 1;
                            }
                        }
                        return new LoadResourceCommand(domain, uris, resourceSet, commandParameters);
                    }
                };
            }
        });
        this.reflectiveItemProvider = BaseEditUtil.replaceReflectiveItemProvider((ComposedAdapterFactory)this.adapterFactory);
        PreferenceTaskItemProvider.setShortenLabelText((AdapterFactory)this.adapterFactory);
        LinkedHashMap<Resource, Boolean> readOnlyMap = new LinkedHashMap<Resource, Boolean>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Boolean get(Object key) {
                EList resources;
                Boolean result = (Boolean)super.get(key);
                if (result == null && (resources = SetupEditor.this.editingDomain.getResourceSet().getResources()).indexOf(key) != 0) {
                    return Boolean.TRUE;
                }
                return result;
            }
        };
        this.editingDomain = new OomphEditingDomain((AdapterFactory)this.adapterFactory, this.editingDomain.getCommandStack(), readOnlyMap, SetupTransferSupport.USER_RESOLVING_DELEGATES){

            public void handledAdditions(final Collection<?> collection) {
                UIUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (Object object : collection) {
                            if (!(object instanceof MacroTask)) continue;
                            MacroTask macroTask = (MacroTask)object;
                            ConfigureMarketPlaceListingAction.configure((Shell)SetupEditor.this.getSite().getShell(), (EditingDomain)(this).SetupEditor.this.editingDomain, (MacroTask)macroTask);
                        }
                    }
                });
            }
        };
        this.editingDomain.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                if (SetupEditor.this.contentOutlinePage != null) {
                    SetupEditor.this.contentOutlinePage.update(2);
                }
            }
        });
    }

    public BaseEditUtil.IconReflectiveItemProvider getReflectiveItemProvider() {
        return this.reflectiveItemProvider;
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewerGen(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (SetupEditor.this.currentViewer != null) {
                        SetupEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public void setSelectionToViewer(Collection<?> collection) {
        if (this.selectionViewer != null && !this.selectionViewer.getTree().isDisposed()) {
            if (this.currentViewer == this.selectionViewer) {
                ArrayList effectiveCollection = new ArrayList();
                boolean selectResource = false;
                for (Object object : collection) {
                    if (object instanceof Resource) {
                        selectResource = true;
                        Object[] children = this.selectionViewerContentProvider.getChildren(object);
                        if (children.length == 0) {
                            effectiveCollection.add(object);
                            continue;
                        }
                        effectiveCollection.add(children[0]);
                        continue;
                    }
                    effectiveCollection.add(object);
                }
                if (selectResource) {
                    this.toggleInput(true);
                }
                collection = effectiveCollection;
            }
            this.setSelectionToViewerGen(collection);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        SetupEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp"){

            protected boolean allowItem(IContributionItem itemToAdd) {
                String id = itemToAdd.getId();
                if (itemToAdd instanceof PluginActionContributionItem) {
                    return id != null && !id.contains("debug.ui") && !"ValidationAction".equals(id) && !id.contains("mylyn");
                }
                if (itemToAdd instanceof MenuManager && id != null && ("team.main".equals(id) || "replaceWithMenu".equals(id) || "compareWithMenu".equals(id))) {
                    itemToAdd.setVisible(false);
                }
                return true;
            }
        };
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        ((OomphEditingDomain)this.editingDomain).registerDragAndDrop(viewer);
    }

    public void createModel() {
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        URIConverter uriConverter = resourceSet.getURIConverter();
        Map uriMap = uriConverter.getURIMap();
        LinkedHashMap<URI, URI> workspaceMappings = new LinkedHashMap<URI, URI>();
        block2: for (URI uri : uriMap.values()) {
            if (!uri.isFile() || uri.isRelative()) continue;
            try {
                URI redirectedWorkspaceURI;
                int n;
                int n2;
                IContainer[] iContainerArray;
                java.net.URI locationURI = new java.net.URI(uri.toString());
                if (uri.hasTrailingPathSeparator()) {
                    iContainerArray = EcorePlugin.getWorkspaceRoot().findContainersForLocationURI(locationURI);
                    n2 = iContainerArray.length;
                    n = 0;
                    while (n < n2) {
                        IContainer container = iContainerArray[n];
                        if (container.isAccessible()) {
                            redirectedWorkspaceURI = URI.createPlatformResourceURI((String)container.getFullPath().toString(), (boolean)true).appendSegment("");
                            workspaceMappings.put(uri, redirectedWorkspaceURI);
                            continue block2;
                        }
                        ++n;
                    }
                    continue;
                }
                iContainerArray = EcorePlugin.getWorkspaceRoot().findFilesForLocationURI(locationURI);
                n2 = iContainerArray.length;
                n = 0;
                while (n < n2) {
                    IContainer file = iContainerArray[n];
                    if (file.isAccessible()) {
                        redirectedWorkspaceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                        workspaceMappings.put(uri, redirectedWorkspaceURI);
                        continue block2;
                    }
                    ++n;
                }
            }
            catch (URISyntaxException locationURI) {
                // empty catch block
            }
        }
        uriMap.putAll(workspaceMappings);
        URI resourceURI = SetupEditorSupport.getURI((IEditorInput)this.getEditorInput(), (URIConverter)resourceSet.getURIConverter());
        this.resourceMirror.get().perform((Object)resourceURI);
        Resource mainResource = resourceSet.getResource(resourceURI, false);
        EList contents = mainResource.getContents();
        EObject rootObject = null;
        if (!contents.isEmpty()) {
            rootObject = (EObject)contents.get(0);
            if (rootObject instanceof Index) {
                Index index = (Index)rootObject;
                this.reproxifier = new Runnable(index){
                    final InternalEList<EPackage> discoverablePackages;
                    final Map<EPackage, EPackage> packageProxies;
                    {
                        this.discoverablePackages = (InternalEList)index.getDiscoverablePackages();
                        this.packageProxies = new LinkedHashMap<EPackage, EPackage>();
                        int i = 0;
                        int size = this.discoverablePackages.size();
                        while (i < size) {
                            EPackage ePackageProxy = (EPackage)this.discoverablePackages.basicGet(i);
                            EPackage ePackage = (EPackage)this.discoverablePackages.get(i);
                            this.packageProxies.put(ePackage, ePackageProxy);
                            ++i;
                        }
                    }

                    @Override
                    public void run() {
                        int i = 0;
                        int size = this.discoverablePackages.size();
                        while (i < size) {
                            EPackage ePackage = (EPackage)this.discoverablePackages.basicGet(i);
                            EPackage ePackageProxy = this.packageProxies.get(ePackage);
                            if (ePackageProxy != null) {
                                this.discoverablePackages.set(i, (Object)ePackageProxy);
                            }
                            ++i;
                        }
                    }
                };
            } else {
                if (rootObject instanceof Configuration) {
                    Configuration configuration = (Configuration)rootObject;
                    final Installation installation = configuration.getInstallation();
                    final Workspace workspace = configuration.getWorkspace();
                    this.reproxifier = new Runnable(){
                        final Map<Object, Object> proxies = new LinkedHashMap<Object, Object>();
                        private final Adapter proxyListener = new AdapterImpl(){

                            public void notifyChanged(Notification notification) {
                                Object feature;
                                if (notification.getEventType() == 9 && ((feature = notification.getFeature()) == SetupPackage.Literals.INSTALLATION__PRODUCT_VERSION || feature == SetupPackage.Literals.WORKSPACE__STREAMS)) {
                                    proxies.put(notification.getNewValue(), notification.getOldValue());
                                }
                            }
                        };
                        {
                            if (installation2 != null) {
                                installation2.eAdapters().add((Object)this.proxyListener);
                            }
                            if (workspace2 != null) {
                                workspace2.eAdapters().add((Object)this.proxyListener);
                            }
                        }

                        @Override
                        public void run() {
                            ProductVersion productVersionProxy;
                            EObject productVersion;
                            if (installation != null && (productVersion = (EObject)installation.eGet((EStructuralFeature)SetupPackage.Literals.INSTALLATION__PRODUCT_VERSION, false)) != null && (productVersionProxy = (ProductVersion)this.proxies.get(productVersion)) != null) {
                                installation.setProductVersion(productVersionProxy);
                            }
                            if (workspace != null) {
                                InternalEList streams = (InternalEList)workspace.getStreams();
                                int i = 0;
                                int size = streams.size();
                                while (i < size) {
                                    Stream stream = (Stream)streams.basicGet(i);
                                    Stream streamProxy = (Stream)this.proxies.get(stream);
                                    if (streamProxy != null) {
                                        streams.set(i, (Object)streamProxy);
                                    }
                                    ++i;
                                }
                            }
                        }
                    };
                }
                this.resourceMirror.get().perform((Object)SetupContext.INDEX_SETUP_URI);
            }
        }
        for (Resource resource : resourceSet.getResources()) {
            Diagnostic diagnostic = this.analyzeResourceProblems(resource, null);
            if (diagnostic.getSeverity() == 0) continue;
            this.resourceToDiagnosticMap.put(resource, diagnostic);
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        boolean hasErrors;
        boolean bl = hasErrors = !resource.getErrors().isEmpty();
        if (hasErrors || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(hasErrors ? 4 : 2, "org.eclipse.oomph.setup.editor", 0, SetupEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.oomph.setup.editor", 0, SetupEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    private void configure(ColumnViewer viewer, final Set<Resource> primaryResources, final Set<EObject> syntheticEObjects) {
        final SetupLocationListener locationListener = new SetupLocationListener(true);
        locationListener.setEditor(this);
        final ColumnViewerInformationControlToolTipSupport toolTipSupport = new ColumnViewerInformationControlToolTipSupport(viewer, (LocationListener)locationListener);
        AbstractHoverInformationControlManager hoverInformationControlManager = (AbstractHoverInformationControlManager)ReflectUtil.getValue((String)"hoverInformationControlManager", (Object)toolTipSupport);
        InformationControlReplacer informationControlReplacer = hoverInformationControlManager.getInternalAccessor().getInformationControlReplacer();
        AbstractInformationControlManager.IInformationControlCloser informationControlReplacerCloser = (AbstractInformationControlManager.IInformationControlCloser)ReflectUtil.getValue((String)"fInformationControlCloser", (Object)informationControlReplacer);
        class Closer
        implements AbstractInformationControlManager.IInformationControlCloser,
        Listener {
            private AbstractInformationControlManager.IInformationControlCloser informationControlCloser;
            private Shell shell;
            private final /* synthetic */ InformationControlReplacer val$informationControlReplacer;

            public Closer(AbstractInformationControlManager.IInformationControlCloser informationControlCloser, InformationControlReplacer informationControlReplacer) {
                this.val$informationControlReplacer = informationControlReplacer;
                this.informationControlCloser = informationControlCloser;
            }

            public void setSubjectControl(Control subject) {
                this.informationControlCloser.setSubjectControl(subject);
            }

            public void setInformationControl(IInformationControl control) {
                if (this.shell != null) {
                    this.shell.getDisplay().removeFilter(6, (Listener)this);
                    this.shell.getDisplay().removeFilter(5, (Listener)this);
                    this.shell.getDisplay().removeFilter(7, (Listener)this);
                }
                this.shell = control == null ? null : (Shell)ReflectUtil.getValue((String)"fShell", (Object)control);
                this.informationControlCloser.setInformationControl(control);
            }

            public void start(Rectangle subjectArea) {
                this.informationControlCloser.start(subjectArea);
                this.shell.getDisplay().addFilter(6, (Listener)this);
                this.shell.getDisplay().addFilter(5, (Listener)this);
                this.shell.getDisplay().addFilter(7, (Listener)this);
            }

            public void stop() {
                this.informationControlCloser.stop();
                if (this.shell != null) {
                    this.shell.getDisplay().removeFilter(6, (Listener)this);
                    this.shell.getDisplay().removeFilter(5, (Listener)this);
                    this.shell.getDisplay().removeFilter(7, (Listener)this);
                }
            }

            public void handleEvent(Event event) {
                if (event.widget instanceof Control && this.shell.getDisplay().getActiveShell() != this.shell) {
                    Control control = (Control)event.widget;
                    Point location = control.toDisplay(event.x, event.y);
                    Rectangle bounds = this.shell.getBounds();
                    Rectangle trim = this.shell.computeTrim(bounds.x, bounds.y, bounds.width, bounds.height);
                    if (!trim.contains(location)) {
                        ReflectUtil.invokeMethod((String)"hideInformationControl", (Object)this.val$informationControlReplacer);
                    }
                }
            }
        }
        ReflectUtil.setValue((String)"fInformationControlCloser", (Object)informationControlReplacer, (Object)new Closer(informationControlReplacerCloser, informationControlReplacer));
        locationListener.setToolTipSupport(toolTipSupport);
        final SetupLabelProvider setupLabelProvider = new SetupLabelProvider((AdapterFactory)this.adapterFactory, (Viewer)viewer);
        DiagnosticDecorator diagnosticDecorator = new DiagnosticDecorator((EditingDomain)this.editingDomain, (StructuredViewer)viewer, this.dialogSettings){
            final AdapterFactoryItemDelegator itemDelegator;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)SetupEditor.this.adapterFactory){

                    public String getText(Object object) {
                        if (object instanceof EClass) {
                            return ((EClass)object).getName();
                        }
                        return super.getText(object);
                    }
                };
            }

            protected void decorate(Map<Object, BasicDiagnostic> objects) {
                if (primaryResources == null) {
                    super.decorate(objects);
                }
            }

            protected BasicDiagnostic decorate(Map<Object, BasicDiagnostic> decorations, Object object, Diagnostic diagnostic, List<Integer> path) {
                BasicDiagnostic oldDiagnostic;
                if (diagnostic != null && (oldDiagnostic = decorations.get(object)) != null) {
                    for (Diagnostic oldChildDiagnostic : oldDiagnostic.getChildren()) {
                        if (!this.equals(diagnostic, oldChildDiagnostic)) continue;
                        return oldDiagnostic;
                    }
                }
                return super.decorate(decorations, object, diagnostic, path);
            }

            protected boolean equals(Diagnostic diagnostic1, Diagnostic diagnostic2) {
                if (diagnostic1.getCode() != diagnostic2.getCode() || diagnostic1.getSource() != diagnostic2.getSource() || diagnostic1.getSeverity() != diagnostic2.getSeverity() || !ObjectUtil.equals((Object)diagnostic1.getMessage(), (Object)diagnostic2.getMessage())) {
                    return false;
                }
                if (!diagnostic1.getData().equals(diagnostic2.getData())) {
                    return false;
                }
                List children1 = diagnostic1.getChildren();
                List children2 = diagnostic1.getChildren();
                if (children1.size() != children2.size()) {
                    return false;
                }
                int i = 0;
                int size = children1.size();
                while (i < size) {
                    Diagnostic child2;
                    Diagnostic child1 = (Diagnostic)children1.get(i);
                    if (!this.equals(child1, child2 = (Diagnostic)children2.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            protected void buildToolTipText(StringBuilder result, ILabelProvider labelProvider, Diagnostic diagnostic, Object object) {
                int index = result.length();
                super.buildToolTipText(result, labelProvider, diagnostic, object);
                if (result.indexOf("<h1>" + Messages.SetupEditor_closer_tooltip_problemsOnChildren + "</h1>\n") != index) {
                    result.insert(index, "<h1>" + Messages.SetupEditor_closer_tooltip_problems + "</h1>\n");
                }
            }

            public String getToolTipText(Object object) {
                String propertyTable;
                SetupLocationListener effectiveLocationListener;
                boolean extend = false;
                boolean showAdvancedProperties = false;
                if (object instanceof ToolTipObject) {
                    ToolTipObject wrapper = (ToolTipObject)object;
                    object = wrapper.getWrappedObject();
                    effectiveLocationListener = wrapper.getLocationListener();
                    wrapper.getLocationListener().setToolTipObject(object, wrapper.getSetupEditor(), toolTipSupport);
                    extend = wrapper.isExtended();
                    showAdvancedProperties = wrapper.isShowAdvancedProperties();
                } else {
                    if (!SetupActionBarContributor.isShowTooltips() || SetupEditor.this.getActionBarContributor().isInformationBrowserShowing()) {
                        return null;
                    }
                    effectiveLocationListener = locationListener;
                }
                Image image = setupLabelProvider.getImage(object);
                if (image == null) {
                    return null;
                }
                effectiveLocationListener.setToolTipObject(object, SetupEditor.this, toolTipSupport);
                StringBuilder result = new StringBuilder();
                result.append("<div style='word-break: break-all;'>");
                URI imageURI = ImageURIRegistry.INSTANCE.getImageURI(image);
                String labelText = setupLabelProvider.getText(object);
                if (!extend) {
                    result.append("<a href='about:blank?extend' style='text-decoration: none; color: inherit;'>");
                    result.append("<img style='padding-right: 2pt; margin-top: 2px; margin-bottom: -2pt;' src='");
                    result.append(imageURI);
                    result.append("'/><b>");
                    result.append(DiagnosticDecorator.escapeContent((String)labelText));
                    result.append("</b></a>");
                } else {
                    BasicEList path = new BasicEList();
                    Object parent = this.itemDelegator.getParent(object);
                    while (parent != null) {
                        if (parent instanceof ResourceSet) break;
                        path.add(0, parent);
                        parent = this.itemDelegator.getParent(parent);
                    }
                    int indent = 0;
                    for (Object element : path) {
                        result.append("<div style='margin-left: ").append(indent).append("px;'>");
                        ToolTipLabelProvider.renderHTMLPropertyValue((StringBuilder)result, (IItemLabelProvider)this.itemDelegator, element, (boolean)true);
                        result.append("</div>");
                        indent += 10;
                    }
                    result.append("<div style='margin-left: ").append(indent).append("px;'>");
                    result.append("<a href='about:blank?no-extend' style='text-decoration: none; color: inherit;'>");
                    result.append("<img style='padding-right: 2pt; margin-top: 2px; margin-bottom: -2pt;' src='");
                    result.append(imageURI);
                    result.append("'/><b>");
                    result.append(DiagnosticDecorator.escapeContent((String)labelText));
                    result.append("</b></a>");
                    result.append("</div>");
                    indent += 10;
                    for (Object child : this.itemDelegator.getChildren(object)) {
                        result.append("<div style='margin-left: ").append(indent).append("px;'>");
                        ToolTipLabelProvider.renderHTMLPropertyValue((StringBuilder)result, (IItemLabelProvider)this.itemDelegator, child, (boolean)true);
                        result.append("</div>");
                    }
                }
                result.append("</div>\n");
                ArrayList propertyDescriptors = new ArrayList();
                List underlyingPropertyDescriptors = this.itemDelegator.getPropertyDescriptors(object);
                if (underlyingPropertyDescriptors != null) {
                    propertyDescriptors.addAll(underlyingPropertyDescriptors);
                }
                Iterator it = propertyDescriptors.iterator();
                while (it.hasNext()) {
                    String valueLabel;
                    IItemPropertyDescriptor itemPropertyDescriptor = (IItemPropertyDescriptor)it.next();
                    String[] filterFlags = itemPropertyDescriptor.getFilterFlags(object);
                    if (!showAdvancedProperties && filterFlags != null && filterFlags.length > 0 && "org.eclipse.ui.views.properties.expert".equals(filterFlags[0])) {
                        it.remove();
                        continue;
                    }
                    Object feature = itemPropertyDescriptor.getFeature(object);
                    Object propertyValue = this.itemDelegator.getEditableValue(itemPropertyDescriptor.getPropertyValue(object));
                    if (feature instanceof EStructuralFeature) {
                        EStructuralFeature eStructuralFeature = (EStructuralFeature)feature;
                        if ("description".equals(eStructuralFeature.getName()) && propertyValue instanceof String) {
                            String description = propertyValue.toString();
                            if (description != null) {
                                result.append("<h1>" + Messages.SetupEditor_closer_tooltip_description + "</h1>");
                                result.append(description);
                                it.remove();
                                continue;
                            }
                        } else if (feature == SetupPackage.Literals.SETUP_TASK__DISABLED) {
                            it.remove();
                            continue;
                        }
                    }
                    if (!StringUtil.isEmpty((String)(valueLabel = itemPropertyDescriptor.getLabelProvider(object).getText(propertyValue)))) continue;
                    it.remove();
                }
                String diagnosticText = super.getToolTipText(object);
                if (diagnosticText != null) {
                    Matcher matcher = IMAGE_PATTERN.matcher(diagnosticText);
                    StringBuffer improvedDiagnosticText = new StringBuffer();
                    while (matcher.find()) {
                        matcher.appendReplacement(improvedDiagnosticText, "$1style='margin-bottom: -2pt;' $2");
                    }
                    matcher.appendTail(improvedDiagnosticText);
                    result.append("\n").append(improvedDiagnosticText);
                }
                if ((propertyTable = ToolTipLabelProvider.renderHTML(propertyDescriptors, (Object)object, (boolean)true)) != null) {
                    result.append("\n<h1>" + Messages.SetupEditor_closer_tooltip_properties + "</h1>\n");
                    result.append('\n').append(propertyTable);
                }
                StringBuffer improvedResult = new StringBuffer();
                Matcher matcher = HEADER_PATTERN.matcher(result);
                while (matcher.find()) {
                    matcher.appendReplacement(improvedResult, "$1 style='padding-bottom: 2pt; padding-top: 4pt;'$2");
                }
                matcher.appendTail(improvedResult);
                String finalText = improvedResult.toString();
                try {
                    AbstractHoverInformationControlManager hoverInformationControlManager = (AbstractHoverInformationControlManager)ReflectUtil.getValue((String)"hoverInformationControlManager", (Object)toolTipSupport);
                    Point size = UIUtil.caclcuateSize((String)finalText);
                    hoverInformationControlManager.setSizeConstraints(size.x, size.y + (propertyDescriptors.size() + 1) / 3 + 1, true, false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (UIUtil.isBrowserAvailable()) {
                    return finalText;
                }
                return UIUtil.getRenderableHTML((String)finalText);
            }

            protected void buildToolTipMessage(StringBuilder result, ILabelProvider labelProvider, Object object, Diagnostic diagnostic, int indentation) {
                StringBuilder builder = new StringBuilder();
                super.buildToolTipMessage(builder, labelProvider, object, diagnostic, indentation);
                StringBuffer improvedResult = new StringBuffer();
                Matcher matcher = IMAGE_PATTERN.matcher(builder);
                if (matcher.find()) {
                    matcher.appendReplacement(improvedResult, "$1style='padding-bottom: 1px;' $2");
                }
                matcher.appendTail(improvedResult);
                result.append(improvedResult);
            }
        };
        final Color syntheticColor = ExtendedColorRegistry.INSTANCE.getColor(null, null, (Object)URI.createURI((String)"color://rgb/85/113/138"));
        final Font font = viewer.getControl().getFont();
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)setupLabelProvider, (ILabelDecorator)diagnosticDecorator){

            public String getText(Object element) {
                SetupTask setupTask;
                EList restrictions;
                String text = super.getText(element);
                if (element instanceof SetupTask && !(restrictions = (setupTask = (SetupTask)element).getRestrictions()).isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    for (Scope restriction : restrictions) {
                        String label;
                        if (builder.length() != 0) {
                            builder.append(", ");
                        }
                        if (StringUtil.isEmpty((String)(label = restriction.getLabel()))) {
                            label = restriction.getName();
                        }
                        builder.append(label);
                    }
                    String string = builder.toString();
                    string = text.contains(string) ? "" : ": " + string;
                    text = String.valueOf(text) + "  [" + Messages.SetupEditor_viewer_restricted + string + "]";
                }
                return text;
            }

            public Color getForeground(Object element) {
                Color foreground = super.getForeground(element);
                if (foreground == null && syntheticEObjects != null && syntheticEObjects.contains(element)) {
                    foreground = syntheticColor;
                }
                return foreground;
            }

            public Font getFont(Object object) {
                Font result = super.getFont(object);
                Object unwrappedObject = AdapterFactoryEditingDomain.unwrap((Object)object);
                if (primaryResources != null && unwrappedObject instanceof EObject && !primaryResources.contains(((EObject)unwrappedObject).eResource())) {
                    result = ExtendedFontRegistry.INSTANCE.getFont(result != null ? result : font, (Object)IItemFontProvider.ITALIC_FONT);
                }
                return result;
            }
        });
        final Control control = viewer.getControl();
        control.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                try {
                    IViewPart propertiesView = SetupEditor.this.getSite().getPage().showView("org.eclipse.ui.views.PropertySheet", null, 2);
                    if (propertiesView instanceof PropertySheet) {
                        PropertySheet propertySheet = (PropertySheet)propertiesView;
                        propertySheet.selectionChanged((IWorkbenchPart)SetupEditor.this, (ISelection)new StructuredSelection());
                        propertySheet.selectionChanged((IWorkbenchPart)SetupEditor.this, SetupEditor.this.getSelection());
                    }
                }
                catch (PartInitException ex) {
                    SetupEditorPlugin.INSTANCE.log(ex);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if ((e.stateMask & SWT.MOD3) != 0) {
                    boolean showTooltips = SetupActionBarContributor.isShowTooltips();
                    SetupActionBarContributor.setShowTooltips(true);
                    Event exitEvent = new Event();
                    exitEvent.display = e.display;
                    exitEvent.x = -1;
                    exitEvent.y = -1;
                    control.notifyListeners(7, exitEvent);
                    ReflectUtil.setValue((String)"currentCell", (Object)toolTipSupport, null);
                    Event event = new Event();
                    event.display = e.display;
                    event.x = e.x;
                    event.y = e.y;
                    control.notifyListeners(32, event);
                    SetupActionBarContributor.setShowTooltips(showTooltips);
                }
            }
        });
        this.createContextMenuFor((StructuredViewer)viewer);
    }

    public void createPages() {
        Tree tree = new Tree(this.getContainer(), 2);
        this.selectionViewer = new TreeViewer(tree);
        this.setCurrentViewer((Viewer)this.selectionViewer);
        this.configure((ColumnViewer)this.selectionViewer, null, null);
        this.selectionViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object getParent(Object object) {
                Resource.Internal resource;
                if (object instanceof InternalEObject && (resource = ((InternalEObject)object).eDirectResource()) != null) {
                    return resource;
                }
                return super.getParent(object);
            }
        };
        this.selectionViewer.setContentProvider((IContentProvider)this.selectionViewerContentProvider);
        this.selectionViewer.setInput((Object)this.loadingResourceInput);
        new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
        int pageIndex = this.addPage((Control)tree);
        this.setPageText(pageIndex, SetupEditor.getString("_UI_SelectionPage_label"));
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SetupEditor.this.getPageCount() > 0) {
                    SetupEditor.this.setActivePage(0);
                }
            }
        });
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    SetupEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.doLoad();
    }

    protected void doLoad() {
        this.resourceMirror = new AtomicReference();
        final Tree tree = this.selectionViewer.getTree();
        Job job = new Job(Messages.SetupEditor_loadingModelJob_name){

            public boolean belongsTo(Object family) {
                return family == SetupEditorSupport.FAMILY_MODEL_LOAD;
            }

            protected IStatus run(IProgressMonitor monitor) {
                final ResourceSet resourceSet = SetupEditor.this.editingDomain.getResourceSet();
                SetupCoreUtil.configureResourceSet((ResourceSet)resourceSet);
                final ResourceMirror resourceMirror = new ResourceMirror(resourceSet){

                    protected void run(String taskName, IProgressMonitor monitor) {
                        (this).SetupEditor.this.resourceMirror.set(this);
                        SetupEditor.this.createModel();
                        this.resolveProxies();
                        (this).SetupEditor.this.dialogSettings.setLiveValidation(true);
                        (this).SetupEditor.this.resourceMirror = null;
                    }
                };
                resourceMirror.begin(monitor);
                UIUtil.asyncExec((Control)tree, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            boolean canceled;
                            tree.setRedraw(false);
                            Resource resource = (Resource)resourceSet.getResources().get(0);
                            EList contents = resource.getContents();
                            EObject rootObject = contents.isEmpty() ? null : (EObject)contents.get(0);
                            (this).SetupEditor.this.selectionViewer.setInput((this).SetupEditor.this.selectionViewer.getInput() == (this).SetupEditor.this.loadingResourceInput ? resource : resourceSet);
                            if (rootObject != null) {
                                (this).SetupEditor.this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)rootObject), true);
                            }
                            if (!(canceled = resourceMirror.isCanceled())) {
                                if (rootObject instanceof Project) {
                                    EList streams = ((Project)rootObject).getStreams();
                                    if (streams.isEmpty()) {
                                        (this).SetupEditor.this.selectionViewer.expandToLevel((Object)rootObject, 1);
                                    } else {
                                        for (Stream branch : streams) {
                                            (this).SetupEditor.this.selectionViewer.expandToLevel((Object)branch, 1);
                                        }
                                    }
                                } else if (rootObject != null) {
                                    (this).SetupEditor.this.selectionViewer.expandToLevel((Object)rootObject, 1);
                                }
                                if ((this).SetupEditor.this.contentOutlinePage != null) {
                                    (this).SetupEditor.this.contentOutlinePage.update(2);
                                }
                                SetupEditor.this.getActionBarContributor().scheduleValidation();
                            }
                            SetupEditor.this.updateProblemIndication();
                        }
                        finally {
                            if (!tree.isDisposed()) {
                                tree.setRedraw(true);
                            }
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        IProgressService progressService = this.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        progressService.showInDialog(null, job);
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                Point point = this.getContainer().getSize();
                Rectangle clientArea = this.getContainer().getClientArea();
                this.getContainer().setSize(point.x, 2 * point.y - clientArea.height - clientArea.y);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, SetupEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                Point point = this.getContainer().getSize();
                Rectangle clientArea = this.getContainer().getClientArea();
                this.getContainer().setSize(point.x, clientArea.height + clientArea.y);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public <T> T getAdapterGen(Class<T> key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? (T)key.cast(this.getContentOutlinePage()) : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return key.cast(this.getPropertySheetPage());
        }
        if (key.equals(IGotoMarker.class)) {
            return key.cast((Object)this);
        }
        return (T)super.getAdapter(key);
    }

    public Object getAdapter(Class adapter) {
        Object result = FindAndReplaceTarget.getAdapter((Class)adapter, (IWorkbenchPart)this);
        if (result != null) {
            return result;
        }
        return this.getAdapterGen(adapter);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new OutlinePreviewPage();
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SetupEditor.this.contentOutlinePage != null && SetupEditor.this.resourceMirror == null) {
                        SetupEditor.this.contentOutlinePage.update(2);
                    }
                }
            });
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SetupEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        OomphPropertySheetPage propertySheetPage = new OomphPropertySheetPage(this.editingDomain, ExtendedPropertySheetPage.Decoration.LIVE, this.dialogSettings){

            public void setSelectionToViewer(List<?> selection) {
                SetupEditor.this.setSelectionToViewer(selection);
                SetupEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                SetupEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.contentOutlinePage != null && this.contentOutlineViewer.getControl().isFocusControl() && this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList<Object> selectionList = new ArrayList<Object>();
            selectionList.addAll(this.contentOutlinePage.getOriginals(selectedElement));
            while (selectedElements.hasNext()) {
                selectionList.addAll(this.contentOutlinePage.getOriginals(selectedElements.next()));
            }
            if (!selectionList.isEmpty()) {
                TreeViewer oldSectionViewer = this.selectionViewer;
                IStructuredSelection structuredSelection = this.createSelection(selectionList);
                this.selectionViewer = null;
                oldSectionViewer.setSelection((ISelection)structuredSelection, true);
                this.selectionViewer = oldSectionViewer;
            }
        }
    }

    protected IStructuredSelection createSelection(List<Object> objects) {
        Object input = this.selectionViewer.getInput();
        if (input instanceof Resource) {
            return new StructuredSelection(objects);
        }
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        ITreeContentProvider treeContentProvider = (ITreeContentProvider)this.selectionViewer.getContentProvider();
        for (Object object : objects) {
            ArrayList<Object> path = new ArrayList<Object>();
            this.computePath(path, treeContentProvider, object);
            treePaths.add(new TreePath(path.toArray()));
        }
        return new TreeSelection(treePaths.toArray(new TreePath[treePaths.size()]));
    }

    protected Object computePath(List<Object> path, ITreeContentProvider treeContentProvider, Object object) {
        if (object instanceof Resource) {
            path.add(object);
            return object;
        }
        Object parent = treeContentProvider.getParent(object);
        if (parent == null) {
            path.add(object);
            return object;
        }
        Object actualParent = this.computePath(path, treeContentProvider, parent);
        if (actualParent != null) {
            Object[] children;
            Object[] objectArray = children = treeContentProvider.getChildren(actualParent);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child == object || child instanceof IWrapperItemProvider && ((IWrapperItemProvider)child).getValue() == object) {
                    path.add(child);
                    return child;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doRevert() {
        Object input = this.selectionViewer.getInput();
        this.selectionViewer.setInput((Object)(input instanceof Resource ? this.loadingResourceInput : this.loadingResourceSetInput));
        this.dialogSettings.setLiveValidation(false);
        EList resources = this.editingDomain.getResourceSet().getResources();
        for (Resource resource : resources) {
            resource.unload();
        }
        resources.clear();
        this.resourceToDiagnosticMap.clear();
        this.editingDomain.getCommandStack().flush();
        this.doLoad();
    }

    public void doSaveGen(IProgressMonitor progressMonitor) {
        final LinkedHashMap<String, String> saveOptions = new LinkedHashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                EList resources = SetupEditor.this.editingDomain.getResourceSet().getResources();
                int i = 0;
                while (i < resources.size()) {
                    Resource resource = (Resource)resources.get(i);
                    if ((first || !resource.getContents().isEmpty() || SetupEditor.this.isPersisted(resource)) && !SetupEditor.this.editingDomain.isReadOnly(resource)) {
                        try {
                            long timeStamp = resource.getTimeStamp();
                            resource.save(saveOptions);
                            if (resource.getTimeStamp() != timeStamp) {
                                SetupEditor.this.savedResources.add(resource);
                            }
                        }
                        catch (Exception exception) {
                            SetupEditor.this.resourceToDiagnosticMap.put(resource, SetupEditor.this.analyzeResourceProblems(resource, exception));
                        }
                        first = false;
                    }
                    ++i;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            ISchedulingRule currentRule = Job.getJobManager().currentRule();
            new ProgressMonitorDialog(this.getSite().getShell()).run(currentRule == null, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            SetupEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        EList resources = this.editingDomain.getResourceSet().getResources();
        int i = 1;
        while (i < resources.size()) {
            Resource resource = (Resource)resources.get(i);
            if (resource.getContents().isEmpty() && !resource.getErrors().isEmpty()) {
                this.resourceToDiagnosticMap.remove(resource);
                resources.remove(i);
                resource.unload();
                continue;
            }
            ++i;
        }
        if (this.reproxifier != null) {
            this.reproxifier.run();
        }
        this.doSaveGen(progressMonitor);
        this.getActionBarContributor().scheduleValidation();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAsGen(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        this.editingDomain.getResourceToReadOnlyMap().remove(this.editingDomain.getResourceSet().getResources().get(0));
        this.doSaveAsGen(uri, editorInput);
    }

    public void gotoMarker(IMarker marker) {
        List targetObjects = this.markerHelper.getTargetObjects((Object)this.editingDomain, marker);
        if (!targetObjects.isEmpty()) {
            this.setSelectionToViewer(targetObjects);
        }
    }

    public void toggleInput() {
        this.toggleInput(false);
    }

    private void toggleInput(boolean forceResourceSet) {
        Object[] selection = ((IStructuredSelection)this.selectionViewer.getSelection()).toArray();
        Object[] expandedElements = this.selectionViewer.getExpandedElements();
        Object input = this.selectionViewer.getInput();
        if (input instanceof ResourceSet) {
            if (forceResourceSet) {
                return;
            }
            Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
            this.selectionViewer.setInput((Object)resource);
            this.getActionBarContributor().getToggleViewerInputAction().setChecked(false);
        } else if (input instanceof Resource) {
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
        } else if (input == this.loadingResourceInput) {
            if (forceResourceSet) {
                return;
            }
            this.selectionViewer.setInput((Object)this.loadingResourceSetInput);
            this.getActionBarContributor().getToggleViewerInputAction().setChecked(true);
        } else if (input == this.loadingResourceSetInput) {
            this.selectionViewer.setInput((Object)this.loadingResourceInput);
        }
        this.selectionViewer.setExpandedElements(expandedElements);
        this.selectionViewer.setSelection((ISelection)new StructuredSelection(selection));
    }

    public void initGen(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        final IResourceChangeListener delegateResourceChangeListener = this.resourceChangeListener;
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (SetupEditor.this.resourceMirror == null) {
                    delegateResourceChangeListener.resourceChanged(event);
                }
            }
        };
        site.getWorkbenchWindow().getWorkbench().addWindowListener(this.windowListener);
        this.initGen(site, editorInput);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(SetupEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(SetupEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(SetupEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return SetupEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return SetupEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public SetupActionBarContributor getActionBarContributor() {
        return (SetupActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void disposeGen() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getWorkbench().removeWindowListener(this.windowListener);
        this.disposeGen();
    }

    protected boolean showOutlineView() {
        return true;
    }

    public static class BrowserDialog
    extends DockableDialog {
        private final SetupLocationListener locationListener = new SetupLocationListener(false);
        private final ISelectionListener selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                Object object;
                this.getDockable().setWorkbenchPart(part);
                if (locationListener.setupEditor != null && selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) != null) {
                    locationListener.setSelection(object);
                }
            }
        };
        private Browser browser;
        private StyledText noBrowser;

        protected BrowserDialog(IWorkbenchWindow workbenchWindow) {
            super(workbenchWindow);
        }

        public boolean handleWorkbenchPart(IWorkbenchPart part) {
            ContentOutline contentOutline;
            IPage page;
            SetupEditor setupEditor = null;
            if (part instanceof SetupEditor) {
                setupEditor = (SetupEditor)part;
            } else if (part instanceof ContentOutline && (page = (contentOutline = (ContentOutline)part).getCurrentPage()) instanceof OutlinePreviewPage) {
                OutlinePreviewPage outlinePreviewPage = (OutlinePreviewPage)page;
                setupEditor = outlinePreviewPage.getSetupEditor();
            }
            this.locationListener.setEditor(setupEditor);
            return setupEditor != null;
        }

        protected void setInput(SetupEditor setupEditor, Object input) {
            this.getDockable().setWorkbenchPart((IWorkbenchPart)setupEditor);
            LocationEvent event = new LocationEvent((Widget)(this.browser == null ? this.noBrowser : this.browser));
            if (input instanceof URI) {
                event.location = ((URI)input).toString();
                this.locationListener.changing(event);
                this.browser.setUrl(event.location);
            } else {
                URI uri = SetupActionBarContributor.getEditURI(ToolTipObject.unwrap(input), true);
                event.location = uri == null ? "about:blank" : uri.toString();
                this.locationListener.changing(event);
                if (uri == null) {
                    this.locationListener.setSelection(input);
                }
            }
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return SetupEditorPlugin.INSTANCE.getDialogSettings("Browser");
        }

        protected Control createContents(Composite parent) {
            Browser content;
            this.getShell().setText(Messages.SetupEditor_setupLocationListener_setupInformationBrowser);
            Composite composite = new Composite(parent, 0);
            FillLayout layout = new FillLayout();
            composite.setLayout((Layout)layout);
            GridData layoutData = new GridData(1808);
            layoutData.widthHint = 800;
            layoutData.heightHint = 600;
            composite.setLayoutData((Object)layoutData);
            BrowserDialog.applyDialogFont((Control)composite);
            this.initializeDialogUnits((Control)composite);
            if (UIUtil.isBrowserAvailable()) {
                content = this.browser = new Browser(composite, 0);
                this.browser.addLocationListener((LocationListener)this.locationListener);
            } else {
                this.noBrowser = new StyledText(composite, 768);
                content = this.noBrowser;
                this.noBrowser.setAlwaysShowScrollBars(false);
            }
            Display display = parent.getDisplay();
            content.setForeground(display.getSystemColor(28));
            content.setBackground(display.getSystemColor(29));
            final ISelectionService selectionService = this.getWorkbenchWindow().getSelectionService();
            selectionService.addPostSelectionListener(this.selectionListener);
            content.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    locationListener.dispose();
                    selectionService.removePostSelectionListener(selectionListener);
                }
            });
            this.locationListener.createToolBar(this.browser, this.noBrowser);
            return composite;
        }

        public static BrowserDialog getFor(IWorkbenchWindow workbenchWindow) {
            return (BrowserDialog)DockableDialog.getFor(BrowserDialog.class, (IWorkbenchWindow)workbenchWindow);
        }

        public static void closeFor(IWorkbenchWindow workbenchWindow) {
            DockableDialog.closeFor(BrowserDialog.class, (IWorkbenchWindow)workbenchWindow);
        }

        public static BrowserDialog openFor(IWorkbenchWindow workbenchWindow) {
            DockableDialog.Factory<BrowserDialog> factory = new DockableDialog.Factory<BrowserDialog>(){

                public BrowserDialog create(IWorkbenchWindow workbenchWindow) {
                    return new BrowserDialog(workbenchWindow);
                }
            };
            return (BrowserDialog)DockableDialog.openFor(BrowserDialog.class, (DockableDialog.Factory)factory, (IWorkbenchWindow)workbenchWindow);
        }
    }

    public static class DelegatingDialogSettings
    implements IDialogSettings {
        private final IDialogSettings dialogSettings = SetupEditorPlugin.INSTANCE.getDialogSettings();
        private boolean liveValidation;

        public void setLiveValidation(boolean liveValidation) {
            this.liveValidation = liveValidation;
        }

        public IDialogSettings addNewSection(String name) {
            return this.dialogSettings.addNewSection(name);
        }

        public void addSection(IDialogSettings section) {
            this.dialogSettings.addSection(section);
        }

        public String get(String key) {
            return this.dialogSettings.get(key);
        }

        public String[] getArray(String key) {
            return this.dialogSettings.getArray(key);
        }

        public boolean getBoolean(String key) {
            if ("liveValidator".equals(key) && !this.liveValidation) {
                return false;
            }
            return this.dialogSettings.getBoolean(key);
        }

        public double getDouble(String key) throws NumberFormatException {
            return this.dialogSettings.getDouble(key);
        }

        public float getFloat(String key) throws NumberFormatException {
            return this.dialogSettings.getFloat(key);
        }

        public int getInt(String key) throws NumberFormatException {
            return this.dialogSettings.getInt(key);
        }

        public long getLong(String key) throws NumberFormatException {
            return this.dialogSettings.getLong(key);
        }

        public String getName() {
            return this.dialogSettings.getName();
        }

        public IDialogSettings getSection(String sectionName) {
            return this.dialogSettings.getSection(sectionName);
        }

        public IDialogSettings[] getSections() {
            return this.dialogSettings.getSections();
        }

        public void load(Reader reader) throws IOException {
            this.dialogSettings.load(reader);
        }

        public void load(String fileName) throws IOException {
            this.dialogSettings.load(fileName);
        }

        public void put(String key, String[] value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, double value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, float value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, int value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, long value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, String value) {
            this.dialogSettings.put(key, value);
        }

        public void put(String key, boolean value) {
            this.dialogSettings.put(key, value);
        }

        public void save(Writer writer) throws IOException {
            this.dialogSettings.save(writer);
        }

        public void save(String fileName) throws IOException {
            this.dialogSettings.save(fileName);
        }
    }

    private static class ErrorOverlayImage
    extends ComposedImage {
        private ErrorOverlayImage(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            ArrayList<ComposedImage.Point> result = new ArrayList<ComposedImage.Point>();
            result.add(new ComposedImage.Point());
            ComposedImage.Point overlay = new ComposedImage.Point();
            overlay.y = 7;
            result.add(overlay);
            return result;
        }
    }

    class OutlinePreviewPage
    extends ContentOutlinePage
    implements IAdaptable {
        private ILabelProvider labelProvider;
        private Trigger trigger;
        private final Map<Object, Set<Object>> copyMap = new LinkedHashMap<Object, Set<Object>>();
        private final Map<Object, Set<Object>> inverseCopyMap = new LinkedHashMap<Object, Set<Object>>();
        private final Map<SetupTask, Set<VariableTask>> inducedIDVariables = new LinkedHashMap<SetupTask, Set<VariableTask>>();
        private final List<Notifier> notifiers = new ArrayList<Notifier>();
        private final Set<EObject> syntheticObjects = new LinkedHashSet<EObject>();
        private final Map<Object, Object> parents = new LinkedHashMap<Object, Object>();
        private final List<Scope> previewableScopes = new UniqueEList();
        private final Set<Resource> primaryResources = new LinkedHashSet<Resource>();
        private final Stream compositeStream = SetupFactory.eINSTANCE.createStream();
        private final Configuration compositeConfiguration = SetupFactory.eINSTANCE.createConfiguration();
        private final Macro compositeMacro = SetupFactory.eINSTANCE.createMacro();
        private OutlineItemProvider root;
        private AdapterFactoryEditingDomain.EditingDomainProvider editingDomainProvider;
        private ResourceLocator resourceLocator;
        private AdapterFactoryItemDelegator itemDelegator;
        private PreviewAction previewAction;

        public OutlinePreviewPage() {
            this.editingDomainProvider = new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)SetupEditor.this.editingDomain);
            this.compositeStream.setLabel(Messages.SetupEditor_outlinePreviewPage_compositeStream_label);
            this.compositeStream.setName("composite");
            this.compositeStream.setDescription(Messages.SetupEditor_outlinePreviewPage_compositeStream_description);
            this.compositeConfiguration.setLabel(Messages.SetupEditor_outlinePreviewPage_compositeConfiguration_label);
            this.compositeConfiguration.setDescription(Messages.SetupEditor_outlinePreviewPage_compositeConfiguration_description);
            this.compositeMacro.setName("macros");
            this.compositeMacro.setLabel(Messages.SetupEditor_outlinePreviewPage_compositeMacro_label);
            this.compositeMacro.setDescription(Messages.SetupEditor_outlinePreviewPage_compositeMacro_description);
        }

        public List<Scope> getPreviewableScopes() {
            ListIterator<Scope> it = this.previewableScopes.listIterator();
            while (it.hasNext()) {
                Scope scope = it.next();
                if (!scope.eIsProxy()) continue;
                EObject resolvedScope = EcoreUtil.resolve((EObject)scope, (ResourceSet)SetupEditor.this.editingDomain.getResourceSet());
                if (!resolvedScope.eIsProxy() && resolvedScope instanceof Scope) {
                    it.set((Scope)resolvedScope);
                    continue;
                }
                it.remove();
            }
            return this.previewableScopes;
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlinePage = null;
                }
            });
            SetupEditor.this.contentOutlineViewer = this.getTreeViewer();
            this.previewAction = new PreviewAction();
            SetupEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            SetupEditor.this.contentOutlineViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.selectionViewer != null) {
                        ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.selectionViewer.getControl().setFocus();
                        SetupEditor.this.setSelection(((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.selectionViewer.getSelection());
                    }
                }
            });
            this.itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)SetupEditor.this.adapterFactory);
            AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)SetupEditor.this.adapterFactory){

                public boolean hasChildren(Object object) {
                    return this.getVariableContainer(object) != null || super.hasChildren(object);
                }

                private VariableContainer getVariableContainer(Object object) {
                    Object parent;
                    if (object instanceof VariableTask && (parent = OutlinePreviewPage.this.parents.get(object)) instanceof VariableContainer) {
                        return (VariableContainer)((Object)parent);
                    }
                    return null;
                }

                public Object[] getChildren(Object object) {
                    VariableTask contextVariableTask;
                    String name;
                    VariableContainer variableContainer = this.getVariableContainer(object);
                    if (variableContainer != null && !StringUtil.isEmpty((String)(name = (contextVariableTask = (VariableTask)object).getName()))) {
                        boolean isMacro = false;
                        UniqueEList variableUsages = new UniqueEList();
                        Set<Object> inverses = OutlinePreviewPage.this.inverseCopyMap.get(object);
                        if (inverses != null) {
                            for (Object inverse : inverses) {
                                EObject rootContainer;
                                VariableTask variableTask;
                                String actualName;
                                Object unwrappedInverse = AdapterFactoryEditingDomain.unwrap((Object)inverse);
                                if (unwrappedInverse instanceof Parameter) {
                                    String actualName2 = ((Parameter)unwrappedInverse).getName();
                                    Object unwrappedParent = AdapterFactoryEditingDomain.unwrap((Object)((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.selectionViewerContentProvider.getParent(inverse));
                                    if (!(unwrappedParent instanceof Macro)) continue;
                                    isMacro = true;
                                    Macro macro = (Macro)unwrappedParent;
                                    variableUsages.addAll(this.getMatchingUsages(variableContainer, object, (EObject)macro, actualName2));
                                    continue;
                                }
                                if (!(unwrappedInverse instanceof VariableTask) || name.equals(actualName = (variableTask = (VariableTask)unwrappedInverse).getName()) || !((rootContainer = EcoreUtil.getRootContainer((EObject)variableTask)) instanceof Macro)) continue;
                                isMacro = true;
                                variableUsages.addAll(this.getMatchingUsages(variableContainer, object, rootContainer, actualName));
                            }
                        }
                        if (!isMacro) {
                            variableUsages.addAll(this.getMatchingUsages(variableContainer, object, null, name));
                        }
                        return variableUsages.toArray();
                    }
                    return super.getChildren(object);
                }

                private List<Object> getMatchingUsages(VariableContainer variableContainer, Object object, EObject context, String actualName) {
                    ArrayList<Object> variableUsages = new ArrayList<Object>();
                    SetupTaskPerformer setupTaskPerformer = variableContainer.getSetupTaskPerformer();
                    for (Object original : OutlinePreviewPage.this.copyMap.keySet()) {
                        Macro containingMacro;
                        Object unwrappedOriginal = AdapterFactoryEditingDomain.unwrap((Object)original);
                        if (!(unwrappedOriginal instanceof EObject)) continue;
                        EObject unwrappedOriginalEObject = (EObject)unwrappedOriginal;
                        if (context != null ? !EcoreUtil.isAncestor((EObject)context, (EObject)unwrappedOriginalEObject) : (containingMacro = this.getContainingMacro(original)) != null && !setupTaskPerformer.getMacroCopyMap().containsKey(original)) continue;
                        if (!SetupTaskPerformer.isVariableUsed((String)actualName, (EObject)unwrappedOriginalEObject, (boolean)false) && !SetupTaskPerformer.isFilterUsed((String)actualName, (EObject)unwrappedOriginalEObject)) continue;
                        variableUsages.add(variableContainer.wrapper(object, original));
                    }
                    return variableUsages;
                }

                private Macro getContainingMacro(Object object) {
                    if (object instanceof EObject) {
                        EObject eContainer = ((EObject)object).eContainer();
                        while (eContainer != null) {
                            if (eContainer instanceof Macro) {
                                return (Macro)eContainer;
                            }
                            eContainer = eContainer.eContainer();
                        }
                    }
                    return null;
                }

                public Object getParent(Object object) {
                    Object parent = OutlinePreviewPage.this.parents.get(object);
                    return parent != null ? parent : super.getParent(object);
                }
            };
            SetupEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)contentProvider);
            SetupEditor.this.configure((ColumnViewer)SetupEditor.this.contentOutlineViewer, this.primaryResources, this.syntheticObjects);
            Menu menu = SetupEditor.this.contentOutlineViewer.getControl().getMenu();
            IMenuManager menuManager = (IMenuManager)menu.getData("org.eclipse.jface.action.MenuManager.managerKey");
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.insertBefore("edit", (IAction)OutlinePreviewPage.this.previewAction);
                }
            });
            this.labelProvider = (ILabelProvider)SetupEditor.this.contentOutlineViewer.getLabelProvider();
            this.root = new OutlineItemProvider(null, false);
            SetupEditor.this.selectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.selectionViewer != null && ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.selectionViewer.getControl().isFocusControl() && !selection.isEmpty() && ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlinePage != null) {
                        ArrayList<Object> selectionList = new ArrayList<Object>();
                        Object[] objectArray = selection.toArray();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            this.collectSelection(selectionList, object);
                            ++n2;
                        }
                        if (!selectionList.isEmpty()) {
                            ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlinePage = null;
                            OutlinePreviewPage.this.getTreeViewer().setSelection((ISelection)new StructuredSelection(selectionList));
                            ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlinePage = OutlinePreviewPage.this;
                        }
                    }
                }

                private void collectSelection(List<Object> selection, Object object) {
                    Object unwrappedObject = AdapterFactoryEditingDomain.unwrap((Object)object);
                    if (unwrappedObject instanceof CompoundTask || unwrappedObject instanceof Macro) {
                        Collection children = object instanceof ITreeItemContentProvider ? ((ITreeItemContentProvider)object).getChildren(object) : ((EObject)unwrappedObject).eContents();
                        Iterator iterator = children.iterator();
                        while (iterator.hasNext()) {
                            Object child = iterator.next();
                            this.collectSelection(selection, child);
                        }
                    } else {
                        Set<Object> copies = ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlinePage.getCopies(object);
                        for (Object copy : copies) {
                            Object unwrappedCopy = AdapterFactoryEditingDomain.unwrap((Object)copy);
                            if (unwrappedCopy instanceof CompoundTask) {
                                this.collectSelection(selection, copy);
                                continue;
                            }
                            selection.add(copy);
                        }
                    }
                }
            });
            SetupEditor.this.contentOutlineViewer.expandToLevel(2);
        }

        public Set<Object> getOriginals(Object object) {
            Set<Object> originals = this.inverseCopyMap.get(object);
            if (originals == null) {
                return this.copyMap.containsKey(object) ? Collections.singleton(object) : Collections.emptySet();
            }
            return originals;
        }

        public Set<Object> getCopies(Object object) {
            Set<Object> copies = this.copyMap.get(object);
            if (copies == null) {
                return this.inverseCopyMap.containsKey(object) ? Collections.singleton(object) : Collections.emptySet();
            }
            return copies;
        }

        private boolean isPreviewableScope(Object scope) {
            return scope instanceof Macro || scope instanceof Workspace || scope instanceof Installation || scope instanceof Stream || scope instanceof ProductVersion || scope instanceof User;
        }

        protected Index getIndex() {
            for (Resource resource : SetupEditor.this.editingDomain.getResourceSet().getResources()) {
                Index index = (Index)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.INDEX);
                if (index == null) continue;
                return index;
            }
            return null;
        }

        public void update(int expandLevel) {
            if (this.labelProvider != null) {
                block20: {
                    this.copyMap.clear();
                    this.inverseCopyMap.clear();
                    this.inducedIDVariables.clear();
                    this.primaryResources.clear();
                    this.syntheticObjects.clear();
                    ResourceSet resourceSet = SetupEditor.this.editingDomain.getResourceSet();
                    if (this.resourceLocator != null) {
                        this.resourceLocator.dispose();
                    }
                    this.resourceLocator = new ResourceLocator(resourceSet);
                    for (Notifier notifier : this.notifiers) {
                        notifier.eAdapters().clear();
                    }
                    this.notifiers.clear();
                    try {
                        OutlineItemProvider configurationOutline;
                        OutlineItemProvider macroOutline;
                        Index index;
                        boolean hasEmptyInput;
                        EList eList = resourceSet.getResources();
                        if (eList.isEmpty()) break block20;
                        Resource resource = (Resource)eList.get(0);
                        this.primaryResources.add(resource);
                        EList contents = resource.getContents();
                        if (contents.isEmpty()) break block20;
                        EObject rootEObject = (EObject)contents.get(0);
                        boolean bl = hasEmptyInput = this.getTreeViewer().getInput() == null;
                        if (hasEmptyInput) {
                            if (this.isPreviewableScope(rootEObject)) {
                                this.previewableScopes.add((Scope)rootEObject);
                            } else if (rootEObject instanceof Project) {
                                this.previewableScopes.addAll((Collection<Scope>)((Project)rootEObject).getStreams());
                            } else if (rootEObject instanceof Product) {
                                this.previewableScopes.addAll((Collection<Scope>)((Product)rootEObject).getVersions());
                            }
                        }
                        ArrayList newRootChildren = new ArrayList();
                        newRootChildren.add(this.reconcileOutline(this.root, null, rootEObject));
                        if ((rootEObject instanceof Workspace || rootEObject instanceof Installation || rootEObject instanceof Configuration) && (index = this.getIndex()) != null) {
                            newRootChildren.add(this.reconcileOutline(this.root, null, (EObject)index));
                        }
                        if ((macroOutline = this.reconcileCompositeOutline(this.root, (EObject)this.compositeMacro)) != null) {
                            newRootChildren.add(macroOutline);
                        }
                        if ((rootEObject instanceof Configuration || rootEObject instanceof Index) && (configurationOutline = this.reconcileCompositeOutline(this.root, (EObject)this.compositeConfiguration)) != null) {
                            newRootChildren.add(configurationOutline);
                        }
                        ECollections.setEList((EList)this.root.getChildren(), (List)newRootChildren);
                        if (hasEmptyInput) {
                            Set<Object> elements;
                            this.getTreeViewer().setInput((Object)this.root);
                            if (this.previewableScopes.isEmpty() || (elements = this.copyMap.get(this.previewableScopes.get(0))) == null) break block20;
                            for (Object object : elements) {
                                if (!(object instanceof OutlineItemProvider)) continue;
                                this.getTreeViewer().setExpandedState(object, true);
                                break block20;
                            }
                            break block20;
                        }
                        this.getTreeViewer().refresh();
                    }
                    catch (Exception exception) {
                        SetupEditorPlugin.INSTANCE.log(exception);
                    }
                }
                for (Map.Entry entry : this.copyMap.entrySet()) {
                    Object original = entry.getKey();
                    Set copies = (Set)entry.getValue();
                    for (Object value : copies) {
                        this.add(this.inverseCopyMap, value, original);
                    }
                }
                for (Map.Entry entry : this.inducedIDVariables.entrySet()) {
                    SetupTask setupTask = (SetupTask)entry.getKey();
                    Set variables = (Set)entry.getValue();
                    Set<Object> inverses = this.inverseCopyMap.get(setupTask);
                    if (inverses == null) continue;
                    for (VariableTask variable : variables) {
                        this.addAll(this.inverseCopyMap, variable, inverses);
                    }
                }
                this.getTreeViewer().expandToLevel(expandLevel);
            }
        }

        private OutlineItemProvider reconcileCompositeOutline(OutlineItemProvider parent, EObject composite) {
            EClass eClass = composite.eClass();
            EList resources = SetupEditor.this.editingDomain.getResourceSet().getResources();
            OutlineItemProvider compositeOutline = null;
            ArrayList<OutlineItemProvider> newChildren = new ArrayList<OutlineItemProvider>();
            int i = 1;
            int size = resources.size();
            while (i < size) {
                Resource otherResource = (Resource)resources.get(i);
                EObject instance = (EObject)EcoreUtil.getObjectByType((Collection)otherResource.getContents(), (EClassifier)eClass);
                if (instance != null) {
                    if (compositeOutline == null) {
                        compositeOutline = this.reconcileOutline(parent, null, composite);
                    }
                    newChildren.add(this.reconcileOutline(compositeOutline, null, instance));
                }
                ++i;
            }
            if (compositeOutline != null) {
                Collections.sort(newChildren, new Comparator<OutlineItemProvider>(){

                    @Override
                    public int compare(OutlineItemProvider o1, OutlineItemProvider o2) {
                        return CommonPlugin.INSTANCE.getComparator().compare(o1.getText(), o2.getText());
                    }
                });
                ECollections.setEList((EList)compositeOutline.getChildren(), newChildren);
            }
            return compositeOutline;
        }

        private List<String> sortStrings(Collection<? extends String> strings) {
            BasicEList pairs = new BasicEList();
            for (String string : strings) {
                pairs.add((Object)new Pair((Object)SegmentSequence.create((String)".", (String)string), (Object)string));
            }
            Pair[] pairArray = (Pair[])pairs.toArray((Object[])new Pair[pairs.size()]);
            return this.sort(pairArray);
        }

        private List<VariableTask> sortVariables(Collection<? extends VariableTask> variables) {
            BasicEList pairs = new BasicEList();
            for (VariableTask variableTask : variables) {
                pairs.add((Object)new Pair((Object)SegmentSequence.create((String)".", (String)variableTask.getName()), (Object)variableTask));
            }
            Pair[] pairArray = (Pair[])pairs.toArray((Object[])new Pair[pairs.size()]);
            return this.sort(pairArray);
        }

        private <T> List<T> sort(Pair<SegmentSequence, T>[] pairs) {
            Arrays.sort(pairs, new Comparator<Pair<SegmentSequence, T>>(){
                private final Comparator<String> comparator = CommonPlugin.INSTANCE.getComparator();

                @Override
                public int compare(Pair<SegmentSequence, T> o1, Pair<SegmentSequence, T> o2) {
                    SegmentSequence s1 = (SegmentSequence)o1.getElement1();
                    SegmentSequence s2 = (SegmentSequence)o2.getElement1();
                    if (s1 == null) {
                        if (s2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (s2 == null) {
                        return 1;
                    }
                    int length1 = s1.segmentCount();
                    int length2 = s2.segmentCount();
                    int length = Math.min(length1, length2);
                    int i = 0;
                    while (i < length) {
                        String e2;
                        String e1 = StringUtil.safe((String)s1.segment(i));
                        int result = this.comparator.compare(e1, e2 = StringUtil.safe((String)s2.segment(i)));
                        if (result != 0) {
                            return result;
                        }
                        ++i;
                    }
                    return length1 - length2;
                }
            });
            ArrayList<Object> result = new ArrayList<Object>(pairs.length);
            Pair<SegmentSequence, T>[] pairArray = pairs;
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                Pair<SegmentSequence, T> pair = pairArray[n2];
                result.add(pair.getElement2());
                ++n2;
            }
            return result;
        }

        private OutlineItemProvider reconcileOutline(OutlineItemProvider parentItemProvider, Scope context, EObject scope) {
            Scope childScope;
            List scopes;
            OutlineItemProvider outlineItemProvider = parentItemProvider.getOutlineItemProvider(scope);
            if (outlineItemProvider == null) {
                outlineItemProvider = new OutlineItemProvider(scope, context != null);
            } else {
                outlineItemProvider.update();
            }
            this.add(this.copyMap, scope, outlineItemProvider);
            ArrayList<Object> newChildren = new ArrayList<Object>();
            if (this.getPreviewableScopes().contains(scope)) {
                newChildren.addAll(this.gatherSetupTasks(outlineItemProvider, context, (Scope)scope));
            }
            EClass eClass = scope.eClass();
            for (EReference eReference : eClass.getEAllContainments()) {
                if (!SetupPackage.Literals.SCOPE.isSuperTypeOf(eReference.getEReferenceType())) continue;
                if (eReference.isMany()) {
                    scopes = (List)scope.eGet((EStructuralFeature)eReference);
                    for (Scope childScope2 : scopes) {
                        newChildren.add((Object)this.reconcileOutline(outlineItemProvider, null, (EObject)childScope2));
                    }
                    continue;
                }
                childScope = (Scope)scope.eGet((EStructuralFeature)eReference);
                if (childScope == null) continue;
                newChildren.add((Object)this.reconcileOutline(outlineItemProvider, null, (EObject)childScope));
            }
            for (EReference eReference : eClass.getEAllReferences()) {
                if (eReference != SetupPackage.Literals.WORKSPACE__STREAMS && eReference != SetupPackage.Literals.INSTALLATION__PRODUCT_VERSION) continue;
                if (eReference.isMany()) {
                    scopes = (List)scope.eGet((EStructuralFeature)eReference);
                    if (scopes.isEmpty()) continue;
                    newChildren.add((Object)this.reconcileOutline(outlineItemProvider, (Scope)scope, (EObject)this.compositeStream));
                    for (Scope childScope2 : scopes) {
                        newChildren.add((Object)this.reconcileOutline(outlineItemProvider, (Scope)scope, (EObject)childScope2));
                    }
                    continue;
                }
                childScope = (Scope)scope.eGet((EStructuralFeature)eReference);
                if (childScope == null) continue;
                newChildren.add((Object)this.reconcileOutline(outlineItemProvider, (Scope)scope, (EObject)childScope));
            }
            ECollections.setEList((EList)outlineItemProvider.getChildren(), newChildren);
            return outlineItemProvider;
        }

        private List<Object> gatherSetupTasks(OutlineItemProvider container, Scope context, Scope scope) {
            SetupTaskPerformer setupTaskPerformer;
            BaseResourceImpl fakeInstallationResource;
            Installation installationCopy;
            Macro macro;
            ArrayList<Object> result = new ArrayList<Object>();
            ProductVersion version = scope instanceof ProductVersion ? (ProductVersion)scope : null;
            Stream stream = scope instanceof Stream ? (Stream)scope : null;
            Macro macro2 = macro = scope instanceof Macro ? (Macro)scope : null;
            if (version == null) {
                Iterator iterator;
                Index index;
                Project project;
                Index rootContainer = null;
                if (stream != null && (project = stream.getProject()) != null) {
                    ProjectCatalog projectCatalog = project.getProjectCatalog();
                    rootContainer = EcoreUtil.getRootContainer((EObject)projectCatalog);
                }
                if (!(rootContainer instanceof Index) && (index = this.getIndex()) != null) {
                    rootContainer = index;
                }
                if (rootContainer instanceof Index && (iterator = (index = (Index)rootContainer).getProductCatalogs().iterator()).hasNext()) {
                    ProductCatalog productCatalog = (ProductCatalog)iterator.next();
                    for (Product product : productCatalog.getProducts()) {
                        Iterator iterator2 = product.getVersions().iterator();
                        while (iterator2.hasNext()) {
                            ProductVersion productVersion;
                            version = productVersion = (ProductVersion)iterator2.next();
                        }
                    }
                }
                if (version == null) {
                    return result;
                }
            }
            SetupContext setupContext = SetupContext.create((ProductVersion)version, (Stream)stream);
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            if (scope instanceof Workspace) {
                Workspace workspaceCopy = (Workspace)copier.copy((EObject)scope);
                copier.copyReferences();
                workspaceCopy.getStreams().clear();
                BaseResourceImpl fakeWorkspaceResource = new BaseResourceImpl(scope.eResource().getURI());
                fakeWorkspaceResource.getContents().add((Object)workspaceCopy);
                setupContext = SetupContext.create((Installation)setupContext.getInstallation(), (Workspace)workspaceCopy, (User)setupContext.getUser());
            } else if (scope instanceof Installation) {
                installationCopy = (Installation)copier.copy((EObject)scope);
                copier.copyReferences();
                installationCopy.setProductVersion(version);
                fakeInstallationResource = new BaseResourceImpl(scope.eResource().getURI());
                fakeInstallationResource.getContents().add((Object)installationCopy);
                setupContext = SetupContext.create((Installation)installationCopy, (Workspace)setupContext.getWorkspace(), (User)setupContext.getUser());
            } else if (scope instanceof User) {
                User userCopy = (User)copier.copy((EObject)scope);
                copier.copyReferences();
                BaseResourceImpl fakeUserResource = new BaseResourceImpl(scope.eResource().getURI());
                fakeUserResource.getContents().add((Object)userCopy);
                setupContext = SetupContext.create((Installation)setupContext.getInstallation(), (Workspace)setupContext.getWorkspace(), (User)userCopy);
            }
            if (context instanceof Installation) {
                installationCopy = (Installation)copier.copy((EObject)context);
                copier.copyReferences();
                installationCopy.setProductVersion(version);
                fakeInstallationResource = new BaseResourceImpl(context.eResource().getURI());
                fakeInstallationResource.getContents().add((Object)installationCopy);
                setupContext = SetupContext.create((Installation)installationCopy, (Workspace)setupContext.getWorkspace(), (User)setupContext.getUser());
            } else if (context instanceof Workspace) {
                Installation installation = setupContext.getInstallation();
                Workspace workspaceCopy = (Workspace)copier.copy((EObject)context);
                if (stream == this.compositeStream) {
                    Configuration configuration;
                    Installation configurationInstallation;
                    EObject eContainer = context.eContainer();
                    if (eContainer instanceof Configuration && (configurationInstallation = (configuration = (Configuration)eContainer).getInstallation()) != null) {
                        Installation configurationInstallationCopy;
                        installation = configurationInstallationCopy = (Installation)copier.copy((EObject)configurationInstallation);
                        BaseResourceImpl fakeInstallationResource2 = new BaseResourceImpl(context.eResource().getURI());
                        fakeInstallationResource2.getContents().add((Object)configurationInstallationCopy);
                    }
                    copier.copyReferences();
                } else {
                    copier.copyReferences();
                    workspaceCopy.getStreams().clear();
                    workspaceCopy.getStreams().add((Object)stream);
                }
                BaseResourceImpl fakeWorkspaceResource = new BaseResourceImpl(context.eResource().getURI());
                fakeWorkspaceResource.getContents().add((Object)workspaceCopy);
                setupContext = SetupContext.create((Installation)installation, (Workspace)workspaceCopy, (User)setupContext.getUser());
            }
            MacroTask macroTask = null;
            ArrayList<VariableTask> macroTaskVariables = new ArrayList<VariableTask>();
            if (macro != null) {
                Workspace workspace = setupContext.getWorkspace();
                macroTask = SetupFactory.eINSTANCE.createMacroTask();
                macroTask.setMacro(macro);
                workspace.getSetupTasks().add((Object)macroTask);
                String id = macro.getName();
                macroTask.setID(StringUtil.isEmpty((String)id) ? "macro" : id);
                EList parameters = macro.getParameters();
                EList arguments = macroTask.getArguments();
                for (Parameter parameter : parameters) {
                    VariableTask variable = SetupFactory.eINSTANCE.createVariableTask();
                    String parameterName = parameter.getName();
                    variable.setName(parameterName);
                    workspace.getSetupTasks().add((Object)variable);
                    macroTaskVariables.add(variable);
                    Argument argument = SetupFactory.eINSTANCE.createArgument();
                    argument.setParameter(parameter);
                    argument.setValue("${" + parameterName + "}");
                    arguments.add((Object)argument);
                }
                Resource resource = workspace.eResource();
                if (resource == null) {
                    BaseResourceImpl fakeWorkspaceResource = new BaseResourceImpl(macro.eResource().getURI());
                    fakeWorkspaceResource.getContents().add((Object)workspace);
                    resource = fakeWorkspaceResource;
                }
                this.primaryResources.add(resource);
            }
            ResourceSet resourceSet = SetupEditor.this.getEditingDomain().getResourceSet();
            URIConverter uriConverter = resourceSet.getURIConverter();
            try {
                setupTaskPerformer = SetupTaskPerformer.create((URIConverter)uriConverter, (SetupPrompter)SetupPrompter.OK, (Trigger)this.trigger, (SetupContext)setupContext, (boolean)false, (boolean)true);
            }
            catch (Exception ex) {
                return result;
            }
            ArrayList triggeredSetupTasks = new ArrayList(setupTaskPerformer.getTriggeredSetupTasks());
            if (!triggeredSetupTasks.isEmpty()) {
                Set copies;
                EObject original;
                Object name;
                Map performerCopyMap = setupTaskPerformer.getCopyMap();
                for (Map.Entry entry : copier.entrySet()) {
                    EObject key = (EObject)entry.getKey();
                    EObject value = (EObject)entry.getValue();
                    performerCopyMap.put(key, (Set)performerCopyMap.get(value));
                }
                URI baseURI = URI.createURI((String)("performer:/" + scope.getQualifiedName()));
                URI uri = baseURI.appendSegment("tasks.setup");
                URI scopeURI = context == null ? scope.eResource().getURI() : context.eResource().getURI();
                BaseResourceImpl fakeResource = new BaseResourceImpl(uri);
                fakeResource.eAdapters().add((Object)this.editingDomainProvider);
                EList fakeResourceContents = fakeResource.getContents();
                this.resourceLocator.map(uri, (Resource)fakeResource);
                LinkedHashSet eObjects = new LinkedHashSet();
                for (Set copies2 : performerCopyMap.values()) {
                    eObjects.addAll(copies2);
                }
                Map performerMacroCopyMap = setupTaskPerformer.getMacroCopyMap();
                for (Set copies3 : performerMacroCopyMap.values()) {
                    eObjects.addAll(copies3);
                }
                for (EObject eObject : eObjects) {
                    this.notifiers.add((Notifier)eObject);
                    Resource.Internal resource = ((InternalEObject)eObject).eDirectResource();
                    if (resource != null && !resource.eAdapters().contains((Object)this.editingDomainProvider)) {
                        resource.eAdapters().add((Object)this.editingDomainProvider);
                        this.notifiers.add((Notifier)resource);
                        URI originalURI = resource.getURI();
                        URI newURI = baseURI.appendSegment(String.valueOf(originalURI.scheme()) + ":").appendSegments(originalURI.segments());
                        resource.setURI(newURI);
                        if (scopeURI.equals(originalURI)) {
                            this.primaryResources.add((Resource)resource);
                        }
                        this.resourceLocator.map(newURI, (Resource)resource);
                    }
                    if ((resource = eObject.eResource()) != null && resource != fakeResource) continue;
                    EClass eClass = eObject.eClass();
                    EAttribute eIDAttribute = eClass.getEIDAttribute();
                    if (eIDAttribute != null) {
                        eObject.eUnset((EStructuralFeature)eIDAttribute);
                    }
                    if (eObject.eContainer() == null) {
                        fakeResourceContents.add((Object)eObject);
                    }
                    this.syntheticObjects.add(eObject);
                }
                VariableContainer undeclaredVariablesItem = new VariableContainer(setupTaskPerformer, Messages.SetupEditor_outlinePreviewPage_undeclaredVariables, UNDECLARED_VARIABLE_GROUP_IMAGE);
                EList undeclaredVariablesItemChildren = undeclaredVariablesItem.getChildren();
                Set undeclaredVariables = setupTaskPerformer.getUndeclaredVariables();
                for (String key : this.sortStrings(undeclaredVariables)) {
                    VariableTask contextVariableTask = SetupFactory.eINSTANCE.createVariableTask();
                    fakeResourceContents.add((Object)contextVariableTask);
                    contextVariableTask.setName(key);
                    undeclaredVariablesItemChildren.add((Object)contextVariableTask);
                    this.parents.put(contextVariableTask, (Object)undeclaredVariablesItem);
                }
                if (!undeclaredVariablesItemChildren.isEmpty()) {
                    result.add((Object)undeclaredVariablesItem);
                }
                LinkedHashMap<String, VariableTask> variablesMap = new LinkedHashMap<String, VariableTask>();
                VariableContainer unresolvedVariablesItem = new VariableContainer(setupTaskPerformer, Messages.SetupEditor_outlinePreviewPage_unresolvedVariables, VARIABLE_GROUP_IMAGE);
                EList unresolvedVariablesItemChildren = unresolvedVariablesItem.getChildren();
                List unresolvedVariables = setupTaskPerformer.getUnresolvedVariables();
                for (VariableTask variable : this.sortVariables(unresolvedVariables)) {
                    if (variable.eContainer() == null && variable.eResource() == null) {
                        fakeResourceContents.add((Object)variable);
                    }
                    unresolvedVariablesItemChildren.add((Object)variable);
                    this.parents.put(variable, (Object)unresolvedVariablesItem);
                    variablesMap.put(variable.getName(), variable);
                }
                if (!unresolvedVariablesItemChildren.isEmpty()) {
                    result.add((Object)unresolvedVariablesItem);
                }
                VariableContainer resolvedVariablesItem = new VariableContainer(setupTaskPerformer, Messages.SetupEditor_outlinePreviewPage_resolvedVariables, VARIABLE_GROUP_IMAGE);
                EList resolvedVariablesItemChildren = resolvedVariablesItem.getChildren();
                List resolvedVariables = setupTaskPerformer.getResolvedVariables();
                for (VariableTask variable : this.sortVariables(resolvedVariables)) {
                    if (variable.eContainer() == null && variable.eResource() == null) {
                        fakeResourceContents.add((Object)variable);
                    }
                    resolvedVariablesItemChildren.add((Object)variable);
                    this.parents.put(variable, (Object)resolvedVariablesItem);
                    variablesMap.put(variable.getName(), variable);
                }
                if (!resolvedVariablesItemChildren.isEmpty()) {
                    result.add((Object)resolvedVariablesItem);
                }
                result.addAll(triggeredSetupTasks);
                for (SetupTask setupTask : triggeredSetupTasks) {
                    this.parents.put(setupTask, (Object)container);
                }
                LinkedHashMap<Object, Set<Object>> macroTaskMap = new LinkedHashMap<Object, Set<Object>>();
                LinkedHashMap<Object, Set<Object>> argumentBindingMap = new LinkedHashMap<Object, Set<Object>>();
                for (EObject eObject : performerCopyMap.keySet()) {
                    MacroTask originalMacroTask;
                    String id;
                    if (!(eObject instanceof MacroTask) || (id = (originalMacroTask = (MacroTask)eObject).getID()) == null) continue;
                    if (originalMacroTask == macroTask) {
                        this.gatherMacroChild(macroTaskMap, argumentBindingMap, true, id, macro);
                        for (VariableTask variableTask : macroTaskVariables) {
                            name = variableTask.getName();
                            String qualifiedName = SetupTaskPerformer.createQualifiedName((String)macroTask.getID(), (String)name);
                            Set argumentsVariables = (Set)macroTaskMap.get(qualifiedName);
                            if (argumentsVariables == null) continue;
                            this.addAll(macroTaskMap, variableTask, argumentsVariables);
                        }
                        continue;
                    }
                    if (macroTask != null && EcoreUtil.isAncestor((EObject)macroTask, (EObject)originalMacroTask)) continue;
                    Object[] children = SetupEditor.this.selectionViewerContentProvider.getChildren((Object)originalMacroTask);
                    this.gatherMacroChildren(macroTaskMap, argumentBindingMap, false, id, children);
                }
                for (Map.Entry entry : performerMacroCopyMap.entrySet()) {
                    original = (EObject)entry.getKey();
                    Set macroTaskMappings = (Set)macroTaskMap.get(original);
                    if (macroTaskMappings == null) continue;
                    Set copies4 = (Set)entry.getValue();
                    name = copies4.iterator();
                    while (name.hasNext()) {
                        EObject copy = (EObject)name.next();
                        this.addAll(macroTaskMap, copy, macroTaskMappings);
                    }
                }
                for (Map.Entry entry : performerCopyMap.entrySet()) {
                    VariableTask variableTask;
                    Set variableMappings;
                    original = (EObject)entry.getKey();
                    copies = (Set)entry.getValue();
                    this.addAll(this.copyMap, original, copies);
                    Set macroTaskMappings = (Set)macroTaskMap.get(original);
                    if (macroTaskMappings != null) {
                        name = macroTaskMappings.iterator();
                        while (name.hasNext()) {
                            Object object = name.next();
                            this.addAll(this.copyMap, object, copies);
                        }
                    }
                    if (!(original instanceof VariableTask) || (variableMappings = (Set)macroTaskMap.get(name = (variableTask = (VariableTask)original).getName())) == null) continue;
                    for (Object object : variableMappings) {
                        this.addAll(this.copyMap, object, copies);
                    }
                }
                for (Map.Entry entry : performerMacroCopyMap.entrySet()) {
                    EObject key = (EObject)entry.getKey();
                    copies = (Set)entry.getValue();
                    this.addAll(this.copyMap, key, copies);
                    for (EObject eObject : copies) {
                        Set<Object> otherCopies = this.copyMap.get(eObject);
                        if (otherCopies == null) continue;
                        this.addAll(this.copyMap, key, otherCopies);
                    }
                }
                for (Map.Entry entry : argumentBindingMap.entrySet()) {
                    Object argument = entry.getKey();
                    Set bindings = (Set)entry.getValue();
                    for (Object binding : bindings) {
                        Set<Object> copiedBindings = this.copyMap.get(binding);
                        if (copiedBindings == null) continue;
                        for (Object copiedBinding : copiedBindings) {
                            this.add(this.copyMap, argument, AdapterFactoryEditingDomain.unwrap((Object)copiedBinding));
                        }
                    }
                }
                for (SetupTask setupTask : triggeredSetupTasks) {
                    String id = setupTask.getID();
                    if (StringUtil.isEmpty((String)id)) continue;
                    for (EAttribute eAttribute : setupTask.eClass().getEAllAttributes()) {
                        String variableName;
                        VariableTask variable;
                        if (eAttribute == SetupPackage.Literals.SETUP_TASK__ID || eAttribute.isMany() || eAttribute.getEType().getInstanceClass() != String.class || (variable = (VariableTask)variablesMap.get(variableName = String.valueOf(id) + "." + ExtendedMetaData.INSTANCE.getName((EStructuralFeature)eAttribute))) == null) continue;
                        this.add(this.inducedIDVariables, setupTask, variable);
                    }
                }
            }
            return result;
        }

        private void gatherMacroChildren(Map<Object, Set<Object>> macroTaskMap, Map<Object, Set<Object>> argumentBindingMap, boolean handleParameters, String id, Object[] children) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.gatherMacroChild(macroTaskMap, argumentBindingMap, handleParameters, id, child);
                ++n2;
            }
        }

        private void gatherMacroChild(Map<Object, Set<Object>> macroTaskMap, Map<Object, Set<Object>> argumentBindingMap, boolean handleParameters, String id, Object object) {
            EObject eObject;
            Object unwrappedObject = AdapterFactoryEditingDomain.unwrap((Object)object);
            if (unwrappedObject instanceof EObject && (eObject = (EObject)unwrappedObject).eResource() != null) {
                this.add(macroTaskMap, eObject, object);
                Object[] children = SetupEditor.this.selectionViewerContentProvider.getChildren(object);
                if (eObject instanceof MacroTask) {
                    MacroTask macroTask = (MacroTask)eObject;
                    String macroTaskID = macroTask.getID();
                    if (macroTaskID != null) {
                        String qualifiedTaskID = id == null ? macroTaskID : String.valueOf(id) + "*" + macroTaskID;
                        this.gatherMacroChildren(macroTaskMap, argumentBindingMap, false, qualifiedTaskID, children);
                    }
                } else if (eObject instanceof Parameter) {
                    Parameter parameter = (Parameter)eObject;
                    String parameterName = parameter.getName();
                    String qualifiedParameterName = SetupTaskPerformer.createQualifiedName((String)id, (String)parameterName);
                    Set<Object> argumentBindings = macroTaskMap.get(qualifiedParameterName);
                    if (argumentBindings != null) {
                        this.addAll(argumentBindingMap, object, argumentBindings);
                    }
                    this.add(macroTaskMap, qualifiedParameterName, parameter);
                    this.gatherMacroChildren(macroTaskMap, argumentBindingMap, false, id, children);
                } else if (eObject instanceof Argument) {
                    Argument argument = (Argument)eObject;
                    Parameter parameter = argument.getParameter();
                    if (parameter != null) {
                        String parameterName = parameter.getName();
                        String qualifiedParameterName = SetupTaskPerformer.createQualifiedName((String)id, (String)parameterName);
                        this.add(macroTaskMap, qualifiedParameterName, argument);
                    }
                    this.gatherMacroChildren(macroTaskMap, argumentBindingMap, false, id, children);
                } else {
                    this.gatherMacroChildren(macroTaskMap, argumentBindingMap, eObject instanceof Macro, id, children);
                }
            }
        }

        private <K, V> void add(Map<K, Set<V>> map, K key, V value) {
            Set<V> set = map.get(key);
            if (set == null) {
                set = new LinkedHashSet<V>();
                map.put(key, set);
            }
            set.add(value);
        }

        private <K, V> void addAll(Map<K, Set<V>> map, K key, Set<? extends V> values) {
            Set<V> set = map.get(key);
            if (set == null) {
                set = new LinkedHashSet<V>();
                map.put(key, set);
            }
            set.addAll(values);
        }

        public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
            super.makeContributions(menuManager, toolBarManager, statusLineManager);
            SetupEditor.this.contentOutlineStatusLineManager = statusLineManager;
        }

        public void setActionBars(IActionBars actionBars) {
            super.setActionBars(actionBars);
            IToolBarManager toolBarManager = actionBars.getToolBarManager();
            toolBarManager.add((IAction)this.previewAction);
            toolBarManager.add((IAction)new Action(Messages.SetupEditor_outlinePreviewPage_action_showTasksForAllTriggers, 8){
                {
                    this.setChecked(true);
                    this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SetupEditorPlugin.INSTANCE.getImage("AllTrigger")));
                }

                public void run() {
                    OutlinePreviewPage.this.trigger = null;
                    OutlinePreviewPage.this.update(2);
                }
            });
            for (final Trigger trigger : Trigger.VALUES) {
                String label = trigger.getLiteral().toLowerCase();
                toolBarManager.add((IAction)new Action(NLS.bind((String)Messages.SetupEditor_outlinePreviewPage_action_showTasksForTrigger, (Object)label), 8, label){
                    {
                        super($anonymous0, $anonymous1);
                        this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SetupEditorPlugin.INSTANCE.getImage(String.valueOf(StringUtil.cap((String)string)) + "Trigger")));
                    }

                    public void run() {
                        OutlinePreviewPage.this.trigger = trigger;
                        OutlinePreviewPage.this.update(2);
                    }
                });
            }
            SetupEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
        }

        public Object getAdapter(Class adapter) {
            return FindAndReplaceTarget.getAdapter((Class)adapter, (IWorkbenchPart)SetupEditor.this);
        }

        public SetupEditor getSetupEditor() {
            return SetupEditor.this;
        }

        private class OutlineItemProvider
        extends ItemProvider
        implements IWrapperItemProvider,
        IItemPropertySource {
            private final EObject eObject;
            private boolean qualified;

            public OutlineItemProvider(EObject eObject, boolean qualified) {
                super(qualified ? ((Scope)eObject).getQualifiedLabel() : OutlinePreviewPage.this.labelProvider.getText((Object)eObject), (Object)OutlinePreviewPage.this.labelProvider.getImage((Object)eObject));
                this.eObject = eObject;
                this.qualified = qualified;
            }

            public void update() {
                this.setText(this.qualified ? ((Scope)this.eObject).getQualifiedLabel() : OutlinePreviewPage.this.labelProvider.getText((Object)this.eObject));
            }

            public OutlineItemProvider getOutlineItemProvider(EObject eObject) {
                for (Object child : this.getChildren()) {
                    if (!(child instanceof OutlineItemProvider) || ((OutlineItemProvider)((Object)child)).eObject != eObject) continue;
                    return (OutlineItemProvider)((Object)child);
                }
                return null;
            }

            public Object getFont(Object object) {
                if (this.eObject == OutlinePreviewPage.this.compositeStream || this.eObject == OutlinePreviewPage.this.compositeConfiguration || this.eObject == OutlinePreviewPage.this.compositeMacro) {
                    return ITALIC_FONT;
                }
                return super.getFont(object);
            }

            public Object getForeground(Object object) {
                if (this.eObject == OutlinePreviewPage.this.compositeStream || this.eObject == OutlinePreviewPage.this.compositeConfiguration || this.eObject == OutlinePreviewPage.this.compositeMacro) {
                    return COMPOSITE_OUTLINE_COLOR;
                }
                return super.getForeground(object);
            }

            public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
                List descriptors = OutlinePreviewPage.this.itemDelegator.getPropertyDescriptors((Object)this.eObject);
                ArrayList<IItemPropertyDescriptor> result = new ArrayList<IItemPropertyDescriptor>();
                for (IItemPropertyDescriptor descriptor : descriptors) {
                    result.add((IItemPropertyDescriptor)new ItemPropertyDescriptorDecorator((Object)this.eObject, descriptor));
                }
                return result;
            }

            public IItemPropertyDescriptor getPropertyDescriptor(Object object, Object propertyID) {
                IItemPropertyDescriptor descriptor = OutlinePreviewPage.this.itemDelegator.getPropertyDescriptor((Object)this.eObject, propertyID);
                if (descriptor != null) {
                    return new ItemPropertyDescriptorDecorator((Object)this.eObject, descriptor);
                }
                return null;
            }

            public Object getEditableValue(Object object) {
                return OutlinePreviewPage.this.itemDelegator.getEditableValue((Object)this.eObject);
            }

            public Object getValue() {
                return this.eObject;
            }

            public Object getOwner() {
                return this.getParent();
            }

            public EStructuralFeature getFeature() {
                return null;
            }

            public int getIndex() {
                return 0;
            }

            public void setIndex(int index) {
            }
        }

        protected class PreviewAction
        extends Action
        implements ISelectionChangedListener {
            final List<Scope> selectedPeviewableScopes;
            final Map<Scope, Object> scopes;

            public PreviewAction() {
                super(Messages.SetupEditor_outlinePreviewPage_action_previewTriggeredTasks, 2);
                this.selectedPeviewableScopes = new ArrayList<Scope>();
                this.scopes = new LinkedHashMap<Scope, Object>();
                this.setImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SetupEditorPlugin.INSTANCE.getImage("preview.png")));
                ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlineViewer.addPostSelectionChangedListener((ISelectionChangedListener)this);
            }

            public void selectionChanged(SelectionChangedEvent event) {
                this.update((ITreeSelection)event.getSelection());
            }

            protected void update() {
                this.update((ITreeSelection)((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlineViewer.getSelection());
            }

            protected void update(ITreeSelection treeSelection) {
                this.selectedPeviewableScopes.clear();
                this.scopes.clear();
                TreePath[] treePathArray = treeSelection.getPaths();
                int n = treePathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath treePath = treePathArray[n2];
                    Object object = treePath.getLastSegment();
                    Object unwrappedObject = AdapterFactoryEditingDomain.unwrap((Object)object);
                    if (OutlinePreviewPage.this.isPreviewableScope(unwrappedObject)) {
                        Scope scope = (Scope)unwrappedObject;
                        this.selectedPeviewableScopes.add(scope);
                        this.scopes.put(scope, treePath);
                    }
                    ++n2;
                }
                if (this.selectedPeviewableScopes.isEmpty()) {
                    this.setEnabled(false);
                    this.setChecked(false);
                } else {
                    List<Scope> previewableScopes = OutlinePreviewPage.this.getPreviewableScopes();
                    boolean disjoint = Collections.disjoint(this.selectedPeviewableScopes, previewableScopes);
                    this.setEnabled(true);
                    this.setChecked(!disjoint);
                }
            }

            public void run() {
                List<Scope> previewableScopes = OutlinePreviewPage.this.getPreviewableScopes();
                if (!previewableScopes.containsAll(this.selectedPeviewableScopes)) {
                    previewableScopes.addAll(this.selectedPeviewableScopes);
                    OutlinePreviewPage.this.update(2);
                    for (Scope scope : this.selectedPeviewableScopes) {
                        ((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.contentOutlineViewer.setExpandedState(this.scopes.get(scope), true);
                    }
                } else {
                    previewableScopes.removeAll(this.selectedPeviewableScopes);
                    OutlinePreviewPage.this.update(2);
                }
            }
        }

        public class ResourceLocator
        extends ResourceSetImpl.MappedResourceLocator {
            public ResourceLocator(ResourceSet resourceSet) {
                super((ResourceSetImpl)resourceSet);
            }

            public void map(URI normalizedURI, Resource resource) {
                super.map(normalizedURI, resource);
            }

            public void dispose() {
                super.dispose();
            }
        }

        private class VariableContainer
        extends ItemProvider {
            private SetupTaskPerformer setupTaskPerformer;
            private Map<Pair<Object, Object>, IWrapperItemProvider> wrappers;

            public VariableContainer(SetupTaskPerformer setupTaskPerformer, String text, Object image) {
                super(text, image);
                this.wrappers = new LinkedHashMap<Pair<Object, Object>, IWrapperItemProvider>();
                this.setupTaskPerformer = setupTaskPerformer;
            }

            public SetupTaskPerformer getSetupTaskPerformer() {
                return this.setupTaskPerformer;
            }

            public IWrapperItemProvider wrapper(Object variable, Object child) {
                Pair key = Pair.create((Object)variable, (Object)child);
                IWrapperItemProvider wrapper = this.wrappers.get(key);
                if (wrapper == null) {
                    wrapper = new NoChildrenDelegatingWrapperItemProvider(child, variable, (AdapterFactory)((OutlinePreviewPage)OutlinePreviewPage.this).SetupEditor.this.adapterFactory);
                    OutlinePreviewPage.this.add(OutlinePreviewPage.this.inverseCopyMap, wrapper, child);
                    this.wrappers.put((Pair<Object, Object>)key, wrapper);
                }
                return wrapper;
            }
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }

    private static class SetupLocationListener
    extends ColumnViewerInformationControlToolTipSupport.PathLocationListener {
        private static boolean styleSheetInitialized;
        private Browser browser;
        private StyledText noBrowser;
        private Composite content;
        private ToolBar toolBar;
        private ToolItem editTextItem;
        private ToolItem editSetupItem;
        private ToolItem showSetupItem;
        private ToolItem showToolTipsItem;
        private ToolItem liveValidationItem;
        private ToolTipObject toolTipObject;
        private List<ToolTipObject> toolTipObjects = new ArrayList<ToolTipObject>();
        private int toolTipIndex = -1;
        private ToolItem backwardItem;
        private ToolItem forwardItem;
        private ToolItem showAdvancedPropertiesItem;
        private SetupEditor setupEditor;
        private boolean editorSpecific;
        private final Map<SetupEditor, DisposeListener> editorDisposeListeners = new LinkedHashMap<SetupEditor, DisposeListener>();
        private ColumnViewerInformationControlToolTipSupport toolTipSupport;
        private URI mostRecentChangingLocation;
        private Canvas canvas;

        private SetupLocationListener(boolean editorSpecific) {
            super(null);
            this.editorSpecific = editorSpecific;
        }

        public void setToolTipSupport(ColumnViewerInformationControlToolTipSupport toolTipSupport) {
            this.toolTipSupport = toolTipSupport;
            this.initializeCreator();
            this.initializeStyleSheet();
        }

        private void initializeCreator() {
            ReflectUtil.setValue((String)"replacementInformationControlCreator", (Object)this.toolTipSupport, (Object)new AbstractReusableInformationControlCreator(){

                protected IInformationControl doCreateInformationControl(Shell parent) {
                    Color backgroundColor;
                    Object informationControl;
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        String symbolicFont = (String)ReflectUtil.invokeMethod((String)"getSymbolicFont", (Object)toolTipSupport);
                        BrowserInformationControl browserInformationControl = new BrowserInformationControl(parent, symbolicFont, true){

                            protected void createContent(Composite parent) {
                                super.createContent(parent);
                                browser = (Browser)ReflectUtil.getValue((String)"fBrowser", (Object)((Object)this));
                                content = browser;
                                this.createToolBar();
                            }

                            public Rectangle computeTrim() {
                                Rectangle trim = super.computeTrim();
                                trim.height += toolBar.computeSize((int)-1, (int)-1, (boolean)true).y;
                                return trim;
                            }
                        };
                        this.initializeCreator();
                        browserInformationControl.addLocationListener((LocationListener)this);
                        informationControl = browserInformationControl;
                    } else {
                        informationControl = new DefaultInformationControl(parent, null){

                            protected void createContent(Composite parent) {
                                super.createContent(parent);
                                noBrowser = (StyledText)ReflectUtil.getValue((String)"fText", (Object)((Object)this));
                                content = noBrowser;
                                this.createToolBar();
                            }

                            public Rectangle computeTrim() {
                                Rectangle trim = super.computeTrim();
                                trim.height += toolBar.computeSize((int)-1, (int)-1, (boolean)true).y;
                                return trim;
                            }
                        };
                    }
                    Color foregroundColor = (Color)ReflectUtil.getValue((String)"foregroundColor", (Object)toolTipSupport);
                    if (foregroundColor != null) {
                        informationControl.setForegroundColor(foregroundColor);
                    }
                    if ((backgroundColor = (Color)ReflectUtil.getValue((String)"backgroundColor", (Object)toolTipSupport)) != null) {
                        informationControl.setBackgroundColor(backgroundColor);
                    }
                    return informationControl;
                }
            });
        }

        public void createToolBar(Browser browser, StyledText noBrowser) {
            this.browser = browser;
            this.noBrowser = noBrowser;
            this.content = browser == null ? noBrowser : browser;
            this.createToolBar();
        }

        private void createToolBar() {
            Composite parent = this.content.getParent();
            if (this.browser != null) {
                this.applyCookies();
                this.browser.addAuthenticationListener(new AuthenticationListener(){

                    public void authenticate(AuthenticationEvent event) {
                        ECFURIHandlerImpl.AuthorizationHandler.Authorization authorization;
                        if (mostRecentChangingLocation != null && (authorization = SetupCoreUtil.AUTHORIZATION_HANDLER.authorize(mostRecentChangingLocation)).isAuthorized()) {
                            event.user = authorization.getUser();
                            event.password = authorization.getPassword();
                            return;
                        }
                        event.doit = false;
                    }
                });
            }
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            parent.setLayout((Layout)gridLayout);
            GridData controlGridData = new GridData();
            controlGridData.verticalAlignment = 4;
            controlGridData.grabExcessVerticalSpace = true;
            controlGridData.horizontalAlignment = 4;
            controlGridData.grabExcessHorizontalSpace = true;
            this.content.setLayoutData((Object)controlGridData);
            this.toolBar = new ToolBar(parent, 0x800108);
            GridData toolBarGridData = new GridData();
            toolBarGridData.verticalAlignment = 4;
            toolBarGridData.horizontalAlignment = 4;
            toolBarGridData.grabExcessHorizontalSpace = true;
            this.toolBar.setLayoutData((Object)toolBarGridData);
            class NavigationListener
            extends SelectionAdapter {
                private final boolean forward;

                public NavigationListener(boolean forward) {
                    this.forward = forward;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 4) {
                        Rectangle bounds = (this.forward ? SetupLocationListener.this.forwardItem : SetupLocationListener.this.backwardItem).getBounds();
                        Point location = new Point(bounds.x, bounds.y + bounds.height);
                        location = SetupLocationListener.this.toolBar.toDisplay(location);
                        ArrayList<ItemProvider> items = new ArrayList<ItemProvider>();
                        int i = SetupLocationListener.this.toolTipObjects.size() - 1;
                        while (i >= 0) {
                            String text;
                            ToolTipObject wrapper = SetupLocationListener.this.toolTipObjects.get(i);
                            ILabelProvider labelProvider = (ILabelProvider)wrapper.getSetupEditor().selectionViewer.getLabelProvider();
                            Object wrappedObject = wrapper.getWrappedObject();
                            if (wrappedObject instanceof URI) {
                                text = wrappedObject.toString();
                            } else {
                                URI uri = SetupActionBarContributor.getEditURI(wrappedObject, true);
                                if (uri == null) {
                                    text = labelProvider.getText(wrappedObject);
                                } else {
                                    text = uri.toString();
                                    text = labelProvider.getText(wrappedObject);
                                }
                            }
                            Image image = labelProvider.getImage(wrappedObject);
                            items.add(new ItemProvider(text, (Object)image));
                            --i;
                        }
                        int limit = 21;
                        int size = items.size();
                        int index = size - SetupLocationListener.this.toolTipIndex - 1;
                        int start = 0;
                        int end = size;
                        if (size > limit) {
                            start = index - limit / 2 < 0 ? 0 : index - limit / 2;
                            end = start + limit;
                            if (end > size && (start = (end = size) - limit) < 0) {
                                start = 0;
                            }
                        }
                        this.showMenu(items, location, index, start, end, limit);
                    } else if (this.forward) {
                        SetupLocationListener.this.navigate(SetupLocationListener.this.toolTipIndex + 1);
                    } else {
                        SetupLocationListener.this.navigate(SetupLocationListener.this.toolTipIndex - 1);
                    }
                }

                private void showMenu(final List<ItemProvider> items, final Point location, final int index, final int start, final int end, final int limit) {
                    Menu menu = new Menu((Control)SetupLocationListener.this.content.getShell());
                    final int size = items.size();
                    int adjustedStart = start;
                    if (end == size && start > 0) {
                        --adjustedStart;
                    }
                    int adjustedEnd = end;
                    if (start == 0 && end < size) {
                        ++adjustedEnd;
                    }
                    int i = 0;
                    while (i < size) {
                        int count;
                        MenuItem menuItem;
                        if (i < adjustedStart) {
                            if (i == adjustedStart - 1) {
                                menuItem = new MenuItem(menu, 16);
                                count = (adjustedStart + limit - 1) / limit;
                                menuItem.setText(String.valueOf(Messages.SetupEditor_setupLocationListener_menu_forwardMore) + " (" + count + ')');
                                menuItem.setImage(SetupEditorPlugin.INSTANCE.getSWTImage("forward"));
                                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        int newStart = start - limit;
                                        if (newStart < 0) {
                                            newStart = 0;
                                        }
                                        this.showMenu(items, location, index, newStart, newStart + limit, limit);
                                    }
                                });
                            }
                        } else {
                            if (i == adjustedEnd) {
                                menuItem = new MenuItem(menu, 16);
                                count = (size - adjustedEnd + limit - 1) / limit;
                                menuItem.setText(String.valueOf(Messages.SetupEditor_setupLocationListener_menu_backMore) + " (" + count + ')');
                                menuItem.setImage(SetupEditorPlugin.INSTANCE.getSWTImage("backward"));
                                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        int newEnd = end + limit;
                                        if (newEnd > size) {
                                            newEnd = size;
                                        }
                                        this.showMenu(items, location, index, newEnd - limit, newEnd, limit);
                                    }
                                });
                                break;
                            }
                            menuItem = new MenuItem(menu, 16);
                            ItemProvider item = items.get(i);
                            menuItem.setText(item.getText());
                            Image image = (Image)item.getImage();
                            if (image != null) {
                                menuItem.setImage(image);
                            }
                            if (i == index) {
                                menuItem.setSelection(true);
                                menu.setDefaultItem(menuItem);
                            }
                            final int itemIndex = i;
                            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    SetupLocationListener.this.navigate(size - itemIndex - 1);
                                }
                            });
                        }
                        ++i;
                    }
                    menu.setLocation(location.x, location.y);
                    menu.setVisible(true);
                }
            }
            this.backwardItem = this.createItem(4, "backward", Messages.SetupEditor_setupLocationListener_backwardItem_tooltip, (SelectionListener)new NavigationListener(false));
            this.forwardItem = this.createItem(4, "forward", Messages.SetupEditor_setupLocationListener_forwardItem_tooltip, (SelectionListener)new NavigationListener(true));
            new ToolItem(this.toolBar, 2);
            if (this.editorSpecific) {
                this.showSetupItem = this.createItem(8, "locate_value", Messages.SetupEditor_setupLocationListener_showSetupItem_tooltip, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EObject eObject;
                        Resource resource;
                        Object unwrappedObject = ToolTipObject.unwrap(toolTipObject);
                        Object selectionViewerInput = setupEditor.selectionViewer.getInput();
                        if (selectionViewerInput instanceof Resource && unwrappedObject instanceof EObject && (resource = (eObject = (EObject)unwrappedObject).eResource()) != selectionViewerInput) {
                            setupEditor.toggleInput(true);
                        }
                        IStructuredSelection structuredSelection = setupEditor.createSelection(Collections.singletonList(unwrappedObject));
                        setupEditor.selectionViewer.setSelection((ISelection)structuredSelection, true);
                        setupEditor.selectionViewer.getControl().setFocus();
                    }
                });
            }
            this.editSetupItem = this.createItem(8, "edit_setup", Messages.SetupEditor_setupLocationListener_editSetupItem_tooltip, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object unwrappedObject = ToolTipObject.unwrap(toolTipObject);
                    setupEditor.getActionBarContributor().openInSetupEditor(unwrappedObject);
                }
            });
            this.editTextItem = this.createItem(8, "edit_text", Messages.SetupEditor_setupLocationListener_editTextItem_tooltip, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object unwrappedObject = ToolTipObject.unwrap(toolTipObject);
                    setupEditor.getActionBarContributor().openInTextEditor(unwrappedObject);
                }
            });
            this.showAdvancedPropertiesItem = this.createItem(32, "filter_advanced_properties", Messages.SetupEditor_setupLocationListener_showAdvancedPropertiesItem_tooltip, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.navigate(toolTipIndex);
                }
            });
            if (this.editorSpecific) {
                this.createItem(8, "show_properties_view", Messages.SetupEditor_setupLocationListener_showPropertiesViewItem_tooltip, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            setupEditor.getSite().getWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
                        }
                        catch (PartInitException ex) {
                            SetupEditorPlugin.INSTANCE.log(ex);
                        }
                    }
                });
                this.createItem(8, "open_browser", Messages.SetupEditor_setupLocationListener_openInfoBrowserItem_tooltip, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        setupEditor.getActionBarContributor().showInformationBrowser(ToolTipObject.unwrap(toolTipObject));
                    }
                });
                new ToolItem(this.toolBar, 2);
                this.showToolTipsItem = this.createItem(32, "show_tooltips", Messages.SetupEditor_setupLocationListener_showToolTipsItem_tooltip, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean show = showToolTipsItem.getSelection();
                        SetupActionBarContributor.setShowTooltips(show);
                    }
                });
                this.liveValidationItem = this.createItem(32, "live_validation", Messages.SetupEditor_setupLocationListener_liveValidationItem_tooltip, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean liveValidation = liveValidationItem.getSelection();
                        setupEditor.getActionBarContributor().setLiveValidation(liveValidation);
                    }
                });
            }
        }

        private void initializeStyleSheet() {
            if (!styleSheetInitialized) {
                styleSheetInitialized = true;
            }
        }

        protected void setEditor(SetupEditor setupEditor) {
            DisposeListener disposeListener;
            this.setupEditor = setupEditor;
            if (!this.editorSpecific && setupEditor != null && (disposeListener = this.editorDisposeListeners.get((Object)setupEditor)) == null) {
                disposeListener = new DisposeListener(){
                    private SetupEditor setupEditor;
                    {
                        this.setupEditor = setupLocationListener.setupEditor;
                    }

                    public void widgetDisposed(DisposeEvent e) {
                        editorDisposeListeners.remove((Object)this.setupEditor);
                        int index = 0;
                        int count = 0;
                        Iterator<ToolTipObject> it = toolTipObjects.iterator();
                        while (it.hasNext()) {
                            ToolTipObject wrapper = it.next();
                            if (wrapper.getSetupEditor() == this.setupEditor) {
                                it.remove();
                                if (index < toolTipIndex) {
                                    ++count;
                                }
                            }
                            ++index;
                        }
                        toolTipIndex -= count;
                        this.navigate(toolTipObjects.size() == 0 ? -1 : toolTipIndex);
                    }
                };
                setupEditor.getContainer().addDisposeListener(disposeListener);
                this.editorDisposeListeners.put(setupEditor, disposeListener);
            }
        }

        public void setToolTipObject(Object toolTipObject, SetupEditor setupEditor, ColumnViewerInformationControlToolTipSupport toolTipSupport) {
            this.toolTipObject = new ToolTipObject(toolTipObject, this, setupEditor, false, false);
            this.setEditor(setupEditor);
            this.setToolTipSupport(toolTipSupport);
            this.toolTipObjects = new ArrayList<ToolTipObject>(this.toolTipObjects.subList(0, this.toolTipIndex + 1));
            if (this.toolTipIndex == -1 || this.toolTipObjects.get(this.toolTipIndex).getWrappedObject() != toolTipObject) {
                this.toolTipObjects.add(this.toolTipObject);
                this.toolTipIndex = this.toolTipObjects.size() - 1;
            }
        }

        private void updateEnablement() {
            this.backwardItem.setEnabled(this.toolTipIndex > 0);
            this.forwardItem.setEnabled(this.toolTipIndex + 1 < this.toolTipObjects.size());
            Object unwrappedToolTipObject = ToolTipObject.unwrap(this.toolTipObject);
            this.editSetupItem.setEnabled(SetupActionBarContributor.getEditURI(unwrappedToolTipObject, !this.editorSpecific) != null);
            boolean enabled = SetupActionBarContributor.getEditURI(unwrappedToolTipObject, true) != null;
            this.editTextItem.setEnabled(enabled);
            if (this.editorSpecific) {
                this.showSetupItem.setEnabled(enabled);
                this.showToolTipsItem.setSelection(SetupActionBarContributor.isShowTooltips());
                this.liveValidationItem.setSelection(this.setupEditor.getActionBarContributor().isLiveValidation());
            }
        }

        public void changed(LocationEvent event) {
            String url;
            if (this.canvas != null) {
                this.canvas.dispose();
                this.canvas = null;
                GridData gridData = (GridData)this.content.getLayoutData();
                gridData.exclude = false;
                this.content.getParent().layout();
            }
            if (this.browser != null && !"about:blank".equals(url = this.browser.getUrl())) {
                URI uri = URI.createURI((String)event.location);
                uri = ECFURIHandlerImpl.transform((URI)uri, null);
                if (this.toolTipIndex >= 0 && this.toolTipIndex < this.toolTipObjects.size() && !this.toolTipObjects.get(this.toolTipIndex).getWrappedObject().toString().equals(url)) {
                    this.setToolTipObject(URI.createURI((String)url), this.setupEditor, this.toolTipSupport);
                    this.toolTipIndex = this.toolTipObjects.size() - 1;
                    this.updateEnablement();
                }
            }
        }

        public void changing(LocationEvent event) {
            URI originalURI = URI.createURI((String)event.location);
            if (OS.INSTANCE.isMac()) {
                String fragment;
                String query;
                if (originalURI.trimQuery().isCurrentDocumentReference()) {
                    originalURI = URI.createURI((String)("about:blank" + originalURI));
                }
                if ((query = originalURI.query()) != null) {
                    originalURI = originalURI.trimQuery().appendQuery(query.replace("%5B", "[").replaceAll("%5D", "]"));
                }
                if ((fragment = originalURI.fragment()) != null) {
                    originalURI = originalURI.trimFragment().appendFragment(fragment.replace("%5B", "[").replaceAll("%5D", "]"));
                }
            }
            URI uri = originalURI;
            LinkedHashMap options = new LinkedHashMap();
            uri = ECFURIHandlerImpl.transform((URI)uri, options);
            event.location = uri.toString();
            this.mostRecentChangingLocation = uri;
            Object source = event.getSource();
            if (source instanceof Composite) {
                this.content = (Composite)source;
                if (this.content instanceof Browser) {
                    this.browser = (Browser)this.content;
                } else if (this.content instanceof StyledText) {
                    this.noBrowser = (StyledText)this.content;
                }
                if (this.setupEditor != null) {
                    ToolTipObject extendedWrapper;
                    ToolTipObject wrapper;
                    URI trimmedURI;
                    ResourceSet resourceSet = this.setupEditor.editingDomain.getResourceSet();
                    Resource resource = resourceSet.getResource(trimmedURI = uri.trimFragment(), false);
                    if (resource == null) {
                        for (Object value : resourceSet.getPackageRegistry().values()) {
                            EPackage ePackage;
                            if (!(value instanceof EPackage) || !(ePackage = (EPackage)value).eResource().getURI().equals(trimmedURI)) continue;
                            resource = ePackage.eResource();
                            break;
                        }
                    }
                    Resource selection = resource;
                    if (resource != null) {
                        EObject eObject;
                        String fragment = uri.fragment();
                        if (fragment != null && (eObject = resource.getEObject(fragment)) != null) {
                            selection = eObject;
                        }
                        this.setSelection(selection);
                        event.doit = false;
                    }
                    if (event.doit && "path".equals(uri.scheme())) {
                        this.viewer = this.setupEditor.selectionViewer;
                        super.changing(event);
                    }
                    if (event.location.equals("about:blank")) {
                        if (OS.INSTANCE.isMac()) {
                            UIUtil.asyncExec((Control)this.browser, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    content.getDisplay().readAndDispatch();
                                }
                            });
                        }
                    } else if (event.location.startsWith("about:blank#")) {
                        event.doit = false;
                    } else if ("about:blank?extend".equals(event.location)) {
                        wrapper = this.toolTipObjects.get(this.toolTipIndex);
                        extendedWrapper = new ToolTipObject(wrapper.getWrappedObject(), this, wrapper.getSetupEditor(), true, false);
                        this.toolTipObjects.set(this.toolTipIndex, extendedWrapper);
                        this.navigate(this.toolTipIndex);
                        event.doit = false;
                    } else if ("about:blank?no-extend".equals(event.location)) {
                        wrapper = this.toolTipObjects.get(this.toolTipIndex);
                        extendedWrapper = new ToolTipObject(wrapper.getWrappedObject(), this, wrapper.getSetupEditor(), false, false);
                        this.toolTipObjects.set(this.toolTipIndex, extendedWrapper);
                        this.navigate(this.toolTipIndex);
                        event.doit = false;
                    } else if ("property".equals(uri.scheme())) {
                        wrapper = this.toolTipObjects.get(this.toolTipIndex);
                        this.setupEditor.getActionBarContributor().openInPropertiesView(wrapper.getSetupEditor(), wrapper.getWrappedObject(), URI.decode((String)uri.segment(0)));
                        event.doit = false;
                    } else if (!originalURI.equals(uri)) {
                        if (this.browser != null) {
                            this.browser.setUrl(uri.toString());
                        }
                        event.doit = false;
                    }
                }
                this.updateEnablement();
            }
        }

        private void applyCookies() {
            List<java.net.URI> uris = ECFURIHandlerImpl.COOKIE_STORE.getURIs();
            for (java.net.URI cookieURI : uris) {
                String url = cookieURI.toString();
                for (HttpCookie httpCookie : ECFURIHandlerImpl.COOKIE_STORE.get(cookieURI)) {
                    Browser.setCookie((String)httpCookie.getValue(), (String)url);
                }
            }
        }

        private ToolItem createItem(int style, String imageKey, String toolTipText, SelectionListener selectionListener) {
            ToolItem toolItem = new ToolItem(this.toolBar, style);
            toolItem.setImage(SetupEditorPlugin.INSTANCE.getSWTImage(imageKey));
            toolItem.setToolTipText(toolTipText);
            toolItem.addSelectionListener(selectionListener);
            return toolItem;
        }

        private String getFullHTML(String text) {
            if (this.setupEditor == null) {
                return text;
            }
            String styleSheet = this.toolTipSupport.getStyleSheet();
            String symbolicFont = (String)ReflectUtil.invokeMethod((String)"getSymbolicFont", (Object)this.toolTipSupport);
            FontData fontData = JFaceResources.getFontRegistry().getFontData(symbolicFont)[0];
            styleSheet = HTMLPrinter.convertTopLevelFont((String)styleSheet, (FontData)fontData);
            Color foregroundColor = this.content.getForeground();
            Color backgroundColor = this.content.getBackground();
            StringBuffer result = new StringBuffer(text);
            HTMLPrinter.insertPageProlog((StringBuffer)result, (int)0, (RGB)(foregroundColor == null ? null : foregroundColor.getRGB()), (RGB)(backgroundColor == null ? null : backgroundColor.getRGB()), (String)styleSheet);
            HTMLPrinter.addPageEpilog((StringBuffer)result);
            return result.toString();
        }

        protected void navigate(int index) {
            if (index == -1) {
                this.setEditor(null);
                this.toolTipObject = null;
                this.toolTipIndex = -1;
                this.setText(Messages.SetupEditor_setupLocationListener_noHistory);
            } else {
                List<ToolTipObject> toolTipObjects = this.toolTipObjects;
                this.toolTipObject = toolTipObjects.get(index);
                this.setEditor(this.toolTipObject.getSetupEditor());
                Object wrappedObject = this.toolTipObject.getWrappedObject();
                if (wrappedObject instanceof URI) {
                    if (this.browser != null) {
                        this.browser.setUrl(wrappedObject.toString());
                    }
                } else {
                    CellLabelProvider toolTipProvider = (CellLabelProvider)this.setupEditor.selectionViewer.getLabelProvider();
                    String toolTipText = toolTipProvider.getToolTipText((Object)new ToolTipObject(this.toolTipObject, this.showAdvancedPropertiesItem.getSelection()));
                    this.setText(toolTipText);
                }
                this.toolTipObjects = toolTipObjects;
                this.toolTipIndex = index;
            }
            this.backwardItem.setEnabled(this.toolTipIndex > 0);
            this.forwardItem.setEnabled(this.toolTipIndex + 1 < this.toolTipObjects.size());
        }

        protected void setText(String text) {
            if (!StringUtil.isEmpty((String)text)) {
                if (this.browser != null) {
                    this.browser.setText(this.getFullHTML(text), true);
                    if (!OS.INSTANCE.isWin() && this.canvas == null) {
                        Composite parent = this.browser.getParent();
                        GridData gridData = (GridData)this.browser.getLayoutData();
                        gridData.exclude = true;
                        this.canvas = new Canvas(parent, 0);
                        GridData canvasGridData = new GridData();
                        canvasGridData.verticalAlignment = 4;
                        canvasGridData.grabExcessVerticalSpace = true;
                        canvasGridData.horizontalAlignment = 4;
                        canvasGridData.grabExcessHorizontalSpace = true;
                        this.canvas.moveAbove((Control)this.browser);
                        this.canvas.setLayoutData((Object)canvasGridData);
                        this.canvas.setBackground(this.browser.getBackground());
                        parent.layout();
                    }
                } else {
                    HTMLTextPresenter htmlTextPresenter = new HTMLTextPresenter(false);
                    TextPresentation textPresentation = new TextPresentation();
                    String updatePresentation = htmlTextPresenter.updatePresentation((Drawable)this.noBrowser, text, textPresentation, Integer.MAX_VALUE, Integer.MAX_VALUE);
                    this.noBrowser.setText(updatePresentation);
                    TextPresentation.applyTextPresentation((TextPresentation)textPresentation, (StyledText)this.noBrowser);
                }
            }
        }

        protected void setSelection(Object object) {
            CellLabelProvider toolTipProvider = (CellLabelProvider)this.setupEditor.selectionViewer.getLabelProvider();
            String toolTipText = toolTipProvider.getToolTipText((Object)new ToolTipObject(object, this, this.setupEditor, false, this.showAdvancedPropertiesItem.getSelection()));
            this.setText(toolTipText);
        }

        public void dispose() {
            for (Map.Entry<SetupEditor, DisposeListener> entry : this.editorDisposeListeners.entrySet()) {
                entry.getKey().getContainer().removeDisposeListener(entry.getValue());
            }
        }
    }

    private static final class ToolTipObject {
        private final Object wrappedObject;
        private final SetupLocationListener locationListener;
        private final SetupEditor setupEditor;
        private final boolean extended;
        private final boolean showAdvancedProperties;

        public ToolTipObject(Object wrappedObject, SetupLocationListener locationListener, SetupEditor setupEditor, boolean extended, boolean showAdvancedProperties) {
            this.wrappedObject = wrappedObject;
            this.locationListener = locationListener;
            this.setupEditor = setupEditor;
            this.extended = extended;
            this.showAdvancedProperties = showAdvancedProperties;
        }

        public ToolTipObject(ToolTipObject toolTipObject, boolean showAdvancedProperties) {
            this.wrappedObject = toolTipObject.wrappedObject;
            this.locationListener = toolTipObject.locationListener;
            this.setupEditor = toolTipObject.setupEditor;
            this.extended = toolTipObject.extended;
            this.showAdvancedProperties = showAdvancedProperties;
        }

        public Object getWrappedObject() {
            return this.wrappedObject;
        }

        public SetupLocationListener getLocationListener() {
            return this.locationListener;
        }

        public SetupEditor getSetupEditor() {
            return this.setupEditor;
        }

        public boolean isExtended() {
            return this.extended;
        }

        public boolean isShowAdvancedProperties() {
            return this.showAdvancedProperties;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " -> " + this.wrappedObject;
        }

        public static Object unwrap(Object object) {
            if (object instanceof ToolTipObject) {
                return ((ToolTipObject)object).getWrappedObject();
            }
            return object;
        }
    }
}

