/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.P2Package;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.RequirementType;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementItemProvider
extends ModelElementItemProvider {
    public static final String NAMESPACE_PACKAGE_ID = "java.package";

    public RequirementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addNamespacePropertyDescriptor(object);
            this.addVersionRangePropertyDescriptor(object);
            this.addOptionalPropertyDescriptor(object);
            this.addFilterPropertyDescriptor(object);
            this.addTypePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_name_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNamespacePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_namespace_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_namespace_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__NAMESPACE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addVersionRangePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_versionRange_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_versionRange_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__VERSION_RANGE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addOptionalPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_optional_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_optional_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__OPTIONAL, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addFilterPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_filter_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_filter_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__FILTER, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Requirement_type_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Requirement_type_feature", "_UI_Requirement_type"), (EStructuralFeature)P2Package.Literals.REQUIREMENT__TYPE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public void setPropertyValue(Object object, Object value) {
                RequirementType newType;
                EditingDomain domain = this.getEditingDomain(object);
                Requirement requirement = (Requirement)object;
                RequirementType type = requirement.getType();
                if (type != (newType = (RequirementType)value)) {
                    String name = requirement.getName();
                    switch (type) {
                        case NONE: {
                            break;
                        }
                        case FEATURE: {
                            name = name.substring(0, name.length() - ".feature.group".length());
                            break;
                        }
                        case PROJECT: {
                            name = name.substring(0, name.length() - ".plain.project".length());
                        }
                    }
                    switch (newType) {
                        case NONE: {
                            break;
                        }
                        case FEATURE: {
                            name = String.valueOf(name) + ".feature.group";
                            break;
                        }
                        case PROJECT: {
                            name = String.valueOf(name) + ".plain.project";
                        }
                    }
                    if (domain == null) {
                        requirement.setName(name);
                    } else {
                        domain.getCommandStack().execute(SetCommand.create((EditingDomain)domain, (Object)object, (Object)P2Package.Literals.REQUIREMENT__NAME, (Object)name));
                    }
                }
            }

            public Collection<?> getChoiceOfValues(Object object) {
                Requirement requirement = (Requirement)object;
                String name = requirement.getName();
                if (StringUtil.isEmpty((String)name)) {
                    return Collections.singleton(RequirementType.NONE);
                }
                return RequirementType.VALUES;
            }
        });
    }

    protected Collection<?> filterAlternatives(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> alternatives) {
        return super.filterAlternatives(domain, owner, location, operations, operation, RequirementItemProvider.filterAlternatives(alternatives));
    }

    public static Collection<?> filterAlternatives(Collection<?> alternatives) {
        ArrayList result = new ArrayList();
        for (Object object : alternatives) {
            if (object instanceof Requirement) {
                Version minimum;
                Requirement requirement = (Requirement)object;
                String namespace = requirement.getNamespace();
                if ("osgi.bundle".equals(namespace)) {
                    requirement.setNamespace("org.eclipse.equinox.p2.iu");
                } else if (!"org.eclipse.equinox.p2.iu".equals(namespace) && !NAMESPACE_PACKAGE_ID.equals(namespace)) continue;
                VersionRange versionRange = requirement.getVersionRange();
                if (versionRange != null && (minimum = versionRange.getMinimum()).toString().endsWith(".qualifier")) {
                    VersionRange minimumVersionRange = P2Factory.eINSTANCE.createVersionRange(minimum, VersionSegment.MICRO);
                    requirement.setVersionRange(minimumVersionRange);
                }
            }
            result.add(object);
        }
        return result;
    }

    protected Collection<?> filterChoices(Collection<?> choices, EStructuralFeature feature, Object object) {
        if (feature == P2Package.Literals.REQUIREMENT__NAMESPACE) {
            return Arrays.asList("org.eclipse.equinox.p2.iu", NAMESPACE_PACKAGE_ID);
        }
        return super.filterChoices(choices, feature, object);
    }

    public Object getImage(Object object) {
        String key = "full/obj16/Requirement";
        Requirement requirement = (Requirement)object;
        String namespace = requirement.getNamespace();
        if ("org.eclipse.equinox.p2.iu".equals(namespace)) {
            if ("*".equals(requirement.getName())) {
                key = String.valueOf(key) + "_AllSources";
            } else {
                switch (requirement.getType()) {
                    case NONE: {
                        key = String.valueOf(key) + "_Plugin";
                        break;
                    }
                    case FEATURE: {
                        key = String.valueOf(key) + "_Feature";
                        break;
                    }
                    case PROJECT: {
                        key = String.valueOf(key) + "_Project";
                    }
                }
            }
        } else if (NAMESPACE_PACKAGE_ID.equals(namespace)) {
            key = String.valueOf(key) + "_Package";
        }
        Object result = this.overlayImage(object, this.getResourceLocator().getImage(key));
        if (requirement.isOptional()) {
            ArrayList<Object> images = new ArrayList<Object>(2);
            images.add(result);
            images.add(this.getResourceLocator().getImage("full/ovr16/optional"));
            result = new OptionalImage(images);
        }
        return result;
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        Requirement requirement = (Requirement)object;
        String name = requirement.getName();
        if (name == null || name.length() == 0) {
            name = this.getString("_UI_Requirement_type");
        } else {
            switch (requirement.getType()) {
                case NONE: {
                    break;
                }
                case FEATURE: {
                    name = name.substring(0, name.length() - ".feature.group".length());
                    break;
                }
                case PROJECT: {
                    name = name.substring(0, name.length() - ".plain.project".length());
                }
            }
        }
        VersionRange versionRange = requirement.getVersionRange();
        return String.valueOf(name) + (versionRange == null || VersionRange.emptyRange.equals((Object)versionRange) ? "" : " " + versionRange.toString());
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Requirement.class)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class OptionalImage
    extends ComposedImage {
        private OptionalImage(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            ComposedImage.Point point = new ComposedImage.Point();
            point.x = size.width - 5;
            return Arrays.asList(new ComposedImage.Point(), point);
        }
    }
}

