/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IUpdateableItemParent;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.util.BaseResource;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.setup.CatalogSelection;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.provider.CatalogSelectionItemProvider;
import org.eclipse.oomph.setup.provider.IndexItemProvider;
import org.eclipse.oomph.setup.provider.ProjectCatalogItemProvider;
import org.eclipse.oomph.setup.provider.ProjectItemProvider;
import org.eclipse.oomph.setup.provider.SetupItemProviderAdapterFactory;
import org.eclipse.oomph.setup.provider.WorkspaceItemProvider;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.ToolTipLabelProvider;
import org.eclipse.oomph.setup.ui.wizards.CatalogSelector;
import org.eclipse.oomph.setup.ui.wizards.FilteredTreeWithoutWorkbench;
import org.eclipse.oomph.setup.ui.wizards.ProductPage;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.ui.ButtonAnimator;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class ProjectPage
extends SetupWizardPage {
    private final Set<URI> existingStreams = new HashSet<URI>();
    private ComposedAdapterFactory adapterFactory;
    private ToolTipLabelProvider labelProvider;
    private CatalogSelector catalogSelector;
    private TreeViewer projectViewer;
    private TableViewer streamViewer;
    private AddButtonAnimator addButtonAnimator;
    private boolean projectsChanged;
    private boolean inactive;

    public ProjectPage() {
        super("ProjectPage");
        this.setTitle("Projects");
        this.setDescription("Double click the projects you want to provision, and for each choose its stream in the table column.");
    }

    protected Control createUI(Composite parent) {
        CatalogManager catalogManager = this.getCatalogManager();
        this.catalogSelector = new CatalogSelector(catalogManager, false);
        this.adapterFactory = new ComposedAdapterFactory((AdapterFactory)this.getAdapterFactory());
        this.adapterFactory.insertAdapterFactory((AdapterFactory)new ItemProviderAdapterFactory(this.catalogSelector.getSelection()));
        BaseEditUtil.replaceReflectiveItemProvider((ComposedAdapterFactory)this.adapterFactory);
        Workspace workspace = this.getWorkspace();
        if (workspace != null) {
            for (Stream stream : workspace.getStreams()) {
                this.existingStreams.add(EcoreUtil.getURI((EObject)stream));
            }
        }
        ResourceSet resourceSet = this.getResourceSet();
        final AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)new BasicCommandStack(){

            public void execute(Command command) {
                super.execute(command);
                final Collection affectedObjects = command.getAffectedObjects();
                UIUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        ProjectPage.this.projectViewer.setSelection((ISelection)new StructuredSelection(affectedObjects.toArray()), true);
                    }
                });
            }
        }, resourceSet);
        SashForm sashForm = new SashForm(parent, 66048);
        Composite upperComposite = new Composite((Composite)sashForm, 0);
        upperComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        Composite filterComposite = new Composite(upperComposite, 0);
        filterComposite.setLayout((Layout)UIUtil.createGridLayout((int)2));
        filterComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite filterPlaceholder = new Composite(filterComposite, 0);
        filterPlaceholder.setLayout((Layout)UIUtil.createGridLayout((int)1));
        filterPlaceholder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar filterToolBar = new ToolBar(filterComposite, 0x820000);
        ToolItem addProjectButton = new ToolItem(filterToolBar, 0);
        addProjectButton.setToolTipText("Add user projects");
        addProjectButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("add_project"));
        AccessUtil.setKey((Widget)addProjectButton, (Object)"addProject");
        final HashSet projectCatalogs = new HashSet();
        addProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddUserProjectDialog dialog = new AddUserProjectDialog(ProjectPage.this.getShell(), projectCatalogs, ProjectPage.this.catalogSelector, editingDomain);
                dialog.open();
            }
        });
        final ToolItem removeProjectButton = new ToolItem(filterToolBar, 0);
        removeProjectButton.setToolTipText("Remove the selected user projects");
        removeProjectButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("remove_project"));
        removeProjectButton.setEnabled(false);
        AccessUtil.setKey((Widget)removeProjectButton, (Object)"removeProject");
        final ArrayList projects = new ArrayList();
        final ArrayList userProjects = new ArrayList();
        final SelectionAdapter removeProjectSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Workspace workspace = ProjectPage.this.getWorkspace();
                ArrayList<Stream> streamsToRemove = new ArrayList<Stream>();
                UniqueEList parents = new UniqueEList();
                block0: for (Project project : userProjects) {
                    Project parentProject = project.getParentProject();
                    parentProject.getProjects().remove((Object)project);
                    parents.add(parentProject);
                    if (workspace == null) continue;
                    EList streams = project.getStreams();
                    for (Stream stream : workspace.getStreams()) {
                        if (!streams.contains((Object)stream)) continue;
                        streamsToRemove.add(stream);
                        continue block0;
                    }
                }
                for (Project parent : parents) {
                    BaseUtil.saveEObject((EObject)parent);
                }
                if (!streamsToRemove.isEmpty()) {
                    ProjectPage.this.streamViewer.setSelection((ISelection)new StructuredSelection(streamsToRemove));
                    ProjectPage.this.removeSelectedStreams();
                }
                ProjectPage.this.projectViewer.setSelection((ISelection)new StructuredSelection((List)parents));
            }
        };
        removeProjectButton.addSelectionListener((SelectionListener)removeProjectSelectionAdapter);
        ToolItem collapseAllButton = new ToolItem(filterToolBar, 0);
        collapseAllButton.setToolTipText("Collapse All");
        collapseAllButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("collapse-all"));
        AccessUtil.setKey((Widget)collapseAllButton, (Object)"collapse");
        ToolItem catalogsButton = new ToolItem(filterToolBar, 4);
        catalogsButton.setToolTipText("Select Catalogs");
        catalogsButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("catalogs"));
        this.catalogSelector.configure(catalogsButton);
        AccessUtil.setKey((Widget)catalogsButton, (Object)"catalogs");
        final FilteredTreeWithoutWorkbench filteredTree = new FilteredTreeWithoutWorkbench(upperComposite, 2050);
        Control filterControl = filteredTree.getChildren()[0];
        filterControl.setParent(filterPlaceholder);
        AccessUtil.setKey((Widget)filteredTree.getFilterControl(), (Object)"filter");
        this.projectViewer = filteredTree.getViewer();
        this.labelProvider = new ToolTipLabelProvider(this.adapterFactory){
            private final Font baseFont;
            {
                this.baseFont = ProjectPage.this.projectViewer.getControl().getFont();
            }

            public Font getFont(Object object) {
                Project project;
                if (object instanceof Project && ProjectPage.this.isSelected(project = (Project)object)) {
                    return ExtendedFontRegistry.INSTANCE.getFont(this.baseFont, (Object)IItemFontProvider.BOLD_FONT);
                }
                return super.getFont(object);
            }

            public String getToolTipText(Object element) {
                if (element instanceof Project) {
                    Project project = (Project)element;
                    return project.getDescription();
                }
                return "";
            }
        };
        this.projectViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.projectViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.getFeature() == SetupPackage.Literals.CATALOG_SELECTION__PROJECT_CATALOGS) {
                    ProjectPage.this.getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Object[] elements;
                            try {
                                Job.getJobManager().join(filteredTree.getRefreshJobFamily(), (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (OperationCanceledException operationCanceledException) {
                            }
                            catch (InterruptedException interruptedException) {}
                            if (ProjectPage.this.projectViewer.getExpandedElements().length == 0 && (elements = this.getElements(ProjectPage.this.projectViewer.getInput())).length > 0) {
                                ProjectPage.this.projectViewer.setExpandedState(elements[0], true);
                            }
                        }
                    });
                }
            }
        });
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), URLTransfer.getInstance()};
        this.projectViewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)editingDomain, (Viewer)this.projectViewer){

            protected Collection<?> getDragSource(DropTargetEvent event) {
                URLTransfer urlTransfer = URLTransfer.getInstance();
                if (urlTransfer.isSupportedType(event.currentDataType)) {
                    if (IS_MOTIF) {
                        return null;
                    }
                    Object object = urlTransfer.nativeToJava(event.currentDataType);
                    return object == null ? null : this.extractDragSource(object);
                }
                return super.getDragSource(event);
            }

            protected Collection<?> extractDragSource(Object object) {
                if (object instanceof String) {
                    return Collections.singleton(URI.createURI((String)((String)object)));
                }
                return super.extractDragSource(object);
            }
        });
        new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.projectViewer, new LocationListener(){

            public void changing(LocationEvent event) {
            }

            public void changed(LocationEvent event) {
            }
        });
        Tree projectTree = this.projectViewer.getTree();
        projectTree.setLayoutData((Object)new GridData(1808));
        this.addHelpCallout((Control)projectTree, 1);
        ToolBar bucketToolBar = new ToolBar(upperComposite, 0x1800000);
        bucketToolBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        bucketToolBar.setSize(46, 22);
        final ToolItem addButton = new ToolItem(bucketToolBar, 8);
        addButton.setToolTipText("Add Projects (or double-click in upper tree)");
        addButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("add"));
        addButton.setEnabled(false);
        AccessUtil.setKey((Widget)addButton, (Object)"choose");
        this.addButtonAnimator = new AddButtonAnimator(addButton);
        final ToolItem removeButton = new ToolItem(bucketToolBar, 8);
        removeButton.setToolTipText("Remove Projects (or double-click in lower table)");
        removeButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("remove"));
        removeButton.setEnabled(false);
        AccessUtil.setKey((Widget)removeButton, (Object)"unchoose");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPage.this.addSelectedProjects();
                addButton.setEnabled(false);
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPage.this.removeSelectedStreams();
            }
        });
        Composite lowerComposite = new Composite((Composite)sashForm, 0);
        lowerComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        TableColumnLayout streamTableLayout = new TableColumnLayout();
        Composite streamComposite = new Composite(lowerComposite, 0);
        streamComposite.setLayout((Layout)streamTableLayout);
        streamComposite.setLayoutData((Object)new GridData(1808));
        this.streamViewer = new TableViewer(streamComposite, 67586);
        this.streamViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        Table streamTable = this.streamViewer.getTable();
        streamTable.setLinesVisible(true);
        streamTable.setHeaderVisible(true);
        streamTable.setLayoutData((Object)new GridData(1808));
        this.addHelpCallout((Control)streamTable, 2);
        TableViewerColumn catalogViewerColumn = new TableViewerColumn(this.streamViewer, 0);
        catalogViewerColumn.setLabelProvider((CellLabelProvider)new CatalogColumnLabelProvider());
        TableColumn catalogColumn = catalogViewerColumn.getColumn();
        catalogColumn.setText("Catalog");
        streamTableLayout.setColumnData((Widget)catalogColumn, (ColumnLayoutData)new ColumnWeightData(30, true));
        TableViewerColumn projectViewerColumn = new TableViewerColumn(this.streamViewer, 0);
        projectViewerColumn.setLabelProvider((CellLabelProvider)new ProjectColumnLabelProvider());
        TableColumn projectColumn = projectViewerColumn.getColumn();
        projectColumn.setText("Project");
        streamTableLayout.setColumnData((Widget)projectColumn, (ColumnLayoutData)new ColumnWeightData(40, true));
        TableViewerColumn streamViewerColumn = new TableViewerColumn(this.streamViewer, 0);
        streamViewerColumn.setLabelProvider((CellLabelProvider)new StreamColumnLabelProvider());
        this.hookCellEditor(streamViewerColumn);
        TableColumn streamColumn = streamViewerColumn.getColumn();
        streamColumn.setText("Stream");
        streamTableLayout.setColumnData((Widget)streamColumn, (ColumnLayoutData)new ColumnWeightData(30, true));
        CatalogSelection selection = this.catalogSelector.getSelection();
        this.projectViewer.setInput((Object)selection);
        if (workspace != null) {
            Iterator it = workspace.getStreams().iterator();
            while (it.hasNext()) {
                Stream stream = (Stream)it.next();
                if (!stream.eIsProxy()) continue;
                it.remove();
            }
        }
        this.streamViewer.setInput((Object)workspace);
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPage.this.projectViewer.collapseAll();
            }
        });
        this.projectViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                projects.clear();
                userProjects.clear();
                projectCatalogs.clear();
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    if (value instanceof Project) {
                        Project project = (Project)value;
                        projects.add(project);
                        projectCatalogs.add(project.getProjectCatalog());
                        this.addRootUserProject(project);
                    } else if (value instanceof ProjectCatalog) {
                        ProjectCatalog projectCatalog = (ProjectCatalog)value;
                        projectCatalogs.add(projectCatalog);
                    }
                    ++n2;
                }
                removeProjectButton.setEnabled(!userProjects.isEmpty());
                Workspace workspace = ProjectPage.this.getWorkspace();
                ArrayList projectsToAdd = new ArrayList(projects);
                if (workspace != null) {
                    for (Stream stream : workspace.getStreams()) {
                        projectsToAdd.remove(stream.getProject());
                    }
                }
                for (Project project : projectsToAdd) {
                    if (project.getStreams().isEmpty()) continue;
                    addButton.setEnabled(true);
                    return;
                }
                addButton.setEnabled(false);
            }

            protected void addRootUserProject(Project project) {
                Project parentProject = project.getParentProject();
                if (parentProject != null) {
                    Resource resource = parentProject.eResource();
                    if (resource != null && SetupContext.isUserScheme((String)resource.getURI().scheme())) {
                        userProjects.add(project);
                    } else {
                        this.addRootUserProject(project.getParentProject());
                    }
                }
            }
        });
        this.projectViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ProjectPage.this.projectViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof Project) {
                    Project project = (Project)element;
                    Workspace workspace = ProjectPage.this.getWorkspace();
                    if (workspace != null) {
                        for (Stream stream : workspace.getStreams()) {
                            if (stream.getProject() != project) continue;
                            ProjectPage.this.streamViewer.setSelection((ISelection)new StructuredSelection((Object)stream));
                            ProjectPage.this.removeSelectedStreams();
                            return;
                        }
                    }
                    if (!project.getStreams().isEmpty()) {
                        ProjectPage.this.addSelectedProjects();
                        addButton.setEnabled(false);
                        return;
                    }
                }
                boolean expanded = ProjectPage.this.projectViewer.getExpandedState(element);
                ProjectPage.this.projectViewer.setExpandedState(element, !expanded);
            }
        });
        this.projectViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\u007f') {
                    ArrayList<Stream> selectedProjectStreams = new ArrayList<Stream>();
                    Workspace workspace = ProjectPage.this.getWorkspace();
                    if (workspace != null) {
                        for (Stream stream : workspace.getStreams()) {
                            Project project = stream.getProject();
                            if (!projects.contains(project)) continue;
                            selectedProjectStreams.add(stream);
                        }
                    }
                    if (selectedProjectStreams.isEmpty()) {
                        if (removeProjectButton.isEnabled()) {
                            removeProjectSelectionAdapter.widgetSelected(null);
                        }
                    } else {
                        ProjectPage.this.streamViewer.setSelection((ISelection)new StructuredSelection(selectedProjectStreams));
                        ProjectPage.this.removeSelectedStreams();
                    }
                } else if (event.keyCode == 0x1000009 && addButton.isEnabled()) {
                    ProjectPage.this.addSelectedProjects();
                    addButton.setEnabled(false);
                }
            }
        });
        this.streamViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.streamViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectPage.this.removeSelectedStreams();
            }
        });
        this.streamViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\u007f' && removeButton.isEnabled()) {
                    ProjectPage.this.removeSelectedStreams();
                } else if (event.keyCode == 0x1000009 && addButton.isEnabled()) {
                    ProjectPage.this.addSelectedProjects();
                }
            }
        });
        this.checkPageComplete();
        sashForm.setWeights(new int[]{3, 1});
        return sashForm;
    }

    protected void checkPageComplete() {
        Workspace workspace = this.getWorkspace();
        this.setPageComplete(this.getPreviousPage() instanceof ProductPage || workspace != null && workspace.getStreams().size() > this.existingStreams.size());
    }

    protected void handleInactivity(Display display, boolean inactive) {
        this.inactive = inactive;
        if (this.addButtonAnimator.shouldAnimate()) {
            display.asyncExec((Runnable)((Object)this.addButtonAnimator));
        }
    }

    public void enterPage(boolean forward) {
        if (forward) {
            if (SetupPropertyTester.getHandlingShell() != this.getShell()) {
                this.setErrorMessage("Another setup wizard is already open.  Complete that interaction before importing projects.");
                this.projectViewer.getTree().setEnabled(false);
            } else if (this.projectViewer.getSelection().isEmpty()) {
                CatalogSelection selection = this.catalogSelector.getSelection();
                ArrayList<Project> projects = new ArrayList<Project>();
                for (Stream stream : selection.getSelectedStreams()) {
                    projects.add(stream.getProject());
                }
                this.projectViewer.setSelection((ISelection)new StructuredSelection(projects), true);
            }
        }
    }

    public void sendStats(boolean success) {
        super.sendStats(success);
        Workspace workspace = this.getWizard().getSetupContext().getWorkspace();
        if (workspace != null) {
            ArrayList streams = new ArrayList(workspace.getStreams());
            streams.removeAll(this.existingStreams);
            for (Stream stream : streams) {
                SetupCoreUtil.sendStats((Scope)stream, (boolean)success);
            }
        }
    }

    private void saveProjectStreamSelection(Stream stream) {
        CatalogManager catalogManager = this.catalogSelector.getCatalogManager();
        EMap defaultStreams = catalogManager.getSelection().getDefaultStreams();
        Project project = stream.getProject();
        defaultStreams.put((Object)project, (Object)stream);
        catalogManager.saveSelection();
    }

    private void hookCellEditor(TableViewerColumn viewerColumn) {
        Table table = this.streamViewer.getTable();
        final ComboBoxViewerCellEditor cellEditor = new ComboBoxViewerCellEditor((Composite)table);
        cellEditor.setActivationStyle(3);
        cellEditor.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        cellEditor.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Project project = (Project)inputElement;
                return project.getStreams().toArray();
            }
        });
        viewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.streamViewer){

            protected void setValue(Object element, Object value) {
                EList streams;
                int index;
                Workspace workspace;
                if (element != value && (workspace = ProjectPage.this.getWorkspace()) != null && (index = (streams = workspace.getStreams()).indexOf(element)) != -1) {
                    Stream stream = (Stream)value;
                    streams.set(index, (Object)stream);
                    ProjectPage.this.saveProjectStreamSelection(stream);
                    ProjectPage.this.streamViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                Stream stream = (Stream)element;
                cellEditor.setInput((Object)stream.getProject());
                return cellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.streamViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComboViewer comboViewer = cellEditor.getViewer();
                comboViewer.refresh();
            }
        });
    }

    private boolean isSelected(Project project) {
        Workspace workspace = this.getWorkspace();
        if (workspace != null) {
            for (Stream stream : workspace.getStreams()) {
                if (project != stream.getProject()) continue;
                return true;
            }
        }
        return false;
    }

    private void addSelectedProjects() {
        this.projectsChanged = true;
        ArrayList<Project> addedProjects = new ArrayList<Project>();
        ArrayList<Stream> addedStreams = new ArrayList<Stream>();
        CatalogManager catalogManager = this.catalogSelector.getCatalogManager();
        CatalogSelection catalogSelection = catalogManager.getSelection();
        EMap defaultStreams = catalogSelection.getDefaultStreams();
        IStructuredSelection selection = (IStructuredSelection)this.projectViewer.getSelection();
        for (Object element : selection) {
            Project project;
            EList projectStreams;
            if (!(element instanceof Project) || (projectStreams = (project = (Project)element).getStreams()).isEmpty() || this.isSelected(project)) continue;
            Stream stream = (Stream)defaultStreams.get((Object)project);
            if (stream == null) {
                stream = (Stream)projectStreams.get(0);
            }
            addedStreams.add(stream);
            addedProjects.add(project);
        }
        if (!addedProjects.isEmpty()) {
            Workspace workspace = this.getWorkspace();
            if (workspace == null) {
                this.getWizard().setSetupContext(SetupContext.create((Installation)this.getInstallation(), addedStreams, (User)this.getUser()));
                workspace = this.getWorkspace();
                this.streamViewer.setInput((Object)workspace);
            } else {
                EList workspaceStreams = workspace.getStreams();
                workspaceStreams.addAll(addedStreams);
                this.streamViewer.refresh();
            }
            catalogSelection.getSelectedStreams().clear();
            catalogSelection.getSelectedStreams().addAll((Collection)workspace.getStreams());
            catalogManager.saveSelection();
            this.streamViewer.setSelection((ISelection)new StructuredSelection(addedStreams));
            this.projectViewer.update(addedProjects.toArray(), null);
            this.checkPageComplete();
        }
    }

    private void removeSelectedStreams() {
        this.projectsChanged = true;
        Workspace workspace = this.getWorkspace();
        if (workspace != null) {
            EList workspaceStreams = workspace.getStreams();
            ArrayList<Project> removedProjects = new ArrayList<Project>();
            IStructuredSelection selection = (IStructuredSelection)this.streamViewer.getSelection();
            for (Stream stream : selection) {
                if (this.existingStreams.contains(EcoreUtil.getURI((EObject)stream))) continue;
                workspaceStreams.remove((Object)stream);
                Project project = stream.getProject();
                removedProjects.add(project);
            }
            if (!removedProjects.isEmpty()) {
                this.projectViewer.update(removedProjects.toArray(), null);
                this.projectViewer.setSelection((ISelection)new StructuredSelection(removedProjects));
                CatalogManager catalogManager = this.catalogSelector.getCatalogManager();
                CatalogSelection catalogSelection = catalogManager.getSelection();
                catalogSelection.getSelectedStreams().clear();
                catalogSelection.getSelectedStreams().addAll((Collection)workspace.getStreams());
                catalogManager.saveSelection();
                this.streamViewer.refresh();
                this.checkPageComplete();
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.adapterFactory.dispose();
    }

    private static void createProjectLabel(Project project, StringBuilder builder) {
        Project parentProject = project.getParentProject();
        if (parentProject != null) {
            ProjectPage.createProjectLabel(parentProject, builder);
        }
        if (builder.length() != 0) {
            builder.append(" - ");
        }
        String label = SetupCoreUtil.getLabel((Scope)project);
        builder.append(label);
    }

    private final class AddButtonAnimator
    extends ButtonAnimator {
        public AddButtonAnimator(ToolItem addButton) {
            super((OomphUIPlugin)SetupUIPlugin.INSTANCE, addButton, "add", 7);
        }

        public Shell getShell() {
            IWizardContainer container = ProjectPage.this.getContainer();
            return container == null ? null : container.getShell();
        }

        protected boolean doAnimate() {
            return ProjectPage.this.inactive && !ProjectPage.this.projectsChanged;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddUserProjectDialog
    extends ResourceDialog {
        private final Set<ProjectCatalog> projectCatalogs;
        private final CatalogSelector catalogSelector;
        private final AdapterFactoryEditingDomain editingDomain;
        private ComboViewer catalogViewer;

        public AddUserProjectDialog(Shell parent, Set<ProjectCatalog> projectCatalogs, CatalogSelector catalogSelector, AdapterFactoryEditingDomain editingDomain) {
            super(parent, "Add User Projects", 4098);
            this.projectCatalogs = projectCatalogs;
            this.catalogSelector = catalogSelector;
            this.editingDomain = editingDomain;
        }

        protected Control createDialogArea(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)UIUtil.createGridLayout((int)1));
            main.setLayoutData((Object)new GridData(1808));
            Composite upperComposite = new Composite(main, 0);
            GridLayout upperLayout = new GridLayout(2, false);
            upperLayout.marginTop = 10;
            upperLayout.marginWidth = 10;
            upperComposite.setLayout((Layout)upperLayout);
            upperComposite.setLayoutData((Object)new GridData(1808));
            AddUserProjectDialog.applyDialogFont((Control)upperComposite);
            Label label = new Label(upperComposite, 0);
            label.setText("Catalog:");
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.catalogViewer = new ComboViewer(upperComposite, 8);
            this.catalogViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.catalogViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.catalogViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return SetupCoreUtil.getLabel((Scope)((Scope)element));
                }
            });
            List<? extends Scope> catalogs = this.catalogSelector.getCatalogs();
            this.catalogViewer.setInput(catalogs);
            if (catalogs.size() == 1) {
                this.catalogViewer.setSelection((ISelection)new StructuredSelection((Object)catalogs.get(0)));
            } else if (this.projectCatalogs.size() == 1 && catalogs.containsAll(this.projectCatalogs)) {
                this.catalogViewer.setSelection((ISelection)new StructuredSelection((Object)this.projectCatalogs.iterator().next()));
            }
            this.catalogViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AddUserProjectDialog.this.validate();
                }
            });
            Composite lowerComposite = new Composite(main, 0);
            GridLayout lowerLayout = new GridLayout();
            lowerLayout.marginHeight = 0;
            lowerLayout.marginWidth = 0;
            lowerLayout.verticalSpacing = 0;
            lowerComposite.setLayout((Layout)lowerLayout);
            lowerComposite.setLayoutData((Object)new GridData(1808));
            AddUserProjectDialog.applyDialogFont((Control)lowerComposite);
            parent.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    AddUserProjectDialog.this.validate();
                }
            });
            return super.createDialogArea(lowerComposite);
        }

        protected void prepareBrowseFileSystemButton(Button browseFileSystemButton) {
            browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(AddUserProjectDialog.this.getShell(), AddUserProjectDialog.this.style);
                    fileDialog.setFilterExtensions(new String[]{"*.setup"});
                    fileDialog.open();
                    String filterPath = fileDialog.getFilterPath();
                    String[] fileNames = fileDialog.getFileNames();
                    StringBuffer uris = new StringBuffer();
                    int i = 0;
                    int len = fileNames.length;
                    while (i < len) {
                        uris.append(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileNames[i])).toString());
                        uris.append("  ");
                        ++i;
                    }
                    AddUserProjectDialog.this.uriField.setText((String.valueOf(AddUserProjectDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                }
            });
        }

        protected void prepareBrowseWorkspaceButton(Button browseWorkspaceButton) {
            browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    StringBuffer uris = new StringBuffer();
                    IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)AddUserProjectDialog.this.getShell(), null, null, (boolean)true, (Object[])this.getContextSelection(), Collections.singletonList(new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            if (element instanceof IFile) {
                                IFile file = (IFile)element;
                                return "setup".equals(file.getFileExtension());
                            }
                            return true;
                        }
                    }));
                    int i = 0;
                    int len = files.length;
                    while (i < len) {
                        uris.append(URI.createURI((String)files[i].getLocationURI().toString(), (boolean)true));
                        uris.append("  ");
                        ++i;
                    }
                    AddUserProjectDialog.this.uriField.setText((String.valueOf(AddUserProjectDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                }

                private String getContextPath() {
                    return AddUserProjectDialog.this.context != null && AddUserProjectDialog.this.context.isPlatformResource() ? URI.createURI((String)".").resolve(AddUserProjectDialog.this.context).path().substring(9) : null;
                }

                private Object[] getContextSelection() {
                    IWorkspaceRoot root;
                    IResource resource;
                    String path = this.getContextPath();
                    if (path != null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path)) != null && resource.isAccessible()) {
                        return new Object[]{resource};
                    }
                    return null;
                }
            });
        }

        protected void validate() {
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(this.getSelectedCatalog() != null);
            }
        }

        protected boolean processResources() {
            int invalidProjectsSize;
            ArrayList<Project> validProjects = new ArrayList<Project>();
            ArrayList<Project> invalidProjects = new ArrayList<Project>();
            ArrayList<URI> invalidURIs = new ArrayList<URI>();
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            for (URI uri : this.getURIs()) {
                BaseResource resource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)uri);
                Project project = (Project)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.PROJECT);
                if (project == null) {
                    invalidURIs.add(uri);
                    continue;
                }
                if (project.eContainer() != null) {
                    invalidProjects.add(project);
                    continue;
                }
                validProjects.add(project);
            }
            if (!validProjects.isEmpty()) {
                ProjectCatalog selectedCatalog = this.getSelectedCatalog();
                if (!this.catalogSelector.getSelectedCatalogs().contains(selectedCatalog)) {
                    this.catalogSelector.select((Scope)selectedCatalog, true);
                }
                Command command = DragAndDropCommand.create((EditingDomain)this.editingDomain, (Object)selectedCatalog, (float)0.5f, (int)4, (int)4, validProjects);
                this.editingDomain.getCommandStack().execute(command);
                return true;
            }
            StringBuilder message = new StringBuilder();
            int invalidURIsSize = invalidURIs.size();
            if (invalidURIsSize != 0) {
                if (invalidURIsSize == 1) {
                    message.append("The URI ");
                } else {
                    message.append("The URIs ");
                }
                int i = 0;
                while (i < invalidURIsSize) {
                    if (i != 0) {
                        message.append(", ");
                        if (i + 1 == invalidURIsSize) {
                            message.append(" and ");
                        }
                    }
                    message.append('\'');
                    message.append(invalidURIs.get(i));
                    message.append('\'');
                    ++i;
                }
                if (invalidURIsSize == 1) {
                    message.append(" does not contain a valid project.");
                } else {
                    message.append(" do not contain valid projects.");
                }
            }
            if ((invalidProjectsSize = invalidProjects.size()) != 0) {
                if (message.length() != 0) {
                    message.append("\n\n");
                }
                if (invalidProjectsSize == 1) {
                    message.append("The project ");
                } else {
                    message.append("The projects ");
                }
                int i = 0;
                while (i < invalidProjectsSize) {
                    if (i != 0) {
                        message.append(", ");
                        if (i + 1 == invalidProjectsSize) {
                            message.append(" and ");
                        }
                    }
                    message.append('\'');
                    message.append(((Project)invalidProjects.get(i)).getLabel());
                    message.append('\'');
                    ++i;
                }
                if (invalidProjectsSize == 1) {
                    message.append(" is already contained in the index.");
                } else {
                    message.append(" are already contained in the index.");
                }
            }
            if (message.length() == 0) {
                message.append("No URIs were specified. Hit Cancel to terminate the dialog.");
            }
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error Adding Projects", null, (IStatus)new Status(4, SetupUIPlugin.INSTANCE.getSymbolicName(), message.toString()));
            return false;
        }

        private ProjectCatalog getSelectedCatalog() {
            IStructuredSelection selection = (IStructuredSelection)this.catalogViewer.getSelection();
            ProjectCatalog selectedCatalog = (ProjectCatalog)selection.getFirstElement();
            return selectedCatalog;
        }
    }

    private final class CatalogColumnLabelProvider
    extends ColumnLabelProvider {
        private final Image image;

        private CatalogColumnLabelProvider() {
            this.image = ProjectPage.this.labelProvider.getImage(SetupFactory.eINSTANCE.createProjectCatalog());
        }

        public String getText(Object element) {
            Stream stream = (Stream)element;
            ProjectCatalog catalog = stream.getProject().getProjectCatalog();
            return SetupCoreUtil.getLabel((Scope)catalog);
        }

        public Image getImage(Object element) {
            return this.image;
        }
    }

    private static final class ItemProviderAdapterFactory
    extends SetupItemProviderAdapterFactory
    implements SetupPackage.Literals {
        private CatalogSelection selection;

        public ItemProviderAdapterFactory(CatalogSelection selection) {
            this.selection = selection;
        }

        public Adapter createCatalogSelectionAdapter() {
            if (this.catalogSelectionItemProvider == null) {
                this.catalogSelectionItemProvider = new CatalogSelectionItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(CATALOG_SELECTION__PROJECT_CATALOGS);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.catalogSelectionItemProvider;
        }

        public Adapter createIndexAdapter() {
            if (this.indexItemProvider == null) {
                this.indexItemProvider = new IndexItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(INDEX__PROJECT_CATALOGS);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.indexItemProvider;
        }

        public Adapter createProjectCatalogAdapter() {
            return new ProjectCatalogItemProvider((AdapterFactory)this){
                private AdapterFactoryItemDelegator itemDelegator;
                {
                    this.itemDelegator = new AdapterFactoryItemDelegator(this.getRootAdapterFactory());
                }

                public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                    if (this.childrenFeatures == null) {
                        this.childrenFeatures = new ArrayList();
                        this.childrenFeatures.add(PROJECT_CONTAINER__PROJECTS);
                    }
                    return this.childrenFeatures;
                }

                public Collection<?> getChildren(Object object) {
                    ArrayList result = new ArrayList(super.getChildren(object));
                    Iterator it = result.iterator();
                    while (it.hasNext()) {
                        Project project = (Project)it.next();
                        if (project.getStreams().isEmpty() && project.getProjects().isEmpty()) {
                            it.remove();
                            continue;
                        }
                        IUpdateableItemParent updateableItemParent = (IUpdateableItemParent)this.getRootAdapterFactory().adapt((Notifier)project, IEditingDomainItemProvider.class);
                        updateableItemParent.setParent((Object)project, object);
                    }
                    return result;
                }

                protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
                    ProjectCatalog projectCatalog = (ProjectCatalog)owner;
                    for (Project project : projectCatalog.getProjects()) {
                        Command command = this.itemDelegator.createCommand((Object)project, domain, DragAndDropCommand.class, new CommandParameter((Object)project, (Object)new DragAndDropCommand.Detail(location, operations, operation), collection));
                        if (!command.canExecute()) continue;
                        return command;
                    }
                    return UnexecutableCommand.INSTANCE;
                }

                protected Command createDragAndDropCommand(EditingDomain domain, ResourceSet resourceSet, float location, int operations, int operation, Collection<URI> collection) {
                    return this.createPrimaryDragAndDropCommand(domain, this.getTarget(), location, operations, operation, collection);
                }

                public Object getParent(Object object) {
                    return ItemProviderAdapterFactory.this.selection;
                }

                protected Object overlayImage(Object object, Object image) {
                    return image;
                }
            };
        }

        public Adapter createProjectAdapter() {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SpecializedProjectItemProvider
            extends ProjectItemProvider
            implements IUpdateableItemParent {
                private Object parent;

                SpecializedProjectItemProvider(AdapterFactory adapterFactory) {
                    super(adapterFactory);
                }

                public Object getImage(Object object) {
                    Project project;
                    if (object instanceof Project && (project = (Project)object).getStreams().isEmpty()) {
                        return SetupUIPlugin.INSTANCE.getSWTImage("folder");
                    }
                    return super.getImage(object);
                }

                public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                    if (this.childrenFeatures == null) {
                        this.childrenFeatures = new ArrayList();
                        this.childrenFeatures.add(PROJECT_CONTAINER__PROJECTS);
                    }
                    return this.childrenFeatures;
                }

                protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
                    final Project targetProject = (Project)this.getTarget();
                    Resource.Internal directResource = ((InternalEObject)targetProject).eDirectResource();
                    if (directResource != null && SetupContext.isUserScheme((String)directResource.getURI().scheme())) {
                        final ResourceSet resourceSet = domain.getResourceSet();
                        return new DragAndDropCommand(domain, resourceSet, location, operations, operation, collection){
                            final Set<Project> projects;
                            final Set<Project> affectedObjects;
                            {
                                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                                this.projects = new LinkedHashSet<Project>();
                                this.affectedObjects = new LinkedHashSet<Project>();
                            }

                            public void execute() {
                                EList targetProjects = targetProject.getProjects();
                                block0: for (Project project : this.projects) {
                                    if (this.operation != 4) {
                                        if (project.eContainer() != null) {
                                            project = (Project)EcoreUtil.copy((EObject)project);
                                        } else {
                                            Resource resource = project.eResource();
                                            resource.getContents().clear();
                                            resourceSet.getResources().remove((Object)resource);
                                        }
                                    }
                                    this.affectedObjects.add(project);
                                    String name = project.getName();
                                    for (Project otherProject : targetProjects) {
                                        if (!name.equals(otherProject.getName())) continue;
                                        targetProjects.set(targetProjects.indexOf((Object)otherProject), (Object)project);
                                        continue block0;
                                    }
                                    targetProjects.add((Object)project);
                                }
                                BaseUtil.saveEObject((EObject)targetProject);
                                ProjectCatalog projectCatalog = targetProject.getProjectCatalog();
                                if (projectCatalog != null) {
                                    this.fireNotifyChanged((Notification)new ViewerNotification((Notification)new ENotificationImpl((InternalEObject)projectCatalog, 1, (EStructuralFeature)SetupPackage.Literals.PRODUCT_CATALOG__PRODUCTS, (Object)targetProject, (Object)targetProject, projectCatalog.getProjects().indexOf((Object)targetProject)), (Object)projectCatalog, true, false));
                                }
                            }

                            protected boolean prepare() {
                                this.projects.clear();
                                for (Object value : this.collection) {
                                    Project project;
                                    if (value instanceof URI) {
                                        URI uri = (URI)value;
                                        BaseResource resource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)uri);
                                        Project project2 = (Project)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.PROJECT);
                                        if (project2 == null || project2.getName() == null || this.operation != 1 && project2.eContainer() != null) continue;
                                        this.projects.add(project2);
                                        continue;
                                    }
                                    if (!(value instanceof Project) || (project = (Project)value).getName() == null || this.operation != 1 && project.eContainer() != null) continue;
                                    this.projects.add(project);
                                }
                                if (this.operation == 2) {
                                    this.operation = 4;
                                }
                                return !this.projects.isEmpty();
                            }

                            public Collection<?> getAffectedObjects() {
                                return this.affectedObjects;
                            }

                            public void redo() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                    return UnexecutableCommand.INSTANCE;
                }

                protected Command createDragAndDropCommand(EditingDomain domain, ResourceSet resourceSet, float location, int operations, int operation, Collection<URI> collection) {
                    return this.createPrimaryDragAndDropCommand(domain, this.getTarget(), location, operations, operation, collection);
                }

                protected Object overlayImage(Object object, Object image) {
                    return image;
                }

                public Object getParent(Object object) {
                    return this.parent == null ? super.getParent(object) : this.parent;
                }

                public void setParent(Object object, Object parent) {
                    this.parent = parent;
                }
            }
            return new SpecializedProjectItemProvider((AdapterFactory)this);
        }

        public Adapter createWorkspaceAdapter() {
            if (this.workspaceItemProvider == null) {
                this.workspaceItemProvider = new WorkspaceItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(WORKSPACE__STREAMS);
                        }
                        return this.childrenFeatures;
                    }

                    public void notifyChanged(Notification notification) {
                        switch (notification.getFeatureID(Workspace.class)) {
                            case 6: {
                                this.updateChildren(notification);
                                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                                return;
                            }
                        }
                        super.notifyChanged(notification);
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.workspaceItemProvider;
        }
    }

    private final class ProjectColumnLabelProvider
    extends ColumnLabelProvider {
        private final Image image;

        private ProjectColumnLabelProvider() {
            this.image = ProjectPage.this.labelProvider.getImage(SetupFactory.eINSTANCE.createProject());
        }

        public String getText(Object element) {
            Stream stream = (Stream)element;
            StringBuilder builder = new StringBuilder();
            ProjectPage.createProjectLabel(stream.getProject(), builder);
            return builder.toString();
        }

        public Image getImage(Object element) {
            return this.image;
        }
    }

    private final class StreamColumnLabelProvider
    extends ColumnLabelProvider {
        private final Image image;

        private StreamColumnLabelProvider() {
            this.image = ProjectPage.this.labelProvider.getImage(SetupFactory.eINSTANCE.createStream());
        }

        public String getText(Object element) {
            Stream stream = (Stream)element;
            return SetupCoreUtil.getLabel((Scope)stream);
        }

        public Image getImage(Object element) {
            return this.image;
        }
    }
}

