/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.NotPermittedAttrException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.redirector.Redirector;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;

public class AEAnncController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        DAO<?> dao = Patterns.getDAO(request.getTargetId(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTargetId());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        this.transaction.lock((Object)parentEntity);
        List acpsToCheck = null;
        List childAnncs = null;
        List subs = null;
        if (parentEntity.getResourceType().intValue() == 16) {
            RemoteCSEEntity csr = (RemoteCSEEntity)parentEntity;
            acpsToCheck = csr.getAccessControlPolicies();
            childAnncs = csr.getChildAeAnncs();
            subs = csr.getSubscriptions();
        }
        parentEntity.getResourceType().intValue();
        if (parentEntity.getResourceType().intValue() == 10002) {
            AeAnncEntity aeAnncEntity = (AeAnncEntity)parentEntity;
            acpsToCheck = aeAnncEntity.getAccessControlPolicies();
            childAnncs = null;
            subs = aeAnncEntity.getSubscriptions();
        }
        this.checkPermissions(request, parentEntity, acpsToCheck);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for AEAnnc creation");
        }
        AEAnnc aeAnnc = null;
        try {
            aeAnnc = request.getRequestContentType().equals("application/obj") ? (AEAnnc)request.getContent() : (AEAnnc)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (aeAnnc == null) {
            throw new BadRequestException("Error in provided content");
        }
        AeAnncEntity aeAnncEntity = new AeAnncEntity();
        ControllerUtil.CreateUtil.fillEntityFromGenericResource((Resource)aeAnnc, (ResourceEntity)aeAnncEntity);
        if (aeAnnc.getAEID() != null) {
            throw new NotPermittedAttrException("ae-id is Not Permitted");
        }
        if (aeAnnc.getNodeLink() != null) {
            aeAnncEntity.setNodeLink(aeAnnc.getNodeLink());
        }
        if (aeAnnc.getLink() == null) {
            throw new BadRequestException("Link is Mandatory");
        }
        aeAnncEntity.setLink(aeAnnc.getLink());
        if (aeAnnc.getAppID() == null) {
            throw new BadRequestException("App ID is Mandatory");
        }
        aeAnncEntity.setAppID(aeAnnc.getAppID());
        String generatedId = AEAnncController.generateId();
        aeAnncEntity.setAeid("aeA" + Constants.PREFIX_SEPERATOR + generatedId);
        aeAnncEntity.setResourceID("/" + Constants.CSE_ID + "/" + aeAnncEntity.getAeid());
        aeAnncEntity.setParentCsr((RemoteCSEEntity)parentEntity);
        if (this.dbs.getDAOFactory().getAeAnncDAO().find(this.transaction, (Object)aeAnncEntity.getResourceID()) != null) {
            throw new ConflictException("Already registered");
        }
        if (!aeAnnc.getAccessControlPolicyIDs().isEmpty()) {
            aeAnncEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(aeAnnc.getAccessControlPolicyIDs(), this.transaction));
        } else {
            aeAnncEntity.getAccessControlPolicies().addAll(acpsToCheck);
        }
        if (!aeAnnc.getDynamicAuthorizationConsultationIDs().isEmpty()) {
            aeAnncEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(aeAnnc.getDynamicAuthorizationConsultationIDs(), this.transaction));
        }
        if (aeAnnc.getAppName() != null) {
            aeAnncEntity.setAppName(aeAnnc.getAppName());
        }
        aeAnncEntity.setParentID(parentEntity.getResourceID());
        aeAnncEntity.setResourceType(BigInteger.valueOf(10002L));
        if (aeAnnc.getName() != null) {
            if (!Patterns.checkResourceName(aeAnnc.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:([A-Za-z0-9_\\-~#]|\\.)+");
            }
            aeAnncEntity.setName(aeAnnc.getName());
        } else {
            aeAnncEntity.setName("aeA_" + generatedId);
        }
        aeAnncEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + aeAnncEntity.getName());
        if (!UriMapper.addNewUri(aeAnncEntity.getHierarchicalURI(), aeAnncEntity.getResourceID(), 10002)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        this.dbs.getDAOFactory().getAeAnncDAO().create(this.transaction, (Object)aeAnncEntity);
        AeAnncEntity aeAnncDB = (AeAnncEntity)this.dbs.getDAOFactory().getAeAnncDAO().find(this.transaction, (Object)aeAnncEntity.getResourceID());
        childAnncs.add(aeAnncDB);
        dao.update(this.transaction, (Object)parentEntity);
        for (DynamicAuthorizationConsultationEntity dace : aeAnncDB.getDynamicAuthorizationConsultations()) {
            DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
            daceFromDB.getLinkedAeAnncEntities().add(aeAnncDB);
            this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
        }
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)aeAnncDB);
        Notifier.notify(subs, (ResourceEntity)aeAnncDB, 1);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        AeAnncEntity aeAnncEntity = (AeAnncEntity)this.dbs.getDAOFactory().getAeAnncDAO().find(this.transaction, (Object)request.getTargetId());
        if (aeAnncEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.checkPermissions(request, (ResourceEntity)aeAnncEntity, aeAnncEntity.getAccessControlPolicies());
        if (ResultContent.ORIGINAL_RES.equals(request.getResultContent())) {
            RequestPrimitive originalResourceRequest = new RequestPrimitive();
            originalResourceRequest.setOperation(Operation.RETRIEVE);
            originalResourceRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
            originalResourceRequest.setTargetId(aeAnncEntity.getLink());
            originalResourceRequest.setReturnContentType(request.getReturnContentType());
            return Redirector.retarget(originalResourceRequest);
        }
        AEAnnc aeAnnc = EntityMapperFactory.getAEAnncMapper().mapEntityToResource(aeAnncEntity, request);
        response.setContent((Object)aeAnnc);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        AeAnncEntity aeAnncEntity = (AeAnncEntity)this.dbs.getDAOFactory().getAeAnncDAO().find(this.transaction, (Object)request.getTargetId());
        if (aeAnncEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.transaction.lock((Object)aeAnncEntity);
        this.checkPermissions(request, (ResourceEntity)aeAnncEntity, aeAnncEntity.getAccessControlPolicies());
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for AE update");
        }
        AEAnnc aeAnnc = null;
        try {
            aeAnnc = request.getRequestContentType().equals("application/obj") ? (AEAnnc)request.getContent() : (AEAnnc)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (aeAnnc == null) {
            throw new BadRequestException("Error in provided content");
        }
        ControllerUtil.UpdateUtil.checkNotPermittedParameters((Resource)aeAnnc);
        if (aeAnnc.getAppID() != null) {
            throw new BadRequestException("AppID is NP");
        }
        if (aeAnnc.getAEID() != null) {
            throw new BadRequestException("AE ID is NP");
        }
        if (aeAnnc.getNodeLink() != null) {
            throw new BadRequestException("NodeLink is NP");
        }
        AE modifiedAttributes = new AE();
        if (!aeAnnc.getLabels().isEmpty()) {
            aeAnncEntity.setLabelsEntitiesFromSring(aeAnnc.getLabels());
            modifiedAttributes.getLabels().addAll(aeAnnc.getLabels());
        }
        if (!aeAnnc.getAccessControlPolicyIDs().isEmpty()) {
            for (AccessControlPolicyEntity acpe : aeAnncEntity.getAccessControlPolicies()) {
                this.checkSelfACP(acpe, request.getFrom(), Operation.UPDATE);
            }
            aeAnncEntity.getAccessControlPolicies().clear();
            aeAnncEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(aeAnnc.getAccessControlPolicyIDs(), this.transaction));
            modifiedAttributes.getAccessControlPolicyIDs().addAll(aeAnnc.getAccessControlPolicyIDs());
        }
        if (!aeAnnc.getDynamicAuthorizationConsultationIDs().isEmpty()) {
            aeAnncEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(aeAnnc.getDynamicAuthorizationConsultationIDs(), this.transaction));
            for (DynamicAuthorizationConsultationEntity dace : aeAnncEntity.getDynamicAuthorizationConsultations()) {
                DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
                daceFromDB.getLinkedAeAnncEntities().add(aeAnncEntity);
                this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
            }
        }
        if (aeAnnc.getExpirationTime() != null) {
            aeAnncEntity.setExpirationTime(aeAnnc.getExpirationTime());
            modifiedAttributes.setExpirationTime(aeAnnc.getExpirationTime());
        }
        if (aeAnnc.getAppName() != null) {
            aeAnncEntity.setAppName(aeAnnc.getAppName());
            modifiedAttributes.setAppName(aeAnnc.getAppName());
        }
        if (!aeAnnc.getPointOfAccess().isEmpty()) {
            aeAnncEntity.getPointOfAccess().clear();
            aeAnncEntity.getPointOfAccess().addAll(aeAnnc.getPointOfAccess());
            modifiedAttributes.getPointOfAccess().addAll(aeAnnc.getPointOfAccess());
        }
        if (aeAnnc.getOntologyRef() != null) {
            aeAnncEntity.setOntologyRef(aeAnnc.getOntologyRef());
            modifiedAttributes.setOntologyRef(aeAnnc.getOntologyRef());
        }
        aeAnncEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(aeAnncEntity.getLastModifiedTime());
        response.setContent((Object)modifiedAttributes);
        this.dbs.getDAOFactory().getAeAnncDAO().update(this.transaction, (Object)aeAnncEntity);
        this.transaction.commit();
        Notifier.notify(aeAnncEntity.getSubscriptions(), (ResourceEntity)aeAnncEntity, 3);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        AeAnncEntity aeAnncEntity = (AeAnncEntity)this.dbs.getDAOFactory().getAeAnncDAO().find(this.transaction, (Object)request.getTargetId());
        if (aeAnncEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.transaction.lock((Object)aeAnncEntity);
        this.checkPermissions(request, (ResourceEntity)aeAnncEntity, aeAnncEntity.getAccessControlPolicies());
        UriMapper.deleteUri(aeAnncEntity.getHierarchicalURI());
        Notifier.notifyDeletion(aeAnncEntity.getSubscriptions(), (ResourceEntity)aeAnncEntity);
        this.dbs.getDAOFactory().getAeAnncDAO().delete(this.transaction, (Object)aeAnncEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

