/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.mongodb;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class DBTransactionImpl
implements DBTransaction {
    private static final Log LOGGER = LogFactory.getLog(DBTransactionImpl.class);
    private static final Set<String> GLOBAL_LOCKED_OBJECTS = new HashSet<String>();
    private final UUID uuid = UUID.randomUUID();
    private final Set<String> lockedObjects = new HashSet<String>();
    private boolean childToBeLoaded = true;

    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        LOGGER.info((Object)("commit() for trasaction " + this.uuid));
        HashSet<String> currentLockedObjects = new HashSet<String>();
        Set<String> set = this.lockedObjects;
        synchronized (set) {
            currentLockedObjects.addAll(this.lockedObjects);
        }
        for (String lockedResourceId : currentLockedObjects) {
            this.unlock(lockedResourceId);
        }
    }

    public void close() {
    }

    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lock(Object object) {
        LOGGER.info((Object)"lock()");
        ResourceEntity resourceEntityToBeLocked = null;
        if (object instanceof ResourceEntity) {
            resourceEntityToBeLocked = (ResourceEntity)object;
        }
        if (resourceEntityToBeLocked == null) throw new RuntimeException();
        String resourceId = resourceEntityToBeLocked.getResourceID();
        LOGGER.info((Object)("request lock for " + resourceId + " by transaction " + this.uuid));
        if (!DBTransactionImpl.addGlobalLock(resourceId)) throw new RuntimeException("unable to acquire lock for resource " + resourceId + " by transaction " + this.uuid);
        Set<String> set = this.lockedObjects;
        synchronized (set) {
            this.lockedObjects.add(resourceId);
            return;
        }
    }

    public void unlock(Object object) {
        LOGGER.info((Object)("unlock object=" + object + " for transaction " + this.uuid));
        ResourceEntity resourceEntityToBeLocked = null;
        if (object instanceof ResourceEntity) {
            resourceEntityToBeLocked = (ResourceEntity)object;
        }
        if (resourceEntityToBeLocked != null) {
            String resourceId = resourceEntityToBeLocked.getResourceID();
            this.unlock(resourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(String resourceId) {
        LOGGER.debug((Object)("try to unlock " + resourceId + " by transaction " + this.uuid));
        Set<String> set = this.lockedObjects;
        synchronized (set) {
            if (this.lockedObjects.remove(resourceId)) {
                DBTransactionImpl.removeGlobalLock(resourceId);
            }
        }
    }

    public boolean isChildToBeLoaded() {
        return this.childToBeLoaded;
    }

    public void setChildToBeLoaded(boolean childToBeLoaded) {
        this.childToBeLoaded = childToBeLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isExistingLock(String resourceId) {
        Set<String> set = GLOBAL_LOCKED_OBJECTS;
        synchronized (set) {
            return GLOBAL_LOCKED_OBJECTS.contains(resourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized boolean addGlobalLock(String resourceId) {
        Set<String> set = GLOBAL_LOCKED_OBJECTS;
        synchronized (set) {
            long initialTime = System.currentTimeMillis();
            do {
                if (System.currentTimeMillis() >= initialTime + 10000L) {
                    return false;
                }
                if (!GLOBAL_LOCKED_OBJECTS.contains(resourceId)) continue;
                try {
                    GLOBAL_LOCKED_OBJECTS.wait(1000L);
                }
                catch (InterruptedException e) {
                    return false;
                }
            } while (GLOBAL_LOCKED_OBJECTS.contains(resourceId));
            GLOBAL_LOCKED_OBJECTS.add(resourceId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void removeGlobalLock(String resourceId) {
        Set<String> set = GLOBAL_LOCKED_OBJECTS;
        synchronized (set) {
            GLOBAL_LOCKED_OBJECTS.remove(resourceId);
            GLOBAL_LOCKED_OBJECTS.notifyAll();
        }
    }
}

