/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="sch")
@Inheritance(strategy=InheritanceType.JOINED)
public class ScheduleEntity
extends AnnounceableSubordinateEntity {
    protected List<String> scheduleEntries;
    @OneToOne(fetch=FetchType.LAZY, targetEntity=RemoteCSEEntity.class, mappedBy="linkedSchedule")
    protected RemoteCSEEntity linkedCsr;
    @OneToOne(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class, mappedBy="linkedSchedule")
    protected CSEBaseEntity linkedCsb;
    @OneToOne(fetch=FetchType.LAZY, targetEntity=SubscriptionEntity.class, mappedBy="childSchedule")
    protected SubscriptionEntity parentSub;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="SCH_SUB_JOIN", joinColumns={@JoinColumn(name="SCH_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="SCHACP_JOIN", joinColumns={@JoinColumn(name="SCH_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> accessControlPolicies;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="linkedScheduleEntities")
    @JoinTable(name="SCH_DAC_JOIN", joinColumns={@JoinColumn(name="SCH_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")})
    protected List<DynamicAuthorizationConsultationEntity> dynamicAuthorizationConsultations;

    public List<String> getScheduleEntries() {
        return this.scheduleEntries;
    }

    public void setScheduleEntries(List<String> scheduleEntries) {
        this.scheduleEntries = scheduleEntries;
    }

    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public RemoteCSEEntity getLinkedCsr() {
        return this.linkedCsr;
    }

    public void setLinkedCsr(RemoteCSEEntity linkedCsr) {
        this.linkedCsr = linkedCsr;
    }

    public CSEBaseEntity getLinkedCsb() {
        return this.linkedCsb;
    }

    public void setLinkedCsb(CSEBaseEntity linkedCsb) {
        this.linkedCsb = linkedCsb;
    }

    public SubscriptionEntity getLinkedSub() {
        return this.parentSub;
    }

    public void setLinkedSub(SubscriptionEntity linkedSub) {
        this.parentSub = linkedSub;
    }

    @Override
    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.accessControlPolicies == null) {
            this.accessControlPolicies = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.accessControlPolicies;
    }

    @Override
    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
        this.accessControlPolicies = accessControlPolicies;
    }

    @Override
    public List<DynamicAuthorizationConsultationEntity> getDynamicAuthorizationConsultations() {
        if (this.dynamicAuthorizationConsultations == null) {
            this.dynamicAuthorizationConsultations = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.dynamicAuthorizationConsultations;
    }

    @Override
    public void setDynamicAuthorizationConsultations(List<DynamicAuthorizationConsultationEntity> list) {
        this.dynamicAuthorizationConsultations = list;
    }
}

