/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import java.math.BigInteger;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.BinarySwitchFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class LocationFlexContainerTest
extends FlexContainerTestSuite {
    @Override
    protected String getTestSuiteName() {
        return "LocationFlexContainerTest";
    }

    public LocationFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    public void testUnderCseBase() {
        this.genericTest("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME, "testUnderCseBase");
    }

    public void testUnderRemoteCSE() {
        this.genericTest("/" + Constants.REMOTE_CSE_ID + "/" + Constants.REMOTE_CSE_NAME, "testUnderRemoteCSE");
    }

    public void testUnderFlexContainer() {
        BinarySwitchFlexContainer parentFlexContainer = new BinarySwitchFlexContainer();
        String parentFlexContainerName = "parentFlexContainer_" + System.currentTimeMillis();
        parentFlexContainer.setName(parentFlexContainerName);
        CustomAttribute ca = new CustomAttribute();
        ca.setCustomAttributeName("powSe");
        ca.setCustomAttributeValue("true");
        parentFlexContainer.getCustomAttributes().add(ca);
        this.sendCreateFlexContainerRequest((AbstractFlexContainer)parentFlexContainer, "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME, Constants.ADMIN_REQUESTING_ENTITY);
        this.genericTest("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + parentFlexContainerName, "testUnderFlexContainer");
    }

    public void testUnderContainer() {
        String parentContainerName = "parentContainerName_" + System.currentTimeMillis();
        Container container = new Container();
        container.setOntologyRef("OrangeOntology");
        container.setName(parentContainerName);
        String baseParentContainerLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        RequestPrimitive request = new RequestPrimitive();
        request.setContent((Object)container);
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTargetId(baseParentContainerLocation);
        request.setResourceType(BigInteger.valueOf(3L));
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setOperation(Operation.CREATE);
        ResponsePrimitive response = this.getCseService().doRequest(request);
        this.genericTest(String.valueOf(baseParentContainerLocation) + "/" + parentContainerName, "testUnderContainer");
    }

    private void genericTest(String location, String methodName) {
        BinarySwitchFlexContainer flexContainer = new BinarySwitchFlexContainer();
        CustomAttribute ca = new CustomAttribute();
        ca.setCustomAttributeName("powSe");
        ca.setCustomAttributeValue("true");
        flexContainer.getCustomAttributes().add(ca);
        String flexContainerName = "FLEXCONTAINER_" + System.currentTimeMillis();
        flexContainer.setName(flexContainerName);
        String baseLocation = location;
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        BinarySwitchFlexContainer createdFlexContainer = null;
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            createdFlexContainer = (BinarySwitchFlexContainer)response.getContent();
            try {
                this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
                this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            }
            catch (Exception e) {
                this.createTestReport(methodName, TestReport.Status.KO, e.getMessage(), e);
                return;
            }
            if (!createdFlexContainer.getName().equals(flexContainerName)) {
                this.createTestReport(methodName, TestReport.Status.KO, "invalid flexContainer name, expecting:" + flexContainerName, null);
                return;
            }
        } else {
            this.createTestReport(methodName, TestReport.Status.KO, "unexpected response code:" + response.getResponseStatusCode() + ", expected:" + ResponseStatusCode.CREATED, null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            BinarySwitchFlexContainer retrievedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
            try {
                this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
            }
            catch (Exception e) {
                this.createTestReport(methodName, TestReport.Status.KO, e.getMessage(), e);
                return;
            }
        } else {
            this.createTestReport(methodName, TestReport.Status.KO, "unexpected response code:" + response.getResponseStatusCode() + ", expected:" + ResponseStatusCode.OK, null);
            return;
        }
        this.createTestReport(methodName, TestReport.Status.OK, null, null);
    }
}

