/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.modules.AbstractAlarmSensor;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class MotionSensor
extends AbstractAlarmSensor {
    private IntegerDataPoint silentTime;
    private IntegerDataPoint sensitivity;

    public MotionSensor(String name, Domain domain, BooleanDataPoint alarm) {
        super(name, domain, alarm, ModuleType.motionSensor, "The detection of the motion occurrence.");
    }

    public MotionSensor(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get("alarm"));
        IntegerDataPoint sensitivity;
        IntegerDataPoint silentTime = (IntegerDataPoint)dps.get(DatapointType.silentTime.getShortName());
        if (silentTime != null) {
            this.setSilentTime(silentTime);
        }
        if ((sensitivity = (IntegerDataPoint)dps.get(DatapointType.sensitivity.getShortName())) != null) {
            this.setSensitivity(sensitivity);
        }
    }

    public void setSilentTime(IntegerDataPoint dp) {
        this.silentTime = dp;
        this.silentTime.setOptional(true);
        this.silentTime.setDoc("The time that the motionSensor restrains from sending an alarm in case continous motions are detected after one alarm is produced. This DataPoint can be used to avoid repeated alarm reports.");
        this.addDataPoint((DataPoint)this.silentTime);
    }

    public int getSilentTime() throws DataPointException, AccessException {
        if (this.silentTime == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.silentTime.getValue();
    }

    public void setSilentTime(int v) throws DataPointException, AccessException {
        if (this.silentTime == null) {
            throw new DataPointException("Not implemented");
        }
        this.silentTime.setValue((Object)v);
    }

    public void setSensitivity(IntegerDataPoint dp) {
        this.sensitivity = dp;
        this.sensitivity.setOptional(true);
        this.sensitivity.setDoc("The level of the detection accuracy of the motion sensor. This DataPoint can be used to control the number of the report.");
        this.addDataPoint((DataPoint)this.sensitivity);
    }

    public int getSensitivity() throws DataPointException, AccessException {
        if (this.sensitivity == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.sensitivity.getValue();
    }

    public void setSensitivity(int v) throws DataPointException, AccessException {
        if (this.sensitivity == null) {
            throw new DataPointException("Not implemented");
        }
        this.sensitivity.setValue((Object)v);
    }
}

