/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.crud;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;

public class RetrieveDASTest
extends Test {
    public RetrieveDASTest(CseService pCseService) {
        super("Retrieve DAS", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation createdDas = this.createDAS();
        if (createdDas == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a DAS");
            return;
        }
        if (!this.retrieveDas(createdDas.getResourceID(), createdDas)) {
            return;
        }
        if (!this.retrieveDas("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + createdDas.getName(), createdDas)) {
            return;
        }
        this.setState(Test.State.OK);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean retrieveDas(String dasUrl, DynamicAuthorizationConsultation createdDas) {
        RequestPrimitive requestPrimitive = new RequestPrimitive();
        requestPrimitive.setOperation(Operation.RETRIEVE);
        requestPrimitive.setRequestContentType("application/obj");
        requestPrimitive.setReturnContentType("application/obj");
        requestPrimitive.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        requestPrimitive.setTargetId(dasUrl);
        ResponsePrimitive response = this.getCseService().doRequest(requestPrimitive);
        if (response != null) {
            if (ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
                DynamicAuthorizationConsultation retrievedDas = null;
                try {
                    retrievedDas = (DynamicAuthorizationConsultation)response.getContent();
                }
                catch (ClassCastException e) {
                    this.setState(Test.State.KO);
                    this.setMessage("unable to cast content as a DynamicAuthorizationConsultation");
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getName(), createdDas.getName(), "name")) {
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getResourceType().intValue(), createdDas.getResourceType().intValue(), "resourceType")) {
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getResourceID(), createdDas.getResourceID(), "resourceID")) {
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getParentID(), createdDas.getParentID(), "parentID")) {
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getExpirationTime(), createdDas.getExpirationTime(), "expirationTime")) {
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getAccessControlPolicyIDs(), createdDas.getAccessControlPolicyIDs(), "accessControlPolicyIDs")) {
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getCreationTime(), createdDas.getCreationTime(), "creationTime")) {
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getLastModifiedTime(), createdDas.getLastModifiedTime(), "lastModifiedTime")) {
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getLabels(), createdDas.getLabels(), "labels")) {
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getDynamicAuthorizationEnabled(), createdDas.getDynamicAuthorizationEnabled(), "dynamicAuthorizationEnabled")) {
                    return false;
                }
                if (!this.checkEquals(retrievedDas.getDynamicAuthorisationPoA(), createdDas.getDynamicAuthorisationPoA(), "dynamicAuthorizationPoA")) {
                    return false;
                }
                if (this.checkEquals(retrievedDas.getDynamicAuthorizationLifetime(), createdDas.getDynamicAuthorizationLifetime(), "dynamicAuthorizationLifetime")) return true;
                return false;
            }
            this.setState(Test.State.KO);
            this.setMessage("expecting " + ResponseStatusCode.UPDATED + " status code, found " + response.getResponseStatusCode());
            return false;
        }
        this.setState(Test.State.KO);
        this.setMessage("no response");
        return true;
    }
}

