/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.ae;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;
import org.eclipse.om2m.das.testsuite.ae.AbstractDASServiceTest;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.osgi.framework.ServiceRegistration;

public class DASServiceTest_AeAnnc
extends AbstractDASServiceTest {
    public DASServiceTest_AeAnnc(CseService pCseService) {
        super("DasServiceTest_AeAnnc", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS(this.getDasAE().getResourceID());
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create dac");
            return;
        }
        this.setExpectedNumberOfCall(1);
        ServiceRegistration<InterworkingService> interworkingServiceRegistration = this.registerInterworkingService(this);
        RemoteCSE remoteCse = this.createRemoteCse();
        if (remoteCse == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a RemoteCse");
            return;
        }
        ArrayList<String> dacis = new ArrayList<String>();
        dacis.add(dac.getResourceID());
        AEAnnc createdAeAnnc = this.createAeAnnc(remoteCse.getResourceID(), dacis);
        if (createdAeAnnc == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a AeAnnc");
            return;
        }
        ResponsePrimitive response = this.retrieveEntity(createdAeAnnc.getResourceID(), "nom:password");
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve AeAnnc, expecting " + ResponseStatusCode.OK + ", found =" + response.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdAeAnnc.getResourceID(), "nom:password", Operation.RETRIEVE)) {
            return;
        }
        this.clearCalls();
        AEAnnc toBeUpdated = new AEAnnc();
        toBeUpdated.setLink("/link" + UUID.randomUUID());
        RequestPrimitive updateRequest = new RequestPrimitive();
        updateRequest.setFrom("nom:prenom");
        updateRequest.setTargetId(createdAeAnnc.getResourceID());
        updateRequest.setOperation(Operation.UPDATE);
        updateRequest.setRequestContentType("application/obj");
        updateRequest.setReturnContentType("application/obj");
        updateRequest.setContent((Object)toBeUpdated);
        ResponsePrimitive updateResponse = this.getCseService().doRequest(updateRequest);
        if (updateResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("updateAeAnnc response is null");
            return;
        }
        if (!ResponseStatusCode.UPDATED.equals(updateResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to update AeAnnc, expecting " + ResponseStatusCode.UPDATED + ", found " + updateResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdAeAnnc.getResourceID(), "nom:prenom", Operation.UPDATE)) {
            return;
        }
        this.clearCalls();
        RequestPrimitive deleteRequest = new RequestPrimitive();
        deleteRequest.setTargetId(createdAeAnnc.getResourceID());
        deleteRequest.setFrom("toto:tata");
        deleteRequest.setOperation(Operation.DELETE);
        ResponsePrimitive deleteResponse = this.getCseService().doRequest(deleteRequest);
        if (deleteResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("deleteFlexContainerAnnc response is null");
            return;
        }
        if (!ResponseStatusCode.DELETED.equals(deleteResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to delete FlexContainerAnnc, expecting " + ResponseStatusCode.DELETED + ", found " + deleteResponse.getResponseStatusCode());
            return;
        }
        if (!this.checkCall(0, createdAeAnnc.getResourceID(), "toto:tata", Operation.DELETE)) {
            return;
        }
        this.unregisterInterworkingService(interworkingServiceRegistration);
        this.setState(Test.State.OK);
    }
}

