/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.om2m.commons.resource.CustomAttribute;

public class SDTUtil {
    private static final DateFormat dateTimeFormat = DateFormat.getDateTimeInstance();
    private static final DateFormat dateFormat = DateFormat.getDateInstance();
    private static final DateFormat timeFormat = DateFormat.getTimeInstance();

    public static Object getValue(CustomAttribute attr, String type) throws Exception {
        return SDTUtil.getValue(attr.getCustomAttributeValue(), type);
    }

    public static Object getValue(String value, String type) throws Exception {
        if (value == null) {
            return null;
        }
        switch (type) {
            case "xs:string": {
                return value;
            }
            case "xs:integer": {
                return Integer.parseInt(value);
            }
            case "xs:float": {
                return Float.valueOf(Float.parseFloat(value));
            }
            case "xs:boolean": {
                return Boolean.parseBoolean(value);
            }
            case "xs:datetime": {
                return dateTimeFormat.parse(value);
            }
            case "xs:time": {
                return timeFormat.parse(value);
            }
            case "xs:date": {
                return dateFormat.parse(value);
            }
            case "xs:byte": {
                return Byte.parseByte(value);
            }
            case "xs:enum": {
                int last;
                ArrayList<String> ret = new ArrayList<String>();
                value = value.trim();
                if (value.charAt(0) == '[') {
                    value = value.substring(1);
                }
                if (value.charAt(last = value.length() - 1) == ']') {
                    value = value.substring(0, last);
                }
                String[] stringArray = value.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    ret.add(val.trim());
                    ++n2;
                }
                return ret;
            }
            case "xs:uri": {
                return new URI(value);
            }
            case "xs:blob": {
                return value;
            }
        }
        return type.startsWith("hd:") ? Integer.valueOf(Integer.parseInt(value)) : value;
    }

    public static String getStringValue(String type, Object val) throws Exception {
        if (val == null) {
            return null;
        }
        switch (type) {
            case "xs:string": {
                return val.toString();
            }
            case "xs:byte": 
            case "xs:boolean": 
            case "xs:uri": 
            case "xs:float": 
            case "xs:integer": {
                return val.toString();
            }
            case "xs:datetime": {
                return dateTimeFormat.format((Date)val);
            }
            case "xs:time": {
                return timeFormat.format((Date)val);
            }
            case "xs:date": {
                return dateFormat.format((Date)val);
            }
            case "xs:enum": {
                String ret = "";
                boolean first = true;
                for (Object s : (List)val) {
                    if (first) {
                        ret = String.valueOf(ret) + ",";
                    } else {
                        first = false;
                    }
                    ret = String.valueOf(ret) + s.toString();
                }
                return ret;
            }
            case "xs:blob": {
                return null;
            }
        }
        if (type.startsWith("hd:")) {
            return val.toString();
        }
        return null;
    }
}

