/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.PlainAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.WordValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.ModelElement;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineInfo;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.LineNumberProvider;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.IStatementsGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class MethodModel
extends ModelElement {
    public static final int AccIfcMethodModiferMASK = 15;
    private AbstractMethodDeclaration _decl = null;
    private MethodBinding _binding = null;
    private boolean _callsBaseCtor = false;
    public int callinFlags = 0;
    public List<CallinMappingDeclaration> _declaringMappings = null;
    public TypeDeclaration _sourceDeclaringType = null;
    public Argument _thisSubstitution;
    public MethodBinding _srcCtor = null;
    public int _lineOffset;
    public Set<ReferenceBinding> _baseExceptions;
    public boolean _clearPrivateModifier = false;
    public ProblemDetail problemDetail;
    public FakeKind _fakeKind = FakeKind.NOT_FAKED;
    private MethodBinding _baseCallSurrogate = null;
    public CalloutMappingDeclaration _inferredCallout = null;
    private boolean isForbiddenCreationMethod = false;
    public TypeBinding[] liftedParams = null;
    public MethodBinding oldSelfcall = null;
    public MethodBinding adjustedSelfcall = null;
    private byte[] _bytes = null;
    private int _structOffset = 0;
    private int[] _constantPoolOffsets = null;
    private ClassFile _classFile = null;
    private TypeBinding _returnType = null;
    private IStatementsGenerator _statementsGenerator = null;

    public static MethodModel getModel(AbstractMethodDeclaration decl) {
        MethodModel model = decl.model;
        if (model == null) {
            if (decl.binding != null) {
                model = decl.binding.model;
            }
            if (model != null) {
                decl.model = model;
            } else {
                model = new MethodModel(decl);
            }
        }
        return model;
    }

    public static MethodModel getModel(MethodBinding binding) {
        MethodModel model = MethodModel.model(binding);
        if (model == null) {
            model = new MethodModel(binding);
        }
        return model;
    }

    private static MethodModel model(MethodBinding method) {
        if (method.model != null) {
            return method.model;
        }
        MethodBinding original = method.original();
        if (original != method) {
            return original.model;
        }
        return null;
    }

    public void linkBinding(MethodBinding binding) {
        this._binding = binding;
        binding.model = this;
    }

    public void addBaseExceptions(ReferenceBinding[] exceptions) {
        if (this._baseExceptions == null) {
            this._baseExceptions = new HashSet<ReferenceBinding>();
        }
        ReferenceBinding[] referenceBindingArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding exception = referenceBindingArray[n2];
            this._baseExceptions.add(exception);
            ++n2;
        }
    }

    public boolean handleError(ProblemReporter reporter, MessageSend messageSend) {
        switch (this.problemDetail) {
            case RoleInheritsNonPublic: {
                reporter.callToInheritedNonPublic(messageSend, this._binding);
                return true;
            }
            case IllegalDefaultCtor: {
                reporter.illegallyCopiedDefaultCtor(this._decl, this._decl.scope.referenceType());
                return true;
            }
        }
        return false;
    }

    public static boolean isRoleMethodInheritedFromNonPublicRegular(MethodBinding current) {
        MethodModel model = MethodModel.model(current);
        if (model == null) {
            return false;
        }
        return model.problemDetail == ProblemDetail.RoleInheritsNonPublic;
    }

    public static boolean isFakedMethod(MethodBinding abstractMethod) {
        MethodModel model = MethodModel.model(abstractMethod);
        if (model != null) {
            return model._fakeKind != FakeKind.NOT_FAKED;
        }
        return false;
    }

    public static boolean isFakedMethod(MethodBinding abstractMethod, FakeKind fakeKind) {
        MethodModel model = MethodModel.model(abstractMethod);
        if (model != null) {
            return model._fakeKind == fakeKind;
        }
        return false;
    }

    public static boolean isGenerated(MethodBinding methodBinding) {
        AbstractMethodDeclaration decl;
        MethodModel model = MethodModel.model(methodBinding);
        AbstractMethodDeclaration abstractMethodDeclaration = decl = model != null ? model.getDecl() : null;
        if (decl != null) {
            return decl.isGenerated;
        }
        return false;
    }

    private MethodModel(AbstractMethodDeclaration decl) {
        this._decl = decl;
        decl.model = this;
        if (decl.binding != null) {
            decl.binding.model = this;
            this._binding = decl.binding;
        }
    }

    private MethodModel(MethodBinding binding) {
        this._binding = binding;
        binding.model = this;
    }

    public AbstractMethodDeclaration getDecl() {
        return this._decl;
    }

    public MethodBinding getBinding() {
        if (this._binding == null && this._decl != null) {
            this._binding = this._decl.binding;
        }
        return this._binding;
    }

    public void setBaseCallSurrogate(MethodBinding _baseCallSurrogate) {
        this._baseCallSurrogate = _baseCallSurrogate;
    }

    public MethodBinding getBaseCallSurrogate() {
        if (this.getBinding() == null) {
            return null;
        }
        this._binding.declaringClass.methods();
        return this._baseCallSurrogate;
    }

    public void addCallinFlag(int flag) {
        this.callinFlags |= flag & 0xFF;
        if (this._attributes != null) {
            int i = 0;
            while (i < this._attributes.length) {
                if (this._attributes[i].nameEquals(IOTConstants.CALLIN_FLAGS)) {
                    ((WordValueAttribute)this._attributes[i]).addBits(flag);
                    return;
                }
                ++i;
            }
        }
        this.addAttribute(WordValueAttribute.callinFlagsAttribute(flag));
    }

    public static void addCallinFlag(AbstractMethodDeclaration methodDecl, int flag) {
        MethodModel.getModel(methodDecl).addCallinFlag(flag);
    }

    public static boolean hasCallinFlag(MethodBinding method, int flag) {
        MethodModel model = MethodModel.model(method);
        if (model == null) {
            return false;
        }
        return (model.callinFlags & flag) == flag;
    }

    public void markAsForbiddenCreationMethod() {
        this.isForbiddenCreationMethod = true;
    }

    public boolean isForbiddenCreationMethod() {
        return this.isForbiddenCreationMethod;
    }

    public void adjustSelfcall(MethodBinding oldCall, MethodBinding newCall) {
        this.oldSelfcall = oldCall;
        this.adjustedSelfcall = newCall;
        if (this._decl == null && !this._binding.declaringClass.isBinaryBinding()) {
            this._decl = this._binding.sourceMethod();
        }
        if (this._decl != null && this._decl instanceof ConstructorDeclaration) {
            ConstructorDeclaration ctor = (ConstructorDeclaration)this._decl;
            if (ctor.constructorCall != null) {
                ctor.constructorCall.binding = newCall;
            }
        }
    }

    public static boolean checkCreateModifiersAttribute(TypeDeclaration type, AbstractMethodDeclaration method) {
        if ((type.modifiers & 0x1200) != 0 && ((method.modifiers & 1) == 0 || method.isStatic())) {
            MethodModel model = MethodModel.getModel(method);
            model.addAttribute(WordValueAttribute.modifiersAttribute(method.modifiers));
            model._clearPrivateModifier = true;
            return true;
        }
        return false;
    }

    private void setupByteCode(boolean bytesRequired) {
        if (this._bytes == null || this._constantPoolOffsets == null) {
            try {
                MethodBinding binding;
                MethodBinding methodBinding = binding = this._binding == null ? this._decl.binding : this._binding;
                assert (binding.declaringClass.isTeam());
                ClassFileReader reader = null;
                if (this._bytes == null) {
                    if (this._classFile == null && this._decl != null) {
                        char[] className = binding.declaringClass.constantPoolName();
                        this._classFile = (ClassFile)this._decl.compilationResult.compiledTypes.get(className);
                        if (this._classFile != null && !this._classFile.isForType(binding.declaringClass)) {
                            this._classFile = null;
                        }
                    }
                    if (this._classFile != null && this._classFile.isForType(this._binding.declaringClass)) {
                        this._bytes = this._classFile.getBytes();
                        this._structOffset += this._classFile.headerOffset;
                        int olen = this._classFile.constantPool.currentIndex;
                        this._constantPoolOffsets = new int[olen];
                        System.arraycopy(this._classFile.constantPool.offsets, 0, this._constantPoolOffsets, 0, olen);
                        this._classFile = null;
                        return;
                    }
                }
                if (this._bytes != null) {
                    reader = new ClassFileReader(this._bytes, RoleModel.NO_SOURCE_FILE);
                } else {
                    if (binding.declaringClass.isTeam()) {
                        reader = binding.declaringClass.getTeamModel().read();
                    }
                    if (reader == null) {
                        if (bytesRequired) {
                            throw new InternalCompilerError("No byte code available for " + new String(binding.readableName()));
                        }
                        return;
                    }
                    this._bytes = reader.getBytes();
                }
                this._classFile = null;
                this._constantPoolOffsets = reader.getConstantPoolOffsets();
                char[] mySignature = this._binding.signature();
                IBinaryMethod[] iBinaryMethodArray = reader.getMethods();
                int n = iBinaryMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinaryMethod m = iBinaryMethodArray[n2];
                    if (CharOperation.equals(m.getSelector(), this._binding.selector) && CharOperation.equals(m.getMethodDescriptor(), mySignature)) {
                        this._structOffset = ((MethodInfo)m).getStructOffset();
                        return;
                    }
                    ++n2;
                }
                if (bytesRequired) {
                    throw new InternalCompilerError("Method " + String.valueOf(this._binding.readableName()) + "not found in class file " + String.valueOf(reader.getFileName()));
                }
            }
            catch (ClassFormatException ex) {
                throw new InternalCompilerError(ex.getMessage());
            }
            catch (IOException ex) {
                throw new InternalCompilerError(ex.getMessage());
            }
        }
    }

    public int[] getConstantPoolOffsets() {
        this.setupByteCode(true);
        return this._constantPoolOffsets;
    }

    public byte[] getBytes() {
        if (this._bytes == null) {
            this.setupByteCode(true);
        }
        return this._bytes;
    }

    public boolean hasBytes() {
        if (this._bytes == null) {
            this.setupByteCode(false);
        }
        return this._bytes != null;
    }

    public int getStructOffset() {
        return this._structOffset;
    }

    public void recordByteCode(byte[] bytes, int structOffset, int[] constantPoolOffsets) {
        this._bytes = bytes;
        this._structOffset = structOffset;
        int olen = constantPoolOffsets.length;
        this._constantPoolOffsets = new int[olen];
        System.arraycopy(constantPoolOffsets, 0, this._constantPoolOffsets, 0, olen);
    }

    public void recordByteCode(ClassFile classFile, int structOffset) {
        this._classFile = classFile;
        int[] offsets = classFile.constantPool.offsets;
        int olen = classFile.constantPool.currentIndex;
        this._constantPoolOffsets = new int[olen];
        System.arraycopy(offsets, 0, this._constantPoolOffsets, 0, olen);
        this._structOffset = structOffset;
    }

    public static boolean hasProblem(MethodBinding binding) {
        if ((binding.modifiers & 0x2000000) != 0) {
            return true;
        }
        AbstractMethodDeclaration ast = binding.sourceMethod();
        if (ast != null) {
            return ast.ignoreFurtherInvestigation;
        }
        MethodBinding original = binding.original();
        if (original != binding) {
            return MethodModel.hasProblem(original);
        }
        return false;
    }

    private void setCallsBaseCtor() {
        if (!this._callsBaseCtor) {
            this._callsBaseCtor = true;
            this.addAttribute(new PlainAttribute(IOTConstants.CALLS_BASE_CTOR));
        }
    }

    public void setStatementsGenerator(IStatementsGenerator generator) {
        assert (this._statementsGenerator == null);
        this._statementsGenerator = generator;
    }

    public boolean generateStatements() {
        if (this._statementsGenerator == null) {
            return false;
        }
        boolean result = this._statementsGenerator.generateAllStatements(this._decl);
        if (result) {
            this._decl.resolveStatements();
        }
        this._statementsGenerator = null;
        return result;
    }

    public static void prependStatements(AbstractMethodDeclaration method, List<Statement> newStatements) {
        if (method.model != null && method.model._statementsGenerator != null) {
            method.model._statementsGenerator.prepend(newStatements);
        } else {
            int methodLen = method.statements == null ? 0 : method.statements.length;
            int newLen = newStatements.size();
            Statement[] newStats = new Statement[newLen + methodLen];
            if (methodLen > 0) {
                System.arraycopy(method.statements, 0, newStats, newLen, methodLen);
            }
            System.arraycopy(newStatements.toArray(), 0, newStats, 0, newLen);
            method.setStatements(newStats);
        }
    }

    public static void setCallsBaseCtor(ConstructorDeclaration decl) {
        MethodModel model = MethodModel.getModel(decl);
        model.setCallsBaseCtor();
    }

    public static void setCallsBaseCtor(MethodBinding binding) {
        MethodModel model = MethodModel.getModel(binding);
        model.setCallsBaseCtor();
    }

    public static boolean callsBaseCtor(MethodBinding method) {
        MethodModel model = MethodModel.model(method);
        if (model != null && model._callsBaseCtor) {
            return true;
        }
        if (method.copyInheritanceSrc != null) {
            Dependencies.ensureBindingState(method.copyInheritanceSrc.declaringClass, 25);
            return MethodModel.callsBaseCtor(method.copyInheritanceSrc);
        }
        return false;
    }

    public void storeModifiers(int modifiers) {
        this.addAttribute(WordValueAttribute.roleClassMethodModifiersAttribute(modifiers & 0xF));
        this._clearPrivateModifier = true;
        if (this._binding != null) {
            this._binding.tagBits |= 0x200L;
        }
    }

    public static int rewriteModifiersForBytecode(MethodBinding methodBinding) {
        MethodModel model = MethodModel.model(methodBinding);
        if (model != null) {
            return model.rewriteModifiersForBytecode();
        }
        return -1;
    }

    private int rewriteModifiersForBytecode() {
        if (this._attributes != null) {
            AbstractAttribute[] abstractAttributeArray = this._attributes;
            int n = this._attributes.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractAttribute attr = abstractAttributeArray[n2];
                if (attr.nameEquals(IOTConstants.MODIFIERS_NAME) || attr.nameEquals(IOTConstants.ROLECLASS_METHOD_MODIFIERS_NAME)) {
                    int flags = this._binding.modifiers;
                    int MASK = 7;
                    if (this._binding.declaringClass.isSynthInterface()) {
                        MASK |= 8;
                    } else {
                        int abstractStatic = 1032;
                        if ((flags & abstractStatic) == abstractStatic) {
                            MASK |= 0x400;
                        }
                    }
                    flags &= ~MASK;
                    return flags |= 1;
                }
                ++n2;
            }
        }
        return -1;
    }

    public static TypeBinding getReturnType(MethodBinding method) {
        MethodModel model = MethodModel.model(method);
        if (model != null && model._returnType != null) {
            return model._returnType;
        }
        if (method instanceof ProblemMethodBinding) {
            ProblemMethodBinding pmb = (ProblemMethodBinding)method;
            if (pmb.closestMatch != null) {
                return MethodModel.getReturnType(pmb.closestMatch);
            }
        }
        return method.returnType;
    }

    public static TypeVariableBinding checkedGetReturnTypeVariable(MethodBinding method) {
        TypeBinding originalReturn;
        if (method instanceof ParameterizedMethodBinding) {
            method = ((ParameterizedMethodBinding)method).original();
        }
        if ((originalReturn = method.returnType) != null && originalReturn.isTypeVariable()) {
            return (TypeVariableBinding)originalReturn;
        }
        return null;
    }

    public static boolean hasUnboundedReturnType(MethodBinding method) {
        TypeVariableBinding variableBinding = MethodModel.checkedGetReturnTypeVariable(method);
        if (variableBinding != null) {
            return variableBinding.firstBound == null;
        }
        return false;
    }

    public static void saveReturnType(MethodBinding binding, TypeBinding returnType) {
        MethodModel.getModel(binding).saveReturnType(returnType);
    }

    public static void saveReturnType(MethodDeclaration decl, TypeBinding returnType) {
        MethodModel.getModel(decl).saveReturnType(returnType);
    }

    private void saveReturnType(TypeBinding returnType) {
        this._returnType = returnType;
        if (returnType.isBaseType()) {
            int encodedType = 0;
            switch (returnType.id) {
                case 6: {
                    encodedType = 256;
                    break;
                }
                case 5: {
                    encodedType = 512;
                    break;
                }
                case 3: {
                    encodedType = 768;
                    break;
                }
                case 2: {
                    encodedType = 1024;
                    break;
                }
                case 4: {
                    encodedType = 1280;
                    break;
                }
                case 8: {
                    encodedType = 1536;
                    break;
                }
                case 9: {
                    encodedType = 1792;
                    break;
                }
                case 10: {
                    encodedType = 2048;
                    break;
                }
                case 7: {
                    encodedType = 2304;
                    break;
                }
                default: {
                    throw new InternalCompilerError("contradiction: base type but none of the known base types");
                }
            }
            this.addCallinFlag(encodedType);
        }
    }

    public static MethodBinding getClassPartMethod(MethodBinding ifcMethod) {
        ReferenceBinding roleIfc = ifcMethod.declaringClass;
        if (!roleIfc.isRole()) {
            return null;
        }
        ReferenceBinding roleClass = roleIfc.roleModel.getClassPartBinding();
        if (roleClass == null) {
            return null;
        }
        MethodBinding[] methods = roleClass.getMethods(ifcMethod.selector);
        if (methods == null) {
            return null;
        }
        MethodBinding[] methodBindingArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBinding method = methodBindingArray[n2];
            if (method.parameters.length == ifcMethod.parameters.length && CharOperation.equals(method.signature(), ifcMethod.signature())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isAbstract(MethodBinding binding) {
        if (binding.declaringClass.isSynthInterface()) {
            binding = MethodModel.getClassPartMethod(binding);
        }
        if (binding == null) {
            return true;
        }
        return binding.isAbstract();
    }

    public String toString() {
        if (this._binding != null) {
            return new String(this._binding.readableName());
        }
        StringBuilder output = new StringBuilder();
        this._decl.printReturnType(0, output).append(this._decl.selector).append('(');
        if (this._decl.arguments != null) {
            int i = 0;
            while (i < this._decl.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this._decl.arguments[i].print(0, output);
                ++i;
            }
        }
        output.append(')');
        return output.toString();
    }

    public static boolean isOverriding(MethodBinding methodBinding, CompilationUnitScope scope) {
        if (!methodBinding.declaringClass.isBinaryBinding()) {
            Dependencies.ensureBindingState(methodBinding.declaringClass, 22);
            return methodBinding.isOverriding();
        }
        ReferenceBinding currentClass = methodBinding.declaringClass.superclass();
        while (currentClass != null) {
            MethodBinding candidate = currentClass.getExactMethod(methodBinding.selector, methodBinding.parameters, scope);
            if (candidate != null && candidate.isValidBinding()) {
                return true;
            }
            currentClass = currentClass.superclass();
        }
        return false;
    }

    public static CalloutMappingDeclaration getImplementingInferredCallout(MethodBinding binding) {
        MethodModel model = MethodModel.model(binding);
        if (model == null) {
            return null;
        }
        return model._inferredCallout;
    }

    public static List<ReferenceBinding> getRoleHandledByThisWrapperMethod(AbstractMethodDeclaration wrapperDecl) {
        if (wrapperDecl.model == null || wrapperDecl.model._declaringMappings == null) {
            return Collections.emptyList();
        }
        ArrayList<ReferenceBinding> handledRoles = new ArrayList<ReferenceBinding>();
        for (CallinMappingDeclaration mapping : wrapperDecl.model._declaringMappings) {
            if (mapping.scope == null) continue;
            handledRoles.add(mapping.scope.enclosingSourceType());
        }
        return handledRoles;
    }

    public AstGenerator getSynthPosGen(TypeDeclaration hostTypeDecl, ReferenceBinding srcTypeBinding, CompilationResult srcCompilationResult, int srcPos) {
        int[] lineSeparatorPositions = srcCompilationResult.lineSeparatorPositions;
        if (lineSeparatorPositions != null) {
            int sourceLineNumber = Util.getLineNumber(srcPos, lineSeparatorPositions, 0, lineSeparatorPositions.length - 1);
            LineNumberProvider lineNumberProvider = TypeModel.getLineNumberProvider(hostTypeDecl);
            LineInfo mappedLineInfo = lineNumberProvider.addLineInfo(srcTypeBinding, sourceLineNumber, 1);
            CompilationResult hostCompilationResult = hostTypeDecl.compilationResult;
            int mappedSourceStart = hostCompilationResult.requestSyntheticSourcePosition(mappedLineInfo.getOutputStartLine());
            return new AstGenerator(mappedSourceStart, mappedSourceStart);
        }
        return null;
    }

    public static AstGenerator setupSourcePositionMapping(AbstractMethodDeclaration methodDecl, TypeDeclaration hostTypeDecl, RoleModel sourceRoleModel, AstGenerator defaultGen) {
        TypeDeclaration sourceRoleDecl = sourceRoleModel.getAst();
        if (sourceRoleDecl == null || sourceRoleDecl.isPurelyCopied) {
            return defaultGen;
        }
        MethodModel model = methodDecl.getModel();
        AstGenerator gen = model.getSynthPosGen(hostTypeDecl, sourceRoleModel.getBinding(), sourceRoleDecl.compilationResult, methodDecl.sourceStart);
        if (gen != null) {
            methodDecl.bodyStart = gen.sourceStart;
            methodDecl.bodyEnd = gen.sourceEnd;
            methodDecl.declarationSourceEnd = gen.sourceEnd;
            return gen;
        }
        return defaultGen;
    }

    public static enum FakeKind {
        NOT_FAKED,
        BASECALL_SURROGATE,
        ROLE_FEATURE_BRIDGE,
        TEAM_REGISTRATION_METHOD,
        BASE_FIELD_ACCESSOR;

    }

    public static enum ProblemDetail {
        NoProblem,
        RoleInheritsNonPublic,
        IllegalDefaultCtor;

    }
}

