/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SplitPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class UnresolvedReferenceBinding
extends ReferenceBinding {
    ReferenceBinding resolvedType;
    TypeBinding[] wrappers;
    UnresolvedReferenceBinding prototype;
    ReferenceBinding requestingType;
    Map<WrapInfo, UnresolvedReferenceBinding> deferredWrappableTypes;

    protected UnresolvedReferenceBinding(char[][] compoundName, PackageBinding packageBinding, ReferenceBinding requestingType) {
        this.compoundName = compoundName;
        this.sourceName = compoundName[compoundName.length - 1];
        this.fPackage = packageBinding;
        this.requestingType = requestingType;
        this.wrappers = null;
        this.prototype = this;
        this.computeId();
    }

    public UnresolvedReferenceBinding(UnresolvedReferenceBinding prototype) {
        super(prototype);
        this.resolvedType = prototype.resolvedType;
        this.wrappers = null;
        this.prototype = prototype.prototype;
    }

    @Override
    public TypeBinding clone(TypeBinding outerType) {
        if (this.resolvedType != null) {
            return this.resolvedType.clone(outerType);
        }
        UnresolvedReferenceBinding copy = new UnresolvedReferenceBinding(this);
        this.addWrapper(copy, null);
        return copy;
    }

    void addWrapper(TypeBinding wrapper, LookupEnvironment environment) {
        if (this.resolvedType != null) {
            wrapper.swapUnresolved(this, this.resolvedType, environment);
            return;
        }
        if (this.wrappers == null) {
            this.wrappers = new TypeBinding[]{wrapper};
        } else {
            int length = this.wrappers.length;
            this.wrappers = new TypeBinding[length + 1];
            System.arraycopy(this.wrappers, 0, this.wrappers, 0, length);
            this.wrappers[length] = wrapper;
        }
    }

    @Override
    public boolean isUnresolvedType() {
        return true;
    }

    @Override
    public String debugName() {
        return this.toString();
    }

    @Override
    public int depth() {
        int last = this.compoundName.length - 1;
        return CharOperation.occurencesOf('$', this.compoundName[last], 1);
    }

    @Override
    public boolean hasTypeBit(int bit) {
        return false;
    }

    @Override
    public TypeBinding prototype() {
        return this.prototype;
    }

    public ReferenceBinding resolve(LookupEnvironment environment, boolean convertGenericToRawType) {
        if (this != this.prototype) {
            ReferenceBinding targetType = this.prototype.resolve(environment, convertGenericToRawType);
            targetType = convertGenericToRawType && targetType != null && targetType.isRawType() ? (ReferenceBinding)environment.createAnnotatedType((TypeBinding)targetType, this.typeAnnotations) : this.resolvedType;
            return targetType;
        }
        ReferenceBinding targetType = this.resolvedType;
        if (targetType == null) {
            char[] typeName = this.compoundName[this.compoundName.length - 1];
            targetType = this.fPackage.getType0(typeName);
            if (targetType == this || targetType == null) {
                if (this.fPackage instanceof SplitPackageBinding) {
                    targetType = environment.askForType(this.fPackage, typeName, this.fPackage.enclosingModule);
                } else if (targetType == this) {
                    targetType = environment.askForType(this.compoundName, this.fPackage.enclosingModule);
                }
            }
            if ((targetType == null || targetType == this) && CharOperation.contains('.', typeName)) {
                targetType = environment.askForType(this.fPackage, CharOperation.replaceOnCopy(typeName, '.', '$'), this.fPackage.enclosingModule);
            }
            if (targetType == null || targetType == this) {
                if ((this.tagBits & 0x80L) == 0L && !environment.mayTolerateMissingType) {
                    environment.problemReporter.isClassPathCorrect(this.compoundName, environment.root.unitBeingCompleted, environment.missingClassFileLocation, false, this.requestingType);
                }
                targetType = environment.createMissingType(null, this.compoundName);
            }
            if (targetType.id != Integer.MAX_VALUE) {
                this.id = targetType.id;
            }
            this.setResolvedType(targetType, environment);
        }
        if (convertGenericToRawType) {
            targetType = (ReferenceBinding)environment.convertUnresolvedBinaryToRawType(targetType);
        }
        return targetType;
    }

    void setResolvedType(ReferenceBinding targetType, LookupEnvironment environment) {
        if (this.resolvedType == targetType) {
            return;
        }
        this.resolvedType = targetType;
        environment.updateCaches(this, targetType);
        if (this.wrappers != null) {
            TypeBinding[] typeBindingArray = this.wrappers;
            int n = this.wrappers.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding wrapper = typeBindingArray[n2];
                wrapper.swapUnresolved(this, targetType, environment);
                ++n2;
            }
        }
    }

    @Override
    public void swapUnresolved(UnresolvedReferenceBinding unresolvedType, ReferenceBinding unannotatedType, LookupEnvironment environment) {
        ReferenceBinding annotatedType;
        if (this.resolvedType != null) {
            return;
        }
        this.resolvedType = annotatedType = (ReferenceBinding)unannotatedType.clone(null);
        annotatedType.setTypeAnnotations(this.getTypeAnnotations(), environment.globalOptions.isAnnotationBasedNullAnalysisEnabled);
        environment.updateCaches(this, annotatedType);
        if (this.wrappers != null) {
            TypeBinding[] typeBindingArray = this.wrappers;
            int n = this.wrappers.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding wrapper = typeBindingArray[n2];
                wrapper.swapUnresolved(this, annotatedType, environment);
                ++n2;
            }
        }
    }

    public String toString() {
        if (this.hasTypeAnnotations()) {
            return super.annotatedDebugName() + "(unresolved)";
        }
        return "Unresolved type " + (this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED");
    }

    public TypeBinding deferredWrappableType(final Scope scope, final ReferenceBinding site, final ASTNode typedNode, final ProblemReporter originalReporter) {
        WrapInfo key = new WrapInfo(scope, site, typedNode, originalReporter);
        if (this.deferredWrappableTypes != null) {
            UnresolvedReferenceBinding existing = this.deferredWrappableTypes.get(key);
            if (existing != null) {
                return existing;
            }
        } else {
            this.deferredWrappableTypes = new HashMap<WrapInfo, UnresolvedReferenceBinding>();
        }
        UnresolvedReferenceBinding deferred = new UnresolvedReferenceBinding(this.compoundName, this.getPackage(), site){

            @Override
            public ReferenceBinding resolve(LookupEnvironment environment, boolean convertGenericToRawType) {
                ReferenceBinding type = UnresolvedReferenceBinding.this.resolve(environment, convertGenericToRawType);
                return (ReferenceBinding)RoleTypeCreator.maybeWrapUnqualifiedRoleType(scope, site, type, typedNode, originalReporter);
            }

            @Override
            public boolean hasTypeAnnotations() {
                return UnresolvedReferenceBinding.this.hasTypeAnnotations();
            }

            @Override
            public boolean hasNullTypeAnnotations() {
                return UnresolvedReferenceBinding.this.hasNullTypeAnnotations();
            }

            @Override
            public AnnotationBinding[] getAnnotations() {
                return UnresolvedReferenceBinding.this.getAnnotations();
            }
        };
        deferred.tagBits = this.tagBits;
        this.deferredWrappableTypes.put(key, deferred);
        return deferred;
    }

    static class WrapInfo {
        Scope scope;
        ReferenceBinding site;
        ASTNode typedNode;
        ProblemReporter originalReporter;

        WrapInfo(Scope scope, ReferenceBinding site, ASTNode typedNode, ProblemReporter originalReporter) {
            this.scope = scope;
            this.site = site;
            this.typedNode = typedNode;
            this.originalReporter = originalReporter;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.originalReporter == null ? 0 : this.originalReporter.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            result = 31 * result + (this.site == null ? 0 : this.site.hashCode());
            result = 31 * result + (this.typedNode == null ? 0 : this.typedNode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WrapInfo other = (WrapInfo)obj;
            if (this.originalReporter != other.originalReporter) {
                return false;
            }
            if (this.scope != other.scope) {
                return false;
            }
            if (TypeBinding.notEquals(this.site, other.site)) {
                return false;
            }
            return this.typedNode == other.typedNode;
        }
    }
}

