/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre.util;

import java.util.Iterator;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.Type;
import org.eclipse.objectteams.otre.OTConstants;

public class DebugUtil {
    public static InstructionList createPrintln(ConstantPoolGen cpg, InstructionFactory factory, String string) {
        InstructionList il = new InstructionList();
        ObjectType p_stream = new ObjectType("java.io.PrintStream");
        il.append((Instruction)factory.createFieldAccess("java.lang.System", "out", (Type)p_stream, (short)178));
        il.append((CompoundInstruction)new PUSH(cpg, String.valueOf(string) + "\n"));
        il.append((Instruction)factory.createInvoke("java.io.PrintStream", "print", (Type)Type.VOID, new Type[]{Type.STRING}, (short)182));
        return il;
    }

    public static InstructionList createPrintlnObj(InstructionFactory factory) {
        InstructionList il = new InstructionList();
        ObjectType p_stream = new ObjectType("java.io.PrintStream");
        il.append((Instruction)new DUP());
        il.append((Instruction)factory.createFieldAccess("java.lang.System", "out", (Type)p_stream, (short)178));
        il.append((Instruction)new SWAP());
        il.append((Instruction)factory.createInvoke("java.io.PrintStream", "print", (Type)Type.VOID, new Type[]{OTConstants.object}, (short)182));
        return il;
    }

    public static InstructionList createReportExc(InstructionFactory factory) {
        InstructionList il = new InstructionList();
        if (System.getProperty("ot.log.lift") == null) {
            il.append((Instruction)new POP());
        } else {
            ObjectType p_stream = new ObjectType("java.io.PrintStream");
            il.append((Instruction)factory.createFieldAccess("java.lang.System", "out", (Type)p_stream, (short)178));
            il.append((Instruction)new SWAP());
            il.append((Instruction)factory.createInvoke("java.io.PrintStream", "println", (Type)Type.VOID, new Type[]{OTConstants.object}, (short)182));
        }
        return il;
    }

    public static InstructionList createPrintlnInt(InstructionFactory factory) {
        InstructionList il = new InstructionList();
        ObjectType p_stream = new ObjectType("java.io.PrintStream");
        il.append((Instruction)new DUP());
        il.append((Instruction)factory.createFieldAccess("java.lang.System", "out", (Type)p_stream, (short)178));
        il.append((Instruction)new SWAP());
        il.append((Instruction)factory.createInvoke("java.io.PrintStream", "print", (Type)Type.VOID, new Type[]{Type.INT}, (short)182));
        return il;
    }

    public static InstructionList createPrintlnBool(ConstantPoolGen cp) {
        InstructionList il = new InstructionList();
        int out = cp.addFieldref("java.lang.System", "out", "Ljava/io/PrintStream;");
        int println = cp.addMethodref("java.io.PrintStream", "println", "(Z)V");
        il.append((Instruction)new DUP());
        il.append((Instruction)new GETSTATIC(out));
        il.append((Instruction)new SWAP());
        il.append((Instruction)new INVOKEVIRTUAL(println));
        return il;
    }

    public static void printIL(InstructionList il, ConstantPoolGen cpg) {
        int off = 0;
        Iterator it = il.iterator();
        while (it.hasNext()) {
            Instruction i = ((InstructionHandle)it.next()).getInstruction();
            off += i.produceStack(cpg);
            System.out.print(off -= i.consumeStack(cpg));
            System.out.println("  = " + i);
        }
    }
}

