/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm.verify;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.util.CheckClassAdapter;

public class OTCheckClassAdapter
extends CheckClassAdapter {
    static final int AccTeam = 32768;
    static final int AccValueParam = 32768;
    private static Method printAnalyzerResult;

    static {
        try {
            Class<CheckClassAdapter> checkClass = CheckClassAdapter.class;
            printAnalyzerResult = checkClass.getDeclaredMethod("printAnalyzerResult", MethodNode.class, Analyzer.class, PrintWriter.class);
            printAnalyzerResult.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new VerifyError(e.getMessage());
        }
        catch (SecurityException e) {
            throw new VerifyError(e.getMessage());
        }
    }

    public OTCheckClassAdapter(ClassVisitor cv, boolean checkDataFlow) {
        super(589824, cv, checkDataFlow);
    }

    public static void verify(ClassNode node, byte[] bytes, ClassLoader loader) throws VerifyError {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var5_6 = null;
        try (CapturingPrintWriter printWriter = new CapturingPrintWriter((OutputStream)out);){
            OTCheckClassAdapter.verify(new ClassReader(bytes), loader, false, printWriter);
            if (printWriter.errorText != null) {
                StringBuilder message = new StringBuilder();
                message.append(node.getClass().getSimpleName());
                message.append(" caused a verify error on ");
                message.append(node.name).append('.').append(printWriter.errorText);
                message.append('\n');
                message.append(out.toString());
                throw new VerifyError(message.toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void verify(ClassReader cr, ClassLoader loader, boolean dump, PrintWriter pw) {
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)new OTCheckClassAdapter((ClassVisitor)cn, false), 2);
        Type syperType = cn.superName == null ? null : Type.getObjectType((String)cn.superName);
        List methods = cn.methods;
        ArrayList<Type> interfaces = new ArrayList<Type>();
        Iterator i = cn.interfaces.iterator();
        while (i.hasNext()) {
            interfaces.add(Type.getObjectType((String)((String)i.next())));
        }
        int i2 = 0;
        while (i2 < methods.size()) {
            block6: {
                Analyzer a;
                MethodNode method;
                block5: {
                    method = (MethodNode)methods.get(i2);
                    OTVerifier verifier = new OTVerifier(Type.getObjectType((String)cn.name), syperType, interfaces, (cn.access & 0x200) != 0, loader);
                    a = new Analyzer((Interpreter)verifier);
                    if (loader != null) {
                        verifier.setClassLoader(loader);
                    }
                    try {
                        a.analyze(cn.name, method);
                        if (dump) break block5;
                        break block6;
                    }
                    catch (Exception e) {
                        e.printStackTrace(pw);
                    }
                }
                OTCheckClassAdapter.printAnalyzerResult(method, (Analyzer<BasicValue>)a, pw);
            }
            ++i2;
        }
        pw.flush();
    }

    static void printAnalyzerResult(MethodNode method, Analyzer<BasicValue> a, PrintWriter pw) {
        try {
            printAnalyzerResult.invoke(null, method, a, pw);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new VerifyError(e.getMessage());
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, this.adjustClassFlags(access), name, signature, superName, interfaces);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, this.adjustClassFlags(access));
    }

    protected int adjustClassFlags(int access) {
        return access & 0xFFFF7FFF;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return super.visitField(this.adjustFieldFlags(access), name, desc, signature, value);
    }

    private int adjustFieldFlags(int access) {
        return access & 0xFFFF7FFF;
    }

    static class CapturingPrintWriter
    extends PrintWriter {
        String errorText;

        private CapturingPrintWriter(OutputStream out) {
            super(out);
        }

        @Override
        public void println(String x) {
            super.println(x);
            this.errorText = x;
        }
    }

    static class OTVerifier
    extends SimpleVerifier {
        ClassLoader loader;

        public OTVerifier(Type objectType, Type syperType, List<Type> interfaces, boolean isInterface, ClassLoader loader) {
            super(393216, objectType, syperType, interfaces, isInterface);
            this.loader = new ShyLoader(loader);
        }

        protected boolean isAssignableFrom(Type t, Type u) {
            try {
                return super.isAssignableFrom(t, u);
            }
            catch (ShyLoader.LoadAttempted e) {
                return true;
            }
        }

        protected Class<?> getClass(Type t) {
            try {
                if (t.getSort() == 9) {
                    return Class.forName(t.getDescriptor().replace('/', '.'), false, this.loader);
                }
                return Class.forName(t.getClassName(), false, this.loader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    static class ShyLoader
    extends ClassLoader {
        Method findLoadedClass;

        public ShyLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                Class<?> loaded = this.findLoadedFromParent(name);
                if (loaded != null) {
                    return loaded;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LoadAttempted();
        }

        Class<?> findLoadedFromParent(String name) throws Exception {
            if (this.findLoadedClass == null) {
                this.findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                this.findLoadedClass.setAccessible(true);
            }
            ClassLoader parent = this.getParent();
            while (parent != null) {
                Class c = (Class)this.findLoadedClass.invoke((Object)parent, name);
                if (c != null) {
                    return c;
                }
                parent = parent.getParent();
            }
            return null;
        }

        static class LoadAttempted
        extends RuntimeException {
            LoadAttempted() {
            }
        }
    }
}

