/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractCreateDispatchCodeAdapter;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CreateDispatchCodeInOrgMethodAdapter
extends AbstractCreateDispatchCodeAdapter {
    private Method method;
    private int joinPointId;
    private int boundMethodId;

    public CreateDispatchCodeInOrgMethodAdapter(Method method, int joinPointId, int boundMethodId) {
        super(true);
        this.method = method;
        this.joinPointId = joinPointId;
        this.boundMethodId = boundMethodId;
    }

    @Override
    public boolean transform() {
        MethodNode orgMethod = this.getMethod(this.method);
        if ((orgMethod.access & 0x400) != 0) {
            return false;
        }
        orgMethod.instructions.clear();
        orgMethod.instructions.add(this.getDispatchCode(orgMethod, this.joinPointId, this.boundMethodId));
        orgMethod.maxStack = this.getMaxStack();
        orgMethod.maxLocals = this.getMaxLocals();
        return true;
    }

    @Override
    protected InsnList getBoxedArguments(Type[] args) {
        return this.getBoxingInstructions(args, true);
    }

    @Override
    protected InsnList createInstructionsToCheackTeams(MethodNode method) {
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new InsnNode(89));
        LabelNode label = new LabelNode();
        instructions.add((AbstractInsnNode)new JumpInsnNode(199, label));
        instructions.add((AbstractInsnNode)new InsnNode(87));
        instructions.add(this.createLoadIntConstant(this.boundMethodId));
        Type[] args = Type.getArgumentTypes((String)method.desc);
        instructions.add(this.getBoxingInstructions(args, (method.access & 8) != 0));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, this.name, ConstantMembers.callOrigStatic.getName(), ConstantMembers.callOrigStatic.getSignature()));
        Type returnType = Type.getReturnType((String)method.desc);
        instructions.add(this.getUnboxingInstructionsForReturnValue(returnType));
        instructions.add((AbstractInsnNode)label);
        return instructions;
    }
}

