/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBinding;
import org.eclipse.objectteams.internal.osgi.weaving.AspectBindingRegistry;
import org.eclipse.objectteams.internal.osgi.weaving.DelegatingTransformer;
import org.eclipse.objectteams.internal.osgi.weaving.OTWeavingHook;
import org.eclipse.objectteams.internal.osgi.weaving.TeamLoader;
import org.eclipse.objectteams.internal.osgi.weaving.WaitingTeamRecord;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.service.packageadmin.PackageAdmin;

@NonNullByDefault
public class BaseBundleLoadTrigger {
    private AspectBindingRegistry aspectBindingRegistry;
    @Nullable
    private PackageAdmin admin;
    private String baseBundleName;
    @Nullable
    private AspectBinding.BaseBundle baseBundle;
    private boolean otreAdded = false;
    private List<AspectBinding> aspectBindings = new ArrayList<AspectBinding>();

    public BaseBundleLoadTrigger(String bundleSymbolicName, @Nullable AspectBinding.BaseBundle baseBundle, AspectBindingRegistry aspectBindingRegistry, @Nullable PackageAdmin admin) {
        this.baseBundleName = bundleSymbolicName;
        this.baseBundle = baseBundle;
        this.aspectBindingRegistry = aspectBindingRegistry;
        this.admin = admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(WovenClass baseClass, Set<String> beingDefined, OTWeavingHook hook) {
        boolean useDynamicWeaver = hook.useDynamicWeaver;
        Object object = this;
        synchronized (object) {
            AspectBinding.BaseBundle baseBundle2 = this.baseBundle;
            if (!this.otreAdded) {
                this.otreAdded = true;
                BaseBundleLoadTrigger.addOTREImport(baseBundle2, this.baseBundleName, baseClass, useDynamicWeaver);
            }
        }
        object = this.aspectBindings;
        synchronized (object) {
            if (this.aspectBindings.isEmpty()) {
                this.aspectBindings.addAll(this.aspectBindingRegistry.getAdaptingAspectBindings(this.baseBundleName));
            }
        }
        ArrayList<WaitingTeamRecord> deferredTeamClasses = new ArrayList<WaitingTeamRecord>();
        for (AspectBinding aspectBinding : this.aspectBindings) {
            PackageAdmin admin2;
            if (!aspectBinding.hasScannedTeams) {
                TransformerPlugin.log(1, "Preparing aspect binding for base bundle " + this.baseBundleName);
            }
            if ((admin2 = this.admin) == null) {
                TransformerPlugin.log(4, "Cannot find aspect bundle " + aspectBinding.aspectPlugin);
                continue;
            }
            Bundle aspectBundle = aspectBinding.aspectBundle;
            if (aspectBundle == null) {
                Bundle[] aspectBundles = admin2.getBundles(aspectBinding.aspectPlugin, null);
                if (aspectBundles == null || aspectBundles.length == 0) {
                    TransformerPlugin.log(4, "Cannot find aspect bundle " + aspectBinding.aspectPlugin);
                    continue;
                }
                aspectBundle = aspectBundles[0];
                assert (aspectBundle != null) : "Package admin should not return a null array element";
            }
            if (!aspectBinding.hasScannedTeams) {
                aspectBinding.scanTeamClasses(aspectBundle, DelegatingTransformer.newTransformer(useDynamicWeaver, hook, baseClass.getBundleWiring()));
            }
            if (useDynamicWeaver) continue;
            aspectBinding.addImports(baseClass);
        }
        TeamLoader loading = new TeamLoader(deferredTeamClasses, beingDefined, useDynamicWeaver);
        AspectBinding.BaseBundle baseBundle3 = this.baseBundle;
        if (baseBundle3 != null) {
            loading.loadTeamsForBase(baseBundle3, baseClass, hook.getAspectPermissionManager());
        }
        if (!deferredTeamClasses.isEmpty()) {
            hook.addDeferredTeamClasses(deferredTeamClasses);
        }
        for (AspectBinding aspectBinding : this.aspectBindings) {
            String baseClassName = baseClass.getClassName();
            assert (baseClassName != null) : "WovenClass.getClassName() should not answer null";
            aspectBinding.cleanUp(baseClassName);
        }
    }

    static void addOTREImport(@Nullable AspectBinding.BaseBundle baseBundle, String baseBundleName, WovenClass baseClass, boolean useDynamicWeaver) {
        if (baseBundle != null) {
            if (baseBundle.otreAdded) {
                return;
            }
            baseBundle.otreAdded = true;
        }
        TransformerPlugin.log(1, "Adding OTRE import to " + baseBundleName);
        List imports = baseClass.getDynamicImports();
        imports.add("org.objectteams");
        if (useDynamicWeaver) {
            imports.add("org.eclipse.objectteams.otredyn.runtime");
        }
    }

    public boolean isDone() {
        for (AspectBinding binding : this.aspectBindings) {
            if (binding.isDone()) continue;
            return false;
        }
        return true;
    }

    public boolean areAllAspectsDenied() {
        for (AspectBinding binding : this.aspectBindings) {
            if (binding.hasBeenDenied) continue;
            return false;
        }
        return true;
    }
}

