/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.objectteams.otdt.core.IOTJavaElement;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.OTDTUIPluginConstants;
import org.eclipse.objectteams.otdt.internal.ui.OTElementAdapterFactory;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.CallinMarkerCreator2;
import org.eclipse.objectteams.otdt.internal.ui.callinmarkers.RoleBindingChangedListener;
import org.eclipse.objectteams.otdt.internal.ui.preferences.GeneralPreferences;
import org.eclipse.objectteams.otdt.ui.ImageManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class OTDTUIPlugin
extends AbstractUIPlugin
implements OTDTUIPluginConstants {
    private OTElementAdapterFactory _otElementAdapterFactory;
    private static OTDTUIPlugin _singleton;
    private ResourceBundle _resourceBundle;
    private RoleBindingChangedListener _baseClassChangedListener;
    private CallinMarkerCreator2 _callinMarkerCreator;

    public OTDTUIPlugin() {
        _singleton = this;
        try {
            this._resourceBundle = ResourceBundle.getBundle("org.eclipse.objectteams.otdt.ui.OTPluginResources");
        }
        catch (MissingResourceException ex) {
            OTDTUIPlugin.logException("Error initializing resource bundle of OTDT/UI", ex);
            this._resourceBundle = null;
        }
    }

    public static OTDTUIPlugin getDefault() {
        return _singleton;
    }

    public static IWorkbenchPage getActivePage() {
        return OTDTUIPlugin.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = OTDTUIPlugin.getDefault()._resourceBundle;
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageManager.getSharedInstance().registerPluginImages(reg);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        GeneralPreferences.initDefaults(this.getPreferenceStore());
        this.registerAdapter();
        this.addJavaElementChangedListeners();
        this.getCallinMarkerCreator();
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterAdapter();
        this.removeElementChangedListeners();
        if (this._callinMarkerCreator != null) {
            this._callinMarkerCreator.uninstallListener();
            this._callinMarkerCreator = null;
        }
        OTModelManager.dispose();
        super.stop(context);
    }

    public static void logException(String message, Throwable exception) {
        _singleton.getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.ui", 0, message, exception));
    }

    public static void log(Throwable t) {
        _singleton.getLog().log((IStatus)new Status(4, "org.eclipse.objectteams.otdt.ui", t.getMessage(), t));
    }

    public static Status createErrorStatus(String message, Throwable exception) {
        return new Status(4, "org.eclipse.objectteams.otdt.ui", 0, message, exception);
    }

    private void registerAdapter() {
        this._otElementAdapterFactory = new OTElementAdapterFactory();
        IAdapterManager manager = Platform.getAdapterManager();
        manager.registerAdapters((IAdapterFactory)this._otElementAdapterFactory, IOTJavaElement.class);
    }

    private void unregisterAdapter() {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this._otElementAdapterFactory, IOTJavaElement.class);
    }

    private void addJavaElementChangedListeners() {
        this._baseClassChangedListener = new RoleBindingChangedListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this._baseClassChangedListener, (int)5);
    }

    private void removeElementChangedListeners() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this._baseClassChangedListener);
        this._baseClassChangedListener = null;
    }

    public CallinMarkerCreator2 getCallinMarkerCreator() {
        if (this._callinMarkerCreator == null) {
            try {
                this._callinMarkerCreator = new CallinMarkerCreator2();
            }
            catch (IllegalStateException e) {
                OTDTUIPlugin.logException("Failed to activate callin marker creator", e);
            }
        }
        return this._callinMarkerCreator;
    }
}

