/*******************************************************************************
 * Copyright (c) 2000, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Technical University Berlin - extended API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.codeassist.select;

/*
 * Scanner aware of a selection range. If finding an identifier which source range is exactly
 * the same, then will record it so that the parser can make use of it.
 *
 * Source positions are zero-based and inclusive.
 */
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;

public class SelectionScanner extends Scanner {

	public char[] selectionIdentifier;
	public int selectionStart, selectionEnd;
/*
 * Truncate the current identifier if it is containing the cursor location. Since completion is performed
 * on an identifier prefix.
 *
 */

public SelectionScanner(long sourceLevel) {
	super(false /*comment*/, false /*whitespace*/, false /*nls*/, sourceLevel, null /*taskTags*/, null/*taskPriorities*/, true/*taskCaseSensitive*/);
}

protected boolean isAtAssistIdentifier() {
	return this.selectionStart == this.startPosition && this.selectionEnd == this.currentPosition - 1;
}

public char[] getCurrentIdentifierSource() {

	if (this.selectionIdentifier == null){
		if (this.selectionStart == this.startPosition && this.selectionEnd == this.currentPosition-1){
			if (this.withoutUnicodePtr != 0){			// check unicode scenario
				System.arraycopy(this.withoutUnicodeBuffer, 1, this.selectionIdentifier = new char[this.withoutUnicodePtr], 0, this.withoutUnicodePtr);
			} else {
				int length = this.currentPosition - this.startPosition;
				// no char[] sharing around completionIdentifier, we want it to be unique so as to use identity checks
				System.arraycopy(this.source, this.startPosition, (this.selectionIdentifier = new char[length]), 0, length);
			}
			return this.selectionIdentifier;
		}
	}
	return super.getCurrentIdentifierSource();
}
/*
 * In case we actually read a keyword which corresponds to the selected
 * range, we pretend we read an identifier.
 */
public int scanIdentifierOrKeyword() {

	int id = super.scanIdentifierOrKeyword();

	// convert completed keyword into an identifier
	if (id != TokenNameIdentifier
		&& this.startPosition == this.selectionStart
		&& this.currentPosition == this.selectionEnd+1){
//{ObjectTeams: don't convert 'base' to identifier but still store it:
		if (id == TokenNamebase) {
			this.selectionIdentifier= IOTConstants.BASE;
			return id;
		}
// SH}
		return TokenNameIdentifier;
	}
	return id;
}
}
